/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.admin.PropertyDescriptions;
import com.atlassian.jira.admin.PropertyPersister;
import com.atlassian.jira.admin.RenderableProperty;
import com.atlassian.jira.admin.RenderablePropertyFactory;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomFieldDescription {
    private final RenderablePropertyFactory renderablePropertyFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final JiraAuthenticationContext authenticationContext;

    public CustomFieldDescription(RenderablePropertyFactory renderablePropertyFactory, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext authenticationContext) {
        this.renderablePropertyFactory = renderablePropertyFactory;
        this.i18nFactory = i18nFactory;
        this.authenticationContext = authenticationContext;
    }

    @Nonnull
    public RenderableProperty createRenderablePropertyFor(@Nullable CustomField customField) {
        if (customField == null) {
            return this.renderablePropertyFactory.create(new EmptyPropertyPersister(), new CustomFieldDescriptions());
        }
        return this.renderablePropertyFactory.create(new ReadOnlyPersister(customField), new CustomFieldDescriptions());
    }

    @Nonnull
    public RenderableProperty createRenderablePropertyFor(String description) {
        return this.renderablePropertyFactory.create(new ReadOnlyTextPersister(description), new CustomFieldDescriptions());
    }

    final String getText(String key, String ... params) {
        return this.i18nFactory.getInstance(this.authenticationContext.getUser()).getText(key, (Object)params);
    }

    private static class EmptyPropertyPersister
    implements PropertyPersister {
        private EmptyPropertyPersister() {
        }

        @Override
        public String load() {
            return "";
        }

        @Override
        public void save(String value) {
            throw new UnsupportedOperationException();
        }
    }

    private class CustomFieldDescriptions
    implements PropertyDescriptions {
        private CustomFieldDescriptions() {
        }

        @Override
        public String getBtfDescriptionHtml() {
            return CustomFieldDescription.this.getText("admin.issuefields.customfields.edit.description.detail", "<br/>");
        }

        @Override
        public String getOnDemandDescriptionHtml() {
            return CustomFieldDescription.this.getText("admin.issuefields.customfields.edit.description.wiki.detail", "<br/>");
        }
    }

    private static class ReadOnlyPersister
    implements PropertyPersister {
        private final CustomField customField;

        public ReadOnlyPersister(CustomField customField) {
            this.customField = customField;
        }

        @Override
        public String load() {
            return this.customField.getDescription();
        }

        @Override
        public void save(String value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadOnlyTextPersister
    implements PropertyPersister {
        private final String desc;

        public ReadOnlyTextPersister(String desc) {
            this.desc = desc;
        }

        @Override
        public String load() {
            return this.desc;
        }

        @Override
        public void save(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

