/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import java.util.Objects;
import javax.annotation.Nullable;

public class FieldId {
    private static final String CUSTOMFIELD_PREFIX = "customfield_";
    private final String fullId;

    private FieldId(String fullId) {
        this.fullId = fullId;
    }

    public static FieldId fromCustomFieldId(long id) {
        if (id < 0L) {
            throw new IllegalArgumentException();
        }
        return new FieldId(CUSTOMFIELD_PREFIX + id);
    }

    public static FieldId fromFullId(String id) {
        if (id.startsWith(CUSTOMFIELD_PREFIX)) {
            return FieldId.fromCustomFieldId(Long.parseLong(id.substring(CUSTOMFIELD_PREFIX.length())));
        }
        return new FieldId(id);
    }

    public String toString() {
        return String.format("FieldId[%s]", this.fullId);
    }

    public String toFullId() {
        return this.fullId;
    }

    public boolean isCustomField() {
        return this.fullId.startsWith(CUSTOMFIELD_PREFIX);
    }

    public boolean isSystemField() {
        return !this.isCustomField();
    }

    public long getCustomFieldId() {
        if (this.isCustomField()) {
            return Long.parseLong(this.fullId.substring(CUSTOMFIELD_PREFIX.length()));
        }
        throw new IllegalStateException("Not a custom field");
    }

    @Nullable
    public Long getCustomFieldIdOrNull() {
        return this.isCustomField() ? Long.valueOf(this.getCustomFieldId()) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.fullId, ((FieldId)o).fullId);
    }

    public int hashCode() {
        return Objects.hash(this.fullId);
    }
}

