/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueConstants;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractPickerFieldImpl;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.option.FieldConfigSchemeOption;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.SuggestionBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SuggestionBean;
import com.atlassian.jira.issue.fields.rest.json.beans.SuggestionGroupBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.IssueTypeSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.IssueTypeStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.mail.util.MailAttachmentsManagerImpl;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class IssueTypeSystemField
extends AbstractPickerFieldImpl<IssueType>
implements IssueTypeField,
RestAwareField,
ExportableSystemField {
    private static final Logger log = LoggerFactory.getLogger(IssueTypeSystemField.class);
    private static final String ISSUE_TYPE_NAME_KEY = "issue.field.issuetype";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final ConstantsManager constantsManager;
    private final WorkflowManager workflowManager;
    private final IssueTypeStatisticsMapper issueTypeStatisticsMapper;
    private final OptionSetManager optionSetManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final BaseUrl baseUrl;
    private final SuggestionBeanFactory suggestionBeanFactory;
    private final StatusManager statusManager;

    public IssueTypeSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, WorkflowManager workflowManager, PermissionManager permissionManager, IssueTypeStatisticsMapper issueTypeStatisticsMapper, OptionSetManager optionSetManager, IssueTypeSchemeManager issueTypeSchemeManager, IssueTypeSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls, BaseUrl baseUrl, SuggestionBeanFactory suggestionBeanFactory, StatusManager statusManager) {
        super("issuetype", ISSUE_TYPE_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, searchHandlerFactory);
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.issueTypeStatisticsMapper = issueTypeStatisticsMapper;
        this.optionSetManager = optionSetManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.baseUrl = baseUrl;
        this.suggestionBeanFactory = suggestionBeanFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.statusManager = statusManager;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.prepareVelocityParams(fieldLayoutItem, action, issue, displayParameters, operationContext);
        try {
            this.populateOptionsForProjects(velocityParams, issue, displayParameters, issue.isSubTask() ? IssueTypeKind.SUBTASK : IssueTypeKind.ISSUE, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        velocityParams.put("createOperation", Boolean.TRUE);
        return this.renderTemplate("issuetype-edit.vm", velocityParams);
    }

    private List populateOptionsForProjects(Map<String, Object> velocityParams, Issue issue, Map displayParameters, IssueTypeKind issueTypeKind, Collection<String> issueTypeSkip) throws IOException {
        ProjectSystemField projectField = (ProjectSystemField)this.getParentField();
        Collection<Project> allowedProjects = issueTypeKind == IssueTypeKind.SUBTASK && issue != null ? Arrays.asList(issue.getProjectObject()) : projectField.getAllowedProjects();
        ListOrderedMap projectToConfig = new ListOrderedMap();
        HashSet<FieldConfigScheme> releventConfigs = new HashSet<FieldConfigScheme>();
        for (Project project : allowedProjects) {
            FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(project);
            FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
            if (relevantConfig == null) continue;
            releventConfigs.add(configScheme);
            projectToConfig.put(project.getId().toString(), relevantConfig.getId().toString());
        }
        velocityParams.put("projectToConfigJson", mapper.writeValueAsString((Object)projectToConfig));
        ArrayList configOptions = Lists.newArrayList();
        boolean selectedOptionExists = false;
        String selectedOption = (String)velocityParams.get(this.getId());
        for (FieldConfigScheme configScheme : releventConfigs) {
            FieldConfig config = configScheme.getOneAndOnlyConfig();
            ArrayList<Option> options = new ArrayList<Option>(this.getOptionsForConfig(config, (IssueContext)issue, displayParameters, issueTypeKind, issueTypeSkip));
            if (options.isEmpty()) continue;
            if (issueTypeKind != IssueTypeKind.SUBTASK && this.issueTypeSchemeManager.getDefaultValue(config) == null) {
                TextOption pleaseSelect = new TextOption("", this.authenticationContext.getI18nHelper().getText("common.words.pleaseselect"));
                options.add(0, (Option)pleaseSelect);
            }
            if (!selectedOptionExists && selectedOption != null) {
                selectedOptionExists = Iterables.any(options, (com.google.common.base.Predicate)new OptionPredicate(selectedOption));
            }
            configOptions.add(new SuggestionGroupBean(config.getId().toString(), this.suggestionBeanFactory.optionSuggestions(options, Optional.ofNullable(selectedOption))));
        }
        if (!(configOptions.isEmpty() || selectedOption != null && selectedOptionExists)) {
            velocityParams.put(this.getId(), ((SuggestionBean)Iterables.get((Iterable)((SuggestionGroupBean)configOptions.get(0)).getItems(), (int)0)).getValue());
            ((SuggestionBean)Iterables.get((Iterable)((SuggestionGroupBean)configOptions.get(0)).getItems(), (int)0)).setSelected(true);
        }
        if (configOptions.size() == 1) {
            velocityParams.put("configOptionsJson", mapper.writeValueAsString((Object)((SuggestionGroupBean)configOptions.get(0)).getItems()));
        } else {
            velocityParams.put("configOptionsJson", mapper.writeValueAsString((Object)configOptions));
        }
        Map<Long, String> configToDefaultOption = releventConfigs.stream().map(FieldConfigScheme::getOneAndOnlyConfig).collect(Collectors.toMap(c -> c.getId(), c -> Optional.ofNullable(this.issueTypeSchemeManager.getDefaultValue(c)).map(it -> it.getId()).orElse("")));
        velocityParams.put("configToDefaultOptionJson", mapper.writeValueAsString(configToDefaultOption));
        return configOptions;
    }

    private boolean isMoveIssue(Map displayParameters, IssueContext issue) {
        return displayParameters.containsKey("moveissue") && Boolean.TRUE.equals(displayParameters.get("moveissue")) && issue != null;
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.prepareVelocityParams(fieldLayoutItem, action, issue, displayParameters, operationContext);
        FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(issue.getProject());
        FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
        Collection options = this.getOptionsForConfig(relevantConfig, issue, displayParameters);
        if ((options = CollectionUtils.select(options, (Predicate)new ValidForEditIssueTypes((IssueContext)issue, displayParameters))).size() > 1) {
            this.updateFieldValueIfInvalid(velocityParams, options);
            Collection<SuggestionBean> suggestions = this.suggestionBeanFactory.optionSuggestions(options, Optional.ofNullable((String)velocityParams.get(this.getId())));
            try {
                velocityParams.put("configOptionsJson", mapper.writeValueAsString(suggestions));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.renderTemplate("issuetype-edit.vm", velocityParams);
        }
        velocityParams.put("noAllowedIssueTypes", Boolean.TRUE);
        velocityParams.put("hasMovePermission", this.userHasMovePermission(issue));
        velocityParams.put("issue", issue);
        return this.renderTemplate("issuetype-edit-not-allowed.vm", velocityParams);
    }

    @VisibleForTesting
    boolean userHasMovePermission(@Nonnull Issue issue) {
        return this.getPermissionManager().hasPermission(ProjectPermissions.MOVE_ISSUES, issue, this.getAuthenticationContext().getUser());
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Map<String, Object> velocityParams = this.prepareVelocityParams(null, action, null, displayParameters, operationContext);
        try {
            if ("BulkMove".equals(bulkEditBean.getOperationName()) || "BulkMigrate".equals(bulkEditBean.getOperationName())) {
                if (bulkEditBean.getParentBulkEditBean() == null) {
                    this.populateOptionsForProjects(velocityParams, null, displayParameters, IssueTypeKind.ALL, null);
                } else {
                    this.populateOptionsForProjects(velocityParams, null, displayParameters, IssueTypeKind.SUBTASK, null);
                }
            } else {
                Collection<Option> options = this.getAllowedIssueTypeOptionsForEdit(bulkEditBean.getSelectedIssues(), displayParameters);
                this.updateFieldValueIfInvalid(velocityParams, options);
                Collection<SuggestionBean> suggestions = this.suggestionBeanFactory.optionSuggestions(options, Optional.ofNullable((String)velocityParams.get(this.getId())));
                velocityParams.put("configOptionsJson", mapper.writeValueAsString(suggestions));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.renderTemplate("issuetype-edit.vm", velocityParams);
    }

    public String getEditHtml(OperationContext operationContext, Action action, List options) {
        Map<String, Object> velocityParams = this.prepareVelocityParams(null, action, null, EasyMap.build(), operationContext);
        velocityParams.put("configOptions", EasyList.build((Object)((Object)new FieldConfigSchemeOption(null, options))));
        this.updateFieldValueIfInvalid(velocityParams, options);
        Collection<SuggestionBean> suggestions = this.suggestionBeanFactory.optionSuggestions(options, Optional.ofNullable((String)velocityParams.get(this.getId())));
        try {
            velocityParams.put("configOptionsJson", mapper.writeValueAsString(suggestions));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.renderTemplate("issuetype-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        IssueType issueType = issue.getIssueTypeObject();
        velocityParams.put("issueTypeObject", issueType);
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, IssueType issueType, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("issueTypeObject", issueType);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("issuetype-view.vm", velocityParams);
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        IssueType issueType = this.getDefaultValue(issue);
        if (issueType != null) {
            fieldValuesHolder.put(this.getId(), issueType.getId());
        }
    }

    public IssueType getDefaultValue(Issue issue) {
        return this.issueTypeSchemeManager.getDefaultValue(issue);
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        issue.setIssueTypeObject(this.getValueFromParams(fieldValueHolder));
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(true);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public boolean hasValue(Issue issue) {
        return issue.getIssueTypeObject() != null;
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String issueTypeId = (String)fieldValuesHolder.get(this.getId());
        if (issueTypeId == null) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.noissuetype"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (this.getValueFromParams(fieldValuesHolder) == null) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.invalidissuetype"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else {
            IssueType issueTypeObject;
            boolean bulkMigrate = false;
            if (operationContext instanceof BulkEditBean) {
                BulkEditBean bulkEditBean = (BulkEditBean)operationContext;
                bulkMigrate = "BulkMigrate".equals(bulkEditBean.getOperationName());
            }
            if ((issueTypeObject = this.constantsManager.getIssueType(issueTypeId)).isSubTask() && !issue.isSubTask()) {
                if (!bulkMigrate) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("createsubtask.error.noparentissuekey"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            } else if (!issueTypeObject.isSubTask() && issue.isSubTask()) {
                if (!bulkMigrate) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("createsubtask.error.issuetypenotsubtask", issueTypeId), ErrorCollection.Reason.VALIDATION_FAILED);
                }
            } else if (issueTypeObject.isSubTask() && issue.getParentObject() != null && issue.getParentObject().isSubTask()) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("convert.issue.to.subtask.error.parentissubtask", String.format("ID: '%s' / Key: '%s'", issue.getParentObject().getId(), issue.getParentObject().getKey())));
            } else {
                Collection allowedIssueTypeOptions = this.getOptionsForIssue(issue);
                if (!allowedIssueTypeOptions.contains((Object)new IssueConstantOption((IssueConstant)issueTypeObject))) {
                    errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.invalidissuetype"), ErrorCollection.Reason.VALIDATION_FAILED);
                }
                this.validateStatusIsLegalInWorkflow(errorCollectionToAddTo, i18n, issue, issueTypeId);
            }
        }
    }

    private void validateStatusIsLegalInWorkflow(ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, String issueTypeId) {
        if (issue.getProjectId() != null && issueTypeId != null) {
            JiraWorkflow newWorkflow = this.workflowManager.getWorkflow(issue.getProjectId(), issueTypeId);
            List allowedStatuses = newWorkflow.getLinkedStatusObjects();
            if (issue.getStatus() != null && !allowedStatuses.contains(issue.getStatus())) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.status.and.workflow.inconsistency"));
            }
        }
    }

    public IssueType getValueFromParams(Map params) {
        String issueTypeId = (String)params.get(this.getId());
        if (TextUtils.stringSet((String)issueTypeId)) {
            return this.constantsManager.getIssueType(issueTypeId);
        }
        return null;
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        Long issuetypeId = null;
        try {
            issuetypeId = Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            issuetypeId = this.getIssueTypeIdByName(stringValue);
        }
        fieldValuesHolder.put(this.getId(), issuetypeId.toString());
    }

    private Long getIssueTypeIdByName(String stringValue) throws FieldValidationException {
        for (IssueType issueTypeGV : this.constantsManager.getAllIssueTypeObjects()) {
            if (!stringValue.equalsIgnoreCase(issueTypeGV.getName())) continue;
            return Long.valueOf(issueTypeGV.getId());
        }
        throw new FieldValidationException("Invalid issue type name '" + stringValue + "'.");
    }

    public void createValue(Issue issue, IssueType value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                IssueType issueType = (IssueType)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, issueType.getId(), issueType.getName());
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            IssueType currentIssueType = (IssueType)currentValue;
            if (value != null) {
                IssueType issueType = (IssueType)value;
                cib = new ChangeItemBean("jira", this.getId(), currentIssueType.getId(), currentIssueType.getName(), issueType.getId(), issueType.getName());
            } else {
                cib = new ChangeItemBean("jira", this.getId(), currentIssueType.getId(), currentIssueType.getName(), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        List selectedIssues = bulkEditBean.getSelectedIssues();
        for (Issue issue : selectedIssues) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.multiproject.unavailable.permission";
        }
        if (this.isHasCommonIssueTypes(selectedIssues)) {
            return "bulk.edit.issuetype.noissuetypes";
        }
        return null;
    }

    public boolean isHasCommonIssueTypes(Collection selectedIssues) {
        return this.getAllowedIssueTypeOptionsForEdit(selectedIssues, new HashMap()).isEmpty();
    }

    private Collection<Option> getAllowedIssueTypeOptionsForEdit(Collection issues, Map displayParameters) {
        Iterator iterator = issues.iterator();
        Issue issue = (Issue)iterator.next();
        Collection availableIssueTypes = CollectionUtils.select(new ArrayList(this.getOptionsForIssue(issue)), (Predicate)new ValidForEditIssueTypes((IssueContext)issue, displayParameters));
        while (!availableIssueTypes.isEmpty() && iterator.hasNext()) {
            issue = (Issue)iterator.next();
            Collection newOptions = this.getOptionsForIssue(issue);
            newOptions = CollectionUtils.select((Collection)newOptions, (Predicate)new ValidForEditIssueTypes((IssueContext)issue, displayParameters));
            availableIssueTypes.retainAll(newOptions);
        }
        return availableIssueTypes;
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        String[] value = params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), issue.getIssueTypeId());
    }

    private FieldLayoutManager getFieldLayoutManager() {
        return ComponentAccessor.getFieldLayoutManager();
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.issuetype";
    }

    public String getDefaultSortOrder() {
        return "DESC";
    }

    public LuceneFieldSorter getSorter() {
        return this.issueTypeStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        IssueType issueType = issue.getIssueType();
        boolean emailView = Optional.ofNullable((Boolean)displayParams.get("email_view")).orElse(false);
        Optional<String> iconUrl = emailView ? this.getIconUrlForEmail(issueType, displayParams) : this.getAbsoluteIconUrl(issueType);
        velocityParams.put("issue", issue);
        velocityParams.put(this.getId(), issueType);
        velocityParams.put("iconurl", iconUrl);
        return this.renderTemplate("issuetype-columnview.vm", velocityParams);
    }

    private Optional<String> getAbsoluteIconUrl(IssueType issueType) {
        try {
            String strippedIssueTypeIconUrl = StringUtils.stripStart((String)issueType.getIconUrl(), (String)"/");
            URI issueTypeIconUri = URI.create(strippedIssueTypeIconUrl);
            String absoluteUrl = StringEscapeUtils.escapeHtml4((String)this.baseUrl.getBaseUri().resolve(issueTypeIconUri).toString());
            return Optional.ofNullable(absoluteUrl);
        }
        catch (Exception e) {
            log.warn("Unable to get URI for issue type. Probably the URI provided is malformed.");
            return Optional.empty();
        }
    }

    private Optional<String> getIconUrlForEmail(IssueType issueType, Map<String, Object> displayParams) {
        Optional<MailAttachmentsManagerImpl> mailAttachmentsManager = Optional.ofNullable((MailAttachmentsManagerImpl)displayParams.get("attachmentsManager"));
        return mailAttachmentsManager.map(manager -> manager.getIssueTypeIconUrl(issueType));
    }

    public Collection<Option> getOptionsForIssue(Issue issue, boolean isSubTask) {
        FieldConfig relevantConfig = this.getRelevantConfig((IssueContext)issue);
        return this.getOptionsForConfig(relevantConfig, (IssueContext)issue, EasyMap.build(), isSubTask ? IssueTypeKind.SUBTASK : IssueTypeKind.ISSUE, null);
    }

    public List getConfigurationItemTypes() {
        return Collections.emptyList();
    }

    public List<Project> getAssociatedProjectObjects() {
        return ((FieldConfigSchemeManager)ComponentAccessor.getComponent(FieldConfigSchemeManager.class)).getAssociatedProjectObjects((ConfigurableField)this);
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext) {
        return ((FieldConfigSchemeManager)ComponentAccessor.getComponent(FieldConfigSchemeManager.class)).getRelevantConfig(issueContext, (ConfigurableField)this);
    }

    public Field getParentField() {
        return ComponentAccessor.getFieldManager().getField("project");
    }

    private Collection getOptionsForIssue(Issue issue) {
        FieldConfig relevantConfig = this.getRelevantConfig((IssueContext)issue);
        return this.getOptionsForConfig(relevantConfig, issue, EasyMap.build());
    }

    private Collection<Option> getOptionsForConfig(FieldConfig fieldConfig, Issue issue, Map displayParameters) {
        return this.getOptionsForConfig(fieldConfig, (IssueContext)issue, displayParameters, issue.isSubTask() ? IssueTypeKind.SUBTASK : IssueTypeKind.ISSUE, null);
    }

    private Collection<Option> getOptionsForConfig(FieldConfig fieldConfig, IssueContext issue, Map displayParameters, IssueTypeKind issueTypeKind, Collection<String> issueTypeSkip) {
        Collection options = this.optionSetManager.getOptionsForConfig(fieldConfig).getOptions();
        options = CollectionUtils.select((Collection)options, (Predicate)new ValidIssueTypePredicate(issue, displayParameters, issueTypeKind, issueTypeSkip));
        return options;
    }

    private Map<String, Object> prepareVelocityParams(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters, OperationContext operationContext) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters, this.getAuthenticationContext().getI18nHelper());
        String issueTypeId = (String)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put(this.getId(), issueTypeId);
        if (issueTypeId != null && this.constantsManager.getIssueType(issueTypeId) != null) {
            velocityParams.put("issueTypeObject", this.constantsManager.getIssueType(issueTypeId));
        }
        return velocityParams;
    }

    private void updateFieldValueIfInvalid(Map<String, Object> velocityParams, Collection<Option> availableOptions) {
        if (!availableOptions.isEmpty()) {
            boolean isValidIssueTypeOption;
            String selectedIssueTypeKey = this.getId();
            String issueTypeId = (String)velocityParams.get(selectedIssueTypeKey);
            boolean bl = isValidIssueTypeOption = issueTypeId != null && Iterables.any(availableOptions, (com.google.common.base.Predicate)new OptionPredicate(issueTypeId));
            if (!isValidIssueTypeOption) {
                velocityParams.put(selectedIssueTypeKey, ((Option)Iterables.get(availableOptions, (int)0)).getId());
            }
        }
    }

    public Collection getIssueConstants() {
        return this.constantsManager.getAllIssueTypeObjects();
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        IssueType issueType = issue.getIssueType();
        String value = issueType != null ? issueType.getNameTranslation() : "";
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)value);
    }

    @Override
    public String prettyPrintChangeHistory(String changeHistory, I18nHelper i18nHelper) {
        IssueType issueType;
        Long issueTypeId;
        if (TextUtils.stringSet((String)changeHistory) && (issueTypeId = this.getIssueTypeIdByName(changeHistory)) != null && (issueType = this.constantsManager.getIssueType(issueTypeId.toString())) != null) {
            return issueType.getNameTranslation(i18nHelper);
        }
        return changeHistory;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(fieldTypeInfoContext.getIssueContext().getProjectObject());
        FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
        ImmutableList allowedTypes = new ArrayList();
        if (fieldTypeInfoContext.getOperationContext().getIssueOperation().equals(IssueOperations.CREATE_ISSUE_OPERATION)) {
            allowedTypes.add(fieldTypeInfoContext.getIssueContext().getIssueTypeObject());
        } else {
            Collection options = this.getOptionsForConfig(relevantConfig, fieldTypeInfoContext.getIssueContext(), new HashMap(), IssueTypeKind.ISSUE, null);
            options = CollectionUtils.select(options, (Predicate)new ValidForEditIssueTypes(fieldTypeInfoContext.getIssueContext(), new HashMap()));
            allowedTypes = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)options, (Function)new Function<Object, IssueType>(){

                public IssueType apply(@Nullable Object from) {
                    return IssueTypeSystemField.this.constantsManager.getIssueType(((Option)from).getId());
                }
            }));
        }
        return new FieldTypeInfo(allowedTypes, null);
    }

    public JsonType getJsonSchema() {
        return IssueTypeSystemField.getIssueTypeJsonSchema();
    }

    public static JsonType getIssueTypeJsonSchema() {
        return JsonTypeBuilder.system((String)"issuetype", (String)"issuetype");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)IssueTypeJsonBean.shortBean((IssueType)issue.getIssueTypeObject(), (JiraBaseUrls)this.jiraBaseUrls)));
    }

    private static enum IssueTypeKind {
        ALL,
        ISSUE,
        SUBTASK;

    }

    private static class OptionPredicate
    implements com.google.common.base.Predicate<Option> {
        private final String value;

        private OptionPredicate(String value) {
            this.value = value;
        }

        public boolean apply(Option option) {
            return this.value.equals(option.getId());
        }
    }

    private class ValidForEditIssueTypes
    implements Predicate {
        FieldLayout currentFieldLayout;
        JiraWorkflow currentWorkflow;
        private final IssueContext issue;
        private final Map displayParameters;

        public ValidForEditIssueTypes(IssueContext issue, Map displayParameters) {
            this.issue = issue;
            this.displayParameters = new HashMap(displayParameters);
        }

        public boolean evaluate(Object object) {
            Option option = (Option)object;
            try {
                JiraWorkflow workflow;
                if (this.currentFieldLayout == null || this.currentWorkflow == null) {
                    this.currentFieldLayout = IssueTypeSystemField.this.getFieldLayoutManager().getFieldLayout(this.issue.getProjectObject(), this.issue.getIssueTypeObject() != null ? this.issue.getIssueTypeId() : null);
                    this.currentWorkflow = IssueTypeSystemField.this.workflowManager.getWorkflow(this.issue.getProjectId(), this.issue.getIssueTypeObject() != null ? this.issue.getIssueTypeId() : null);
                }
                this.displayParameters.remove("restrictedSelection");
                FieldLayout fieldLayoutScheme = IssueTypeSystemField.this.getFieldLayoutManager().getFieldLayout(this.issue.getProjectObject(), option.getId());
                if (!this.currentFieldLayout.equals(fieldLayoutScheme)) {
                    this.displayParameters.put("restrictedSelection", Boolean.TRUE);
                    return false;
                }
                if (!this.issue.getIssueTypeId().equals(option.getId()) && !this.currentWorkflow.equals(workflow = IssueTypeSystemField.this.workflowManager.getWorkflow(this.issue.getProjectId(), option.getId()))) {
                    this.displayParameters.put("restrictedSelection", Boolean.TRUE);
                    return false;
                }
                return true;
            }
            catch (WorkflowException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
    }

    private class ValidIssueTypePredicate
    implements Predicate {
        private final IssueConstantOption currentIssuesOption;
        private final IssueContext issue;
        private final Map displayParameters;
        private final Collection<String> subTaskIds;
        private IssueTypeKind issueTypeKind;
        private Collection<String> issueTypeSkip;

        public ValidIssueTypePredicate(IssueContext issue, Map displayParameters) {
            this.subTaskIds = Lists.newArrayList((Iterable)IssueConstants.getIds((Iterable)IssueTypeSystemField.this.constantsManager.getSubTaskIssueTypeObjects()));
            this.issueTypeKind = IssueTypeKind.ISSUE;
            this.issue = issue;
            this.displayParameters = displayParameters;
            this.currentIssuesOption = issue != null ? new IssueConstantOption((IssueConstant)issue.getIssueTypeObject()) : null;
        }

        public ValidIssueTypePredicate(IssueContext issue, Map displayParameters, IssueTypeKind issueTypeKind, Collection<String> issueTypeSkip) {
            this(issue, displayParameters);
            this.issueTypeKind = issueTypeKind;
            this.issueTypeSkip = issueTypeSkip;
            if (this.issueTypeSkip == null) {
                this.issueTypeSkip = ImmutableList.of();
            }
        }

        public boolean evaluate(Object object) {
            Option option = (Option)object;
            if (this.isSkipType(option)) {
                return false;
            }
            if (!this.isCorrectType(option)) {
                return false;
            }
            return !IssueTypeSystemField.this.isMoveIssue(this.displayParameters, this.issue) || !this.currentIssuesOption.equals(option);
        }

        private boolean isSkipType(Option option) {
            return this.issueTypeSkip.contains(option.getId());
        }

        protected boolean isCorrectType(Option option) {
            if (this.issueTypeKind == IssueTypeKind.ALL) {
                return true;
            }
            if (this.issueTypeKind == IssueTypeKind.SUBTASK) {
                return this.subTaskIds.contains(option.getId());
            }
            return !this.subTaskIds.contains(option.getId());
        }
    }
}

