/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.AbstractUserFieldImpl;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.ReporterRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.ReporterSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.ReporterStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.query.order.SortOrder;
import com.atlassian.webresource.api.WebResourceManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class ReporterSystemField
extends AbstractUserFieldImpl
implements HideableField,
RequirableField,
RestAwareField,
RestFieldOperations,
ExportableSystemField {
    private static final Logger log = LoggerFactory.getLogger(ReporterSystemField.class);
    private static final String REPORTER_NAME_KEY = "issue.field.reporter";
    public static final SortOrder DEFAULT_SORT_ORDER = SortOrder.ASC;
    private final ReporterStatisticsMapper reporterStatisticsMapper;
    private UserSearchService searchService;
    private ApplicationProperties applicationProperties;
    private final JiraBaseUrls jiraBaseUrls;
    private final FeatureManager featureManager;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final UserBeanFactory userBeanFactory;
    private final DCFeatureLicenseChecker licenseChecker;

    public ReporterSystemField(VelocityTemplatingEngine templatingEngine, PermissionManager permissionManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, ReporterStatisticsMapper reporterStatisticsMapper, UserSearchService searchService, ReporterSearchHandlerFactory reporterSearchHandlerFactory, JiraBaseUrls jiraBaseUrls, FeatureManager featureManager, AvatarService avatarService, UserManager userManager, UserHistoryManager userHistoryManager, UserBeanFactory userBeanFactory, DCFeatureLicenseChecker licenseChecker) {
        super("reporter", REPORTER_NAME_KEY, templatingEngine, applicationProperties, authenticationContext, permissionManager, reporterSearchHandlerFactory, userHistoryManager);
        this.reporterStatisticsMapper = reporterStatisticsMapper;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.jiraBaseUrls = jiraBaseUrls;
        this.featureManager = featureManager;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.userBeanFactory = userBeanFactory;
        this.licenseChecker = licenseChecker;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        String reporterName = (String)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put(this.getId(), reporterName);
        velocityParams.put("hasPermissionPickUsers", this.getPermissionManager().hasPermission(27, this.getAuthenticationContext().getUser()));
        ApplicationUser reporterUser = this.userManager.getUserByName(reporterName);
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        if (reporterUser != null) {
            String avatarUrl = this.avatarService.getAvatarURL(loggedInUser, reporterName, Avatar.Size.SMALL).toString();
            velocityParams.put("reporter", reporterUser.getName());
            velocityParams.put("reporterDisplayName", reporterUser.getDisplayName());
            velocityParams.put("reporterAvatarUrl", avatarUrl);
        }
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(loggedInUser);
        boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)ctx);
        boolean useNewEndpoint = this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.IGNORE_BROWSE_USERS_PERMISSIONS_IN_USER_PICKERS);
        if (useNewEndpoint || canPerformAjaxSearch) {
            velocityParams.put("canPerformAjaxSearch", "true");
            velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
            velocityParams.put("useNewEndpoint", useNewEndpoint);
            if (issue != null && issue.getProjectObject() != null && issue.getProjectObject().getKey() != null) {
                velocityParams.put("projectKey", issue.getProjectObject().getKey());
            }
        }
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:autocomplete");
        String template = this.useFrotherControl() ? "reporter-edit-frother.vm" : "reporter-edit.vm";
        return this.renderTemplate(template, velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        velocityParams.put("reporter", issue.getReporter());
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, ApplicationUser value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("reporter", value);
        return this.getViewHtml(velocityParams);
    }

    private boolean useFrotherControl() {
        return this.featureManager.isEnabled("jira.frother.reporter.field") && !this.featureManager.isEnabled("jira.no.frother.reporter.field");
    }

    private String getViewHtml(Map velocityParams) {
        return this.renderTemplate("reporter-view.vm", velocityParams);
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 30);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String reporterUsername = (String)fieldValuesHolder.get(this.getId());
        if (fieldScreenRenderLayoutItem.isRequired() && !TextUtils.stringSet((String)reporterUsername)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())));
            return;
        }
        if (TextUtils.stringSet((String)reporterUsername)) {
            ApplicationUser newReporter = this.userManager.getUserByName(reporterUsername);
            if (newReporter == null) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.reporter.does.not.exist"));
                return;
            }
            if (newReporter.getKey().equals(issue.getReporterId())) {
                return;
            }
            if (!newReporter.isActive()) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.reporter.does.not.exist"));
                return;
            }
            ApplicationUser creator = this.getAuthenticationContext().getLoggedInUser();
            if (!(newReporter.equals((Object)creator) && IssueOperations.CREATE_ISSUE_OPERATION.equals(operationContext.getIssueOperation()) || this.getPermissionManager().hasPermission(ProjectPermissions.MODIFY_REPORTER, issue, creator))) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("createissue.error.no.modify.reporter.permission"));
            }
        }
    }

    public ApplicationUser getDefaultValue(Issue issue) {
        return this.getAuthenticationContext().getUser();
    }

    public void createValue(Issue issue, ApplicationUser value) {
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            ApplicationUser reporter = this.getValueFromParams(fieldValueHolder);
            issue.setReporter(reporter);
            this.addToUsedUserHistoryIfValueChanged(issue);
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        ApplicationUser originalReporter = originalIssue.getReporterUser();
        if (originalReporter != null) {
            fieldValuesHolder.put(this.getId(), originalReporter.getName());
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setReporter(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getReporter() != null;
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                ApplicationUser reporter = (ApplicationUser)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, this.getUserKey(reporter), reporter.getDisplayName());
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            ApplicationUser currentReporter = (ApplicationUser)currentValue;
            if (value != null) {
                ApplicationUser reporter = (ApplicationUser)value;
                cib = new ChangeItemBean("jira", this.getId(), this.getUserKey(currentReporter), currentReporter.getDisplayName(), this.getUserKey(reporter), reporter.getDisplayName());
            } else {
                cib = new ChangeItemBean("jira", this.getId(), this.getUserKey(currentReporter), currentReporter.getDisplayName(), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    public ApplicationUser getValueFromParams(Map params) {
        return UserUtils.getUser((String)((String)params.get(this.getId())));
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        fieldValuesHolder.put(this.getId(), stringValue);
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
        ApplicationUser reporter = issue.getReporterUser();
        if (reporter != null) {
            fieldValuesHolder.put(this.getId(), reporter.getName());
        }
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
        ApplicationUser remoteUser = this.getDefaultValue(issue);
        if (remoteUser != null) {
            fieldValuesHolder.put(this.getId(), remoteUser.getName());
        }
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.isHidden(bulkEditBean.getFieldLayouts())) {
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.hasBulkUpdatePermission(bulkEditBean, issue) && this.isShown(issue)) continue;
            return "bulk.edit.multiproject.unavailable.permission";
        }
        return null;
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.reporter";
    }

    public String getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER.toString();
    }

    public LuceneFieldSorter getSorter() {
        return this.reporterStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        try {
            String reporterUserId = issue.getReporterId();
            if (reporterUserId != null) {
                velocityParams.put("reporterUserkey", reporterUserId);
            }
        }
        catch (DataAccessException e) {
            log.debug("Error occurred retrieving reporter", (Throwable)e);
        }
        return this.renderTemplate("reporter-columnview.vm", velocityParams);
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        String[] value = params.get(this.getId());
        if (value != null && value.length > 0) {
            return value[0];
        }
        return null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String autoCompleteUrl = String.format("%s/rest/api/latest/user/search?username=", this.jiraBaseUrls.baseUrl());
        return new FieldTypeInfo(null, autoCompleteUrl);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"user", (String)"reporter");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)this.userBeanFactory.createBean(issue.getReporter(), this.authenticationContext.getUser())));
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new ReporterRestFieldOperationsHandler(this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        ApplicationUser user = this.getAuthenticationContext().getUser();
        if (user == null) {
            return new JsonData(null);
        }
        return new JsonData((Object)this.userBeanFactory.createBean(user, this.authenticationContext.getUser()));
    }

    private String getUserKey(ApplicationUser user) {
        if (user == null) {
            return "";
        }
        ApplicationUser applicationUser = this.userManager.getUserByName(user.getName());
        if (applicationUser == null) {
            return "";
        }
        return applicationUser.getKey();
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        ApplicationUser reporter = issue.getReporter();
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), (String)(reporter != null ? reporter.getName() : null));
    }
}

