/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFieldLimitProvider {
    private static final long DEFAULT_TEXT_FIELD_LIMIT = 30000L;
    private final ApplicationProperties applicationProperties;
    private final LogOnceLogger propertyMissingLog = new LogOnceLogger(LoggerFactory.getLogger(this.getClass()));
    private final LogOnceLogger invalidFormatLog = new LogOnceLogger(LoggerFactory.getLogger(this.getClass()));

    public TextFieldLimitProvider(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public long getTextFieldLimit() {
        return this.retrieveTextLimitFromApplicationProperties();
    }

    private long retrieveTextLimitFromApplicationProperties() {
        String textFieldLimitString = this.applicationProperties.getDefaultBackedString("jira.text.field.character.limit");
        if (textFieldLimitString == null || "".equals(textFieldLimitString)) {
            this.propertyMissingLog.warnOnlyOnce("Property 'jira.text.field.character.limit' is missing. Using default value of 30000 characters instead.");
            return 30000L;
        }
        try {
            return Long.parseLong(textFieldLimitString);
        }
        catch (NumberFormatException e) {
            this.invalidFormatLog.warnOnlyOnce("Invalid format of 'jira.text.field.character.limit' property: '" + textFieldLimitString + "'. Expected value to be a long. Using default value of 30000 characters instead.");
            return 30000L;
        }
    }

    private static class LogOnceLogger {
        private boolean alreadyLogged = false;
        private final Logger delegatee;

        private LogOnceLogger(Logger delegatee) {
            this.delegatee = delegatee;
        }

        public void warnOnlyOnce(String message) {
            if (!this.alreadyLogged) {
                this.alreadyLogged = true;
                this.delegatee.warn(message);
            }
        }
    }
}

