/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.export.ExportableSystemField;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.fields.NavigableFieldImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.WatchersJsonBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.statistics.WatchesStatisticsMapper;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import java.text.Collator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class WatchesSystemField
extends NavigableFieldImpl
implements RestAwareField,
ExportableSystemField {
    private final JiraBaseUrls jiraBaseUrls;

    public WatchesSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls) {
        super("watches", "issue.field.watch", "issue.column.heading.watch", "DESC", templatingEngine, applicationProperties, authenticationContext);
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public LuceneFieldSorter getSorter() {
        return WatchesStatisticsMapper.MAPPER;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        velocityParams.put(this.getId(), issue.getWatches());
        return this.renderTemplate("watches-columnview.vm", velocityParams);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"watches", (String)"watches");
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        WatcherManager watcherManager = ComponentAccessor.getWatcherManager();
        if (watcherManager.isWatchingEnabled()) {
            return new FieldJsonRepresentation(new JsonData((Object)WatchersJsonBean.shortBean((String)issue.getKey(), (long)issue.getWatches(), (boolean)watcherManager.isWatching(this.authenticationContext.getUser(), issue), (JiraBaseUrls)this.jiraBaseUrls)));
        }
        return null;
    }

    @Override
    public FieldExportParts getRepresentationFromIssue(Issue issue) {
        WatcherService watcherService = (WatcherService)ComponentAccessor.getComponent(WatcherService.class);
        if (watcherService.isWatchingEnabled()) {
            ServiceOutcome watchersData = watcherService.getWatchers(issue, this.authenticationContext.getLoggedInUser());
            if (watchersData != null && ((Pair)watchersData.get()).second() != null) {
                Stream<String> values = ((List)((Pair)watchersData.get()).second()).stream().map(ApplicationUser::getName).sorted(Collator.getInstance(this.authenticationContext.getLocale()));
                return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), values);
            }
            return FieldExportPartsBuilder.buildSinglePartRepresentation((String)this.getId(), (String)this.getName(), Stream.empty());
        }
        return new FieldExportPartsBuilder().build();
    }
}

