/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.auditing.handlers.IssueTypeSchemeHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.config.IssueTypeUpdatedEvent;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeCreatedEvent;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeDeletedEvent;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeUpdatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.issue.fields.option.CachedOptionSetManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class IssueTypeSchemeManagerImpl
implements IssueTypeSchemeManager {
    private final FieldConfigSchemeManager configSchemeManager;
    private final OptionSetManager optionSetManager;
    private final GenericConfigManager genericConfigManager;
    private final ConstantsManager constantsManager;
    private final ComponentReference<FieldManager> fieldManagerRef;
    private final ComponentReference<ApplicationProperties> applicationPropertiesRef;
    private EventPublisher eventPublisher;
    private final ProjectManager projectManager;
    private final IssueTypeSchemeHandler issueTypeSchemeHandler;
    private final FieldConfigSchemePersister schemePersister;
    private static final Comparator<FieldConfigScheme> BY_NAME_NULLS_FIRST = Comparator.comparing(FieldConfigScheme::getName, Comparator.nullsFirst(String::compareToIgnoreCase));

    public IssueTypeSchemeManagerImpl(FieldConfigSchemeManager configSchemeManager, OptionSetManager optionSetManager, GenericConfigManager genericConfigManager, ConstantsManager constantsManager, EventPublisher eventPublisher, ProjectManager projectManager, IssueTypeSchemeHandler issueTypeSchemeHandler, FieldConfigSchemePersister schemePersister) {
        this.configSchemeManager = configSchemeManager;
        this.optionSetManager = optionSetManager;
        this.genericConfigManager = genericConfigManager;
        this.constantsManager = constantsManager;
        this.eventPublisher = eventPublisher;
        this.projectManager = projectManager;
        this.issueTypeSchemeHandler = issueTypeSchemeHandler;
        this.schemePersister = schemePersister;
        this.fieldManagerRef = ComponentAccessor.getComponentReference(FieldManager.class);
        this.applicationPropertiesRef = ComponentAccessor.getComponentReference(ApplicationProperties.class);
    }

    public FieldConfigScheme create(String schemeName, String schemeDescription, List<String> optionIds) {
        FieldConfigScheme configScheme = new FieldConfigScheme.Builder().setName(schemeName).setDescription(schemeDescription).toFieldConfigScheme();
        configScheme = this.configSchemeManager.createFieldConfigScheme(configScheme, null, FieldConfigSchemeManager.ALL_ISSUE_TYPES, this.getIssueTypeField());
        OptionSet optionSet = this.optionSetManager.createOptionSet(Objects.requireNonNull(configScheme.getOneAndOnlyConfig()), optionIds);
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeCreatedEvent(configScheme));
        this.issueTypeSchemeHandler.handleIssueTypeSchemeCreated(configScheme, optionSet);
        return configScheme;
    }

    public FieldConfigScheme update(FieldConfigScheme configScheme, Collection<String> optionIds) {
        FieldConfigScheme oldConfigScheme = this.schemePersister.getFieldConfigScheme(configScheme.getId());
        OptionSet oldOptionSet = this.optionSetManager.getOptionsForConfig(Objects.requireNonNull(oldConfigScheme.getOneAndOnlyConfig()));
        configScheme = this.configSchemeManager.updateFieldConfigScheme(configScheme);
        OptionSet newOptionSet = this.optionSetManager.updateOptionSet(Objects.requireNonNull(configScheme.getOneAndOnlyConfig()), optionIds);
        this.issueTypeSchemeHandler.handleIssueTypeSchemeUpdated(oldConfigScheme, configScheme, oldOptionSet, newOptionSet);
        this.triggerIssueTypeSchemeUpdated(configScheme);
        return configScheme;
    }

    public FieldConfigScheme getDefaultIssueTypeScheme() {
        long schemeId = this.getDefaultIssueTypeSchemeId();
        return this.configSchemeManager.getFieldConfigScheme(Long.valueOf(schemeId));
    }

    public boolean isDefaultIssueTypeScheme(FieldConfigScheme configScheme) {
        Long id = configScheme.getId();
        return id != null && id.longValue() == this.getDefaultIssueTypeSchemeId();
    }

    private ConfigurableField<?> getIssueTypeField() {
        return this.getFieldManager().getConfigurableField("issuetype");
    }

    public long getDefaultIssueTypeSchemeId() {
        String s = ((ApplicationProperties)this.applicationPropertiesRef.get()).getString("jira.scheme.default.issue.type");
        return Long.parseLong(s);
    }

    public void addOptionToDefault(String id) {
        FieldConfigScheme defaultIssueTypeScheme = this.getDefaultIssueTypeScheme();
        this.optionSetManager.addOptionToOptionSet(defaultIssueTypeScheme.getOneAndOnlyConfig(), id);
        this.triggerIssueTypeSchemeUpdated(defaultIssueTypeScheme);
    }

    public Collection<FieldConfigScheme> getAllRelatedSchemes(String optionId) {
        List configs = this.configSchemeManager.getConfigSchemesForField(this.getIssueTypeField());
        return configs.stream().filter(configScheme -> {
            Collection optionIds = this.optionSetManager.getOptionsForConfig(configScheme.getOneAndOnlyConfig()).getOptionIds();
            return optionIds.contains(optionId);
        }).collect(Collectors.toList());
    }

    public void removeOptionFromAllSchemes(String optionId) {
        Collection<FieldConfigScheme> relatedSchemes = this.getAllRelatedSchemes(optionId);
        for (FieldConfigScheme configScheme : relatedSchemes) {
            this.optionSetManager.removeOptionFromOptionSet(configScheme.getOneAndOnlyConfig(), optionId);
            this.triggerIssueTypeSchemeUpdated(configScheme);
        }
    }

    private void triggerIssueTypeSchemeUpdated(FieldConfigScheme configScheme) {
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeUpdatedEvent(configScheme));
    }

    public void deleteScheme(FieldConfigScheme configScheme) {
        this.configSchemeManager.removeFieldConfigScheme(configScheme.getId());
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeDeletedEvent(configScheme));
        this.issueTypeSchemeHandler.handleIssueTypeSchemeDeleted(configScheme);
    }

    public List<FieldConfigScheme> getAllSchemes() {
        ArrayList<FieldConfigScheme> schemes = new ArrayList<FieldConfigScheme>(this.configSchemeManager.getConfigSchemesForField((ConfigurableField)this.getFieldManager().getIssueTypeField()));
        Collections.sort(schemes, this.schemeComparator());
        return schemes;
    }

    private FieldManager getFieldManager() {
        return (FieldManager)this.fieldManagerRef.get();
    }

    public IssueType getDefaultValue(Issue issue) {
        FieldConfig config = this.configSchemeManager.getRelevantConfig((IssueContext)issue, this.getIssueTypeField());
        return this.getDefaultValue(config);
    }

    public IssueType getDefaultValue(FieldConfig config) {
        if (config != null) {
            String issueTypeId = (String)this.genericConfigManager.retrieve("DefaultValue", config.getId().toString());
            return this.constantsManager.getIssueType(issueTypeId);
        }
        return null;
    }

    public IssueType getDefaultValue(GenericValue project) {
        if (project != null) {
            IssueTypeField issueTypeField = this.getFieldManager().getIssueTypeField();
            FieldConfig relevantConfig = issueTypeField.getRelevantConfig((IssueContext)new IssueContextImpl(project.getLong("id"), null));
            return this.getDefaultValue(relevantConfig);
        }
        return null;
    }

    public IssueType getDefaultIssueType(Project project) {
        if (project != null) {
            IssueTypeField issueTypeField = this.getFieldManager().getIssueTypeField();
            FieldConfig relevantConfig = issueTypeField.getRelevantConfig((IssueContext)new IssueContextImpl(project.getId(), null));
            return this.getDefaultValue(relevantConfig);
        }
        return null;
    }

    public void setDefaultValue(FieldConfig config, String optionId) {
        this.genericConfigManager.update("DefaultValue", config.getId().toString(), (Object)optionId);
        this.getFieldManager().refresh();
    }

    public FieldConfigScheme getConfigScheme(GenericValue project) {
        return this.configSchemeManager.getRelevantConfigScheme((IssueContext)new IssueContextImpl(project != null ? project.getLong("id") : null, null), (ConfigurableField)this.getFieldManager().getIssueTypeField());
    }

    public FieldConfigScheme getConfigScheme(Project project) {
        return this.configSchemeManager.getRelevantConfigScheme(project, (ConfigurableField)this.getFieldManager().getIssueTypeField());
    }

    @Nonnull
    public Collection<IssueType> getIssueTypesForProject(GenericValue project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project);
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, true);
    }

    @Nonnull
    public Collection<IssueType> getIssueTypesForProject(Project project) {
        return this.getIssueTypesForProject(project.getGenericValue());
    }

    @Nonnull
    public Collection<IssueType> getIssueTypesForDefaultScheme() {
        FieldConfigScheme fieldConfigScheme = this.getDefaultIssueTypeScheme();
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, true);
    }

    @Nonnull
    public Collection<IssueType> getIssueTypesForScheme(FieldConfigScheme issueTypeScheme) {
        return this.getIssueTypesForConfigScheme(issueTypeScheme, true, true);
    }

    public FieldConfigScheme addProjectAssociations(FieldConfigScheme scheme, Collection<Project> projectsToAdd) {
        return this.configSchemeManager.addAssociatedContexts(scheme, this.contextsFromProjects(projectsToAdd), this.getIssueTypeField());
    }

    public FieldConfigScheme removeProjectAssociations(FieldConfigScheme scheme, Collection<Project> projectsToRemove) {
        return this.configSchemeManager.removeAssociatedContexts(scheme, this.contextsFromProjects(projectsToRemove), this.getIssueTypeField());
    }

    private Set<JiraContextNode> contextsFromProjects(Collection<Project> projects) {
        Long[] ids = (Long[])projects.stream().map(Project::getId).toArray(Long[]::new);
        return new HashSet<JiraContextNode>(CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])ids, (ProjectManager)this.projectManager));
    }

    @Nonnull
    public FieldConfigScheme setProjectAssociationsForIssueTypeScheme(FieldConfigScheme issueTypeScheme, Collection<Project> projects) {
        List<Long> oneRemoved = projects.stream().map(p -> p.getId()).collect(Collectors.toList());
        List contexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])oneRemoved.toArray(new Long[0]), (ProjectManager)this.projectManager);
        return this.configSchemeManager.updateFieldConfigScheme(issueTypeScheme, contexts, this.getIssueTypeField());
    }

    @Nonnull
    public Collection<IssueType> getNonSubTaskIssueTypesForProject(Project project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project.getGenericValue());
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, false, true);
    }

    @Nonnull
    public Collection<IssueType> getSubTaskIssueTypesForProject(@Nonnull Project project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project.getGenericValue());
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, false);
    }

    @Nonnull
    private Collection<IssueType> getIssueTypesForConfigScheme(FieldConfigScheme fieldConfigScheme, boolean includeSubTasks, boolean includeNonSubTaskIssueTypes) {
        FieldConfig config = fieldConfigScheme.getOneAndOnlyConfig();
        List<Option> options = config == null ? Collections.emptyList() : this.optionSetManager.getOptionsForConfig(config).getOptions();
        ArrayList<IssueType> issueTypeObjects = new ArrayList<IssueType>();
        for (Option option : options) {
            IssueConstantOption issueTypeOption = (IssueConstantOption)option;
            IssueType issueType = this.constantsManager.getIssueType(issueTypeOption.getId());
            boolean isSubTask = issueType.isSubTask();
            if ((!includeSubTasks || !isSubTask) && (!includeNonSubTaskIssueTypes || isSubTask)) continue;
            issueTypeObjects.add(issueType);
        }
        return issueTypeObjects;
    }

    @EventListener
    public void oneIssueTypeUpdatedEvent(IssueTypeUpdatedEvent event) {
        this.getAllRelatedSchemes(event.getId()).forEach(scheme -> scheme.getConfigs().values().forEach(fieldConfig -> {
            if (this.optionSetManager instanceof CachedOptionSetManager) {
                CachedOptionSetManager cachedOptionSetManager = (CachedOptionSetManager)this.optionSetManager;
                cachedOptionSetManager.flushCacheForFieldConfig((FieldConfig)fieldConfig);
            }
        }));
    }

    private Comparator<FieldConfigScheme> schemeComparator() {
        return this.defaultIdFirst().thenComparing(BY_NAME_NULLS_FIRST);
    }

    private Comparator<FieldConfigScheme> defaultIdFirst() {
        Long defaultId = this.getDefaultIssueTypeSchemeId();
        return Comparator.comparing(FieldConfigScheme::getId, (id1, id2) -> {
            if (defaultId.equals(id1)) {
                return -1;
            }
            if (defaultId.equals(id2)) {
                return 1;
            }
            return 0;
        });
    }
}

