/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.context.persistence.event.FieldConfigSchemeContextUpdated;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersisterImpl;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachedFieldConfigSchemePersister
extends FieldConfigSchemePersisterImpl {
    private final Logger logger = LoggerFactory.getLogger(CachedFieldConfigSchemePersister.class);
    private final Cache<Long, Optional<FieldConfigScheme>> cacheById;
    private final Cache<String, List<FieldConfigScheme>> cacheByCustomField;
    private final Cache<Long, FieldConfigScheme> cacheByFieldConfig;
    private final FieldConfigManager fieldConfigManager;

    public CachedFieldConfigSchemePersister(OfBizDelegator delegator, QueryDslAccessor queryDslAccessor, ConstantsManager constantsManager, FieldConfigPersister fieldConfigPersister, FieldConfigContextPersister fieldContextPersister, FieldConfigManager fieldConfigManager, CacheManager cacheManager) {
        super(delegator, queryDslAccessor, constantsManager, fieldConfigPersister, fieldContextPersister, cacheManager);
        this.fieldConfigManager = fieldConfigManager;
        this.cacheById = cacheManager.getCache(this.getClass().getName() + ".cacheById", id -> Optional.ofNullable(super.getFieldConfigScheme((Long)id)), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheByCustomField = cacheManager.getCache(this.getClass().getName() + ".cacheByCustomField", this::loadSchemesByCustomFieldId, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheByFieldConfig = cacheManager.getCache(this.getClass().getName() + ".cacheByFieldConfig", this::loadSchemeByFieldConfigId, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @Override
    public void init() {
        super.init();
        this.clearCaches();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.invalidateAll();
        this.clearCaches();
    }

    @EventListener
    public void onSchemeContextUpdated(FieldConfigSchemeContextUpdated fieldConfigSchemeContextUpdated) {
        this.cacheById.remove((Object)fieldConfigSchemeContextUpdated.getSchemeId());
        this.cacheByCustomField.remove((Object)fieldConfigSchemeContextUpdated.getFieldId());
        ((Optional)this.cacheById.get((Object)fieldConfigSchemeContextUpdated.getSchemeId())).map(fcs -> {
            this.removeFieldConfigsFromCache((FieldConfigScheme)fcs);
            return Void.TYPE;
        });
    }

    @Override
    @Nullable
    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId == null) {
            return null;
        }
        return ((Optional)this.cacheById.get((Object)configSchemeId)).orElse(null);
    }

    @Override
    @Nullable
    public List<FieldConfigScheme> getConfigSchemesForCustomField(ConfigurableField field) {
        if (field == null) {
            return null;
        }
        return (List)this.cacheByCustomField.get((Object)field.getId());
    }

    @Override
    @Nullable
    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        if (fieldConfig == null) {
            return null;
        }
        return (FieldConfigScheme)this.cacheByFieldConfig.get((Object)fieldConfig.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldConfigScheme create(FieldConfigScheme configScheme, ConfigurableField field) {
        FieldConfigScheme createdConfigScheme = null;
        try {
            createdConfigScheme = super.create(configScheme, field);
        }
        finally {
            if (createdConfigScheme != null) {
                this.cacheById.remove((Object)createdConfigScheme.getId());
                this.cacheByCustomField.remove((Object)field.getId());
                this.removeFieldConfigsFromCache(createdConfigScheme);
            }
        }
        return createdConfigScheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldConfigScheme update(FieldConfigScheme configScheme) {
        FieldConfigScheme updatedConfigScheme = null;
        try {
            updatedConfigScheme = super.update(configScheme);
        }
        finally {
            if (updatedConfigScheme != null) {
                this.cacheById.remove((Object)updatedConfigScheme.getId());
                ConfigurableField field = updatedConfigScheme.getField();
                if (field != null) {
                    this.cacheByCustomField.remove((Object)field.getId());
                }
                this.removeFieldConfigsFromCache(updatedConfigScheme);
                updatedConfigScheme = this.getFieldConfigScheme(updatedConfigScheme.getId());
            }
        }
        return updatedConfigScheme;
    }

    @Override
    protected void removeRelatedConfigsForUpdate(@Nonnull FieldConfigScheme configScheme, @Nonnull GenericValue gv) throws GenericEntityException {
        try {
            super.removeRelatedConfigsForUpdate(configScheme, gv);
        }
        finally {
            this.removeFieldConfigsFromCache(configScheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Long fieldConfigSchemeId) {
        FieldConfigScheme deletedFieldConfigScheme = null;
        try {
            deletedFieldConfigScheme = super.removeIfExist(fieldConfigSchemeId);
        }
        finally {
            this.cacheById.remove((Object)fieldConfigSchemeId);
            if (deletedFieldConfigScheme != null) {
                ConfigurableField field = deletedFieldConfigScheme.getField();
                if (field != null) {
                    this.cacheByCustomField.remove((Object)field.getId());
                }
                this.removeFieldConfigsFromCache(deletedFieldConfigScheme);
            }
        }
    }

    @Override
    public void removeByIssueType(IssueType issueType) {
        try {
            super.removeByIssueType(issueType);
        }
        finally {
            this.clearCaches();
        }
    }

    private void removeFieldConfigsFromCache(FieldConfigScheme fieldConfigScheme) {
        fieldConfigScheme.getConfigs().values().stream().map(FieldConfig::getId).forEach(configId -> {
            try {
                this.cacheByFieldConfig.remove(configId);
            }
            catch (Exception e) {
                this.logger.error("An error has occurred while removing field config from cache. We don\u00e2\u0080\u0099t expect the configId to be null. The data might be corrupted.", (Throwable)e);
            }
        });
    }

    private void clearCaches() {
        this.cacheById.removeAll();
        this.cacheByCustomField.removeAll();
        this.cacheByFieldConfig.removeAll();
    }

    @Nonnull
    private FieldConfigScheme loadSchemeByFieldConfigId(Long fieldConfigId) {
        FieldConfig fieldConfig = this.fieldConfigManager.getFieldConfig(fieldConfigId);
        return super.getConfigSchemeForFieldConfig(fieldConfig);
    }

    @Nonnull
    private List<FieldConfigScheme> loadSchemesByCustomFieldId(String fieldId) {
        ConfigurableField field = (ConfigurableField)ComponentAccessor.getFieldManager().getField(fieldId);
        return ImmutableList.copyOf(super.getConfigSchemesForCustomField(field));
    }
}

