/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@Internal
public class DefaultFieldLayoutService
implements FieldLayoutService {
    private final GlobalPermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nFactory;

    public DefaultFieldLayoutService(GlobalPermissionManager permissionManager, I18nHelper.BeanFactory i18nFactory) {
        this.permissionManager = permissionManager;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public ServiceOutcome<List<FieldLayoutItem>> getFilteredLayoutItems(@Nonnull FieldLayout fieldLayout, String query, ApplicationUser user) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nHelper = this.i18nFactory.getInstance(user);
        if (user == null || !this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.generic.permission"), ErrorCollection.Reason.FORBIDDEN);
            return new ServiceOutcomeImpl<Object>((ErrorCollection)errorCollection, null);
        }
        String lowerQuery = query.toLowerCase();
        List filteredList = fieldLayout.getFieldLayoutItems().stream().filter(i -> {
            OrderableField field = i.getOrderableField();
            return field.getName().toLowerCase().contains(lowerQuery);
        }).collect(Collectors.toList());
        return new ServiceOutcomeImpl<List<FieldLayoutItem>>((ErrorCollection)errorCollection, filteredList);
    }
}

