/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.option.AbstractOption;
import com.atlassian.jira.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FieldConfigSchemeOption
extends AbstractOption {
    private FieldConfigScheme fieldConfigScheme;
    private List childOptions = Collections.emptyList();

    public FieldConfigSchemeOption(FieldConfigScheme fieldConfigScheme, Collection childOptions) {
        this.fieldConfigScheme = fieldConfigScheme;
        if (childOptions != null) {
            this.childOptions = EasyList.build((Collection)childOptions);
        }
    }

    public String getId() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.getId().toString() : null;
    }

    public Long getFieldConfigurationId() {
        if (this.fieldConfigScheme == null || this.fieldConfigScheme.getOneAndOnlyConfig() == null) {
            return null;
        }
        return this.fieldConfigScheme.getOneAndOnlyConfig().getId();
    }

    public String getName() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.getName() : null;
    }

    public String getDescription() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.getDescription() : null;
    }

    public List getChildOptions() {
        return this.childOptions;
    }

    public String getProjects() {
        if (this.fieldConfigScheme != null) {
            StringBuilder sb = new StringBuilder();
            if (!this.fieldConfigScheme.isGlobal()) {
                Iterator associatedProjects = this.fieldConfigScheme.getAssociatedProjectObjects().iterator();
                while (associatedProjects.hasNext()) {
                    Project project = (Project)associatedProjects.next();
                    sb.append(project.getName());
                    if (!associatedProjects.hasNext()) continue;
                    if (sb.length() > 40) {
                        sb.append("...");
                        break;
                    }
                    sb.append(", ");
                }
            } else {
                sb.append("Default scheme (unlisted projects)");
            }
            return sb.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FieldConfigSchemeOption that = (FieldConfigSchemeOption)((Object)o);
        return !(this.fieldConfigScheme != null ? !this.fieldConfigScheme.equals(that.fieldConfigScheme) : that.fieldConfigScheme != null);
    }

    public int hashCode() {
        return this.fieldConfigScheme != null ? this.fieldConfigScheme.hashCode() : 491;
    }
}

