/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class IssueConstantOptionSet
implements OptionSet {
    private final ConstantsManager constantsManager;
    private final Queue<Option> options;

    IssueConstantOptionSet(ConstantsManager constantsManager, List<IssueConstant> constants) {
        this.constantsManager = constantsManager;
        this.options = new ConcurrentLinkedQueue<Option>(IssueConstantOptionSet.toOptions(constants));
    }

    public Collection<Option> getOptions() {
        return this.options;
    }

    public Collection<String> getOptionIds() {
        return Collections2.transform(this.options, Option::getId);
    }

    public void addOption(String constantType, String constantId) {
        IssueConstant constant = this.constantsManager.getConstantObject(constantType, constantId);
        if (constant == null) {
            throw new IllegalArgumentException("Not a valid constant: type=" + constantType + "; constantId='" + constantId + "'");
        }
        this.options.add(new IssueConstantOption(constant));
    }

    private static Collection<Option> toOptions(Collection<IssueConstant> constants) {
        return (Collection)constants.stream().map(IssueConstantOption::new).collect(CollectorsUtil.toNewArrayListWithSizeOf(constants));
    }
}

