/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFieldConstants;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.MandatoryField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldHtmlFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;
import webwork.action.ActionContext;

public class FieldHtmlFactoryImpl
implements FieldHtmlFactory {
    private static final Map<String, Object> DISPLAY_PARAMS = MapBuilder.newBuilder((Object)"noHeader", (Object)"true", (Object)"theme", (Object)"aui", (Object)"isFirstField", (Object)true, (Object)"isLastField", (Object)true).toMutableMap();
    public static final String JIRA_CREATE_LINKED_ISSUE_SHOW_ALL_FIELDS = "jira.create.linked.issue.show.all.fields";
    private final I18nHelper.BeanFactory beanFactory;
    private final FieldManager fieldManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;
    private final CustomFieldManager customFieldManager;
    private static final FieldValuePopulator defaultPopulator = (fieldValuesHolder, sourceIssue, field) -> field.populateFromIssue(fieldValuesHolder, sourceIssue);
    private static final FieldValuePopulator issueLinksFieldValuePopulator = (fieldValuesHolder, sourceIssue, field) -> {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("issuelinks-issues", new String[]{sourceIssue.getKey()});
        field.populateFromParams(fieldValuesHolder, params);
    };

    public FieldHtmlFactoryImpl(I18nHelper.BeanFactory beanFactory, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, PermissionManager permissionManager, FeatureManager featureManager, CustomFieldManager customFieldManager) {
        this.beanFactory = beanFactory;
        this.fieldManager = fieldManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
        this.customFieldManager = customFieldManager;
    }

    public List<FieldHtmlBean> getCreateFields(ApplicationUser user, OperationContext operationContext, Action action, MutableIssue newIssueObject, boolean retainValues, List<String> fieldsToRetain) {
        List<FieldHtmlBean> fieldHtmls = this.createProjectAndIssueTypeFields(operationContext, action, newIssueObject);
        List<FieldRenderItemWithTab> fieldRendersWithTabs = this.getRenderableItems((Issue)newIssueObject, IssueOperations.CREATE_ISSUE_OPERATION);
        for (FieldRenderItemWithTab fieldRenderWithTab : fieldRendersWithTabs) {
            String fieldId = fieldRenderWithTab.getId();
            if (retainValues && fieldsToRetain.contains(fieldId)) {
                fieldRenderWithTab.populateFromParams(operationContext.getFieldValuesHolder(), ActionContext.getParameters());
                continue;
            }
            if (fieldsToRetain != null && fieldsToRetain.contains(fieldId) && !fieldId.equals("attachment")) continue;
            operationContext.getFieldValuesHolder().remove(fieldId);
            fieldRenderWithTab.populateDefaults(operationContext.getFieldValuesHolder(), (Issue)newIssueObject);
        }
        this.addMandatorySetupFieldsIfNotPresent(operationContext, action, newIssueObject, retainValues, fieldsToRetain, fieldHtmls, fieldRendersWithTabs);
        return this.renderCreateFields(user, operationContext, action, newIssueObject, fieldHtmls, fieldRendersWithTabs, true);
    }

    private List<FieldHtmlBean> createProjectAndIssueTypeFields(OperationContext operationContext, Action action, MutableIssue newIssueObject) {
        ArrayList fieldHtmls = Lists.newArrayList();
        FieldHtmlBean projectFieldHtml = this.createField(operationContext, action, newIssueObject, true, "project");
        FieldHtmlBean issueTypeFieldHtml = this.createField(operationContext, action, newIssueObject, true, "issuetype");
        fieldHtmls.add(projectFieldHtml);
        fieldHtmls.add(issueTypeFieldHtml);
        return fieldHtmls;
    }

    private FieldHtmlBean createField(OperationContext operationContext, Action action, MutableIssue issue, boolean isRequired, String fieldId) {
        OrderableField field = (OrderableField)this.fieldManager.getField(fieldId);
        return this.createField(operationContext, action, issue, isRequired, field);
    }

    private FieldHtmlBean createField(OperationContext operationContext, Action action, MutableIssue issue, boolean isRequired, OrderableField field) {
        field.updateIssue(null, issue, operationContext.getFieldValuesHolder());
        String fieldHtml = field.getCreateHtml(null, operationContext, action, (Issue)issue, DISPLAY_PARAMS);
        return new FieldHtmlBean(field.getId(), field.getName(), isRequired, fieldHtml, null);
    }

    private List<FieldHtmlBean> renderCreateFields(ApplicationUser user, OperationContext operationContext, Action action, MutableIssue newIssueObject, List<FieldHtmlBean> fieldHtmls, List<FieldRenderItemWithTab> fieldRendersWithTabs, boolean markFieldsWithDefaultValueAsOptional) {
        I18nHelper i18nHelper = this.beanFactory.getInstance(user);
        for (FieldRenderItemWithTab item : fieldRendersWithTabs) {
            Object defaultValue;
            String createHtml = item.getCreateHtml(action, operationContext, (Issue)newIssueObject, DISPLAY_PARAMS);
            if (!StringUtils.isNotBlank((CharSequence)createHtml)) continue;
            boolean isRequired = item.isRequired();
            if (isRequired && markFieldsWithDefaultValueAsOptional && !this.isNullOrEmpty(defaultValue = item.getDefaultValue((Issue)newIssueObject))) {
                isRequired = false;
            }
            fieldHtmls.add(new FieldHtmlBean(item.getId(), i18nHelper.getText(item.getNameKey()), isRequired, createHtml.trim(), item.getFieldTab()));
        }
        return fieldHtmls;
    }

    private boolean isNullOrEmpty(Object object) {
        return object == null || object instanceof Collection && Iterables.isEmpty((Iterable)((Collection)object));
    }

    public List<FieldHtmlBean> getEditFields(ApplicationUser user, OperationContext operationContext, Action action, Issue issue, boolean retainValues) {
        ArrayList fieldHtmls = Lists.newArrayList();
        List<FieldRenderItemWithTab> fieldRendersWithTabs = this.getPopulatedRenderableItems(issue, retainValues, operationContext.getFieldValuesHolder(), IssueOperations.EDIT_ISSUE_OPERATION);
        I18nHelper i18nHelper = this.beanFactory.getInstance(user);
        FieldTab firstTab = null;
        for (FieldRenderItemWithTab fieldRenderWithTab : fieldRendersWithTabs) {
            String editHtml;
            FieldTab currentTab = fieldRenderWithTab.getFieldTab();
            if (firstTab == null && currentTab.getPosition() == 0) {
                firstTab = currentTab;
            }
            if (!StringUtils.isNotBlank((CharSequence)(editHtml = fieldRenderWithTab.getEditHtml(action, operationContext, issue, DISPLAY_PARAMS)))) continue;
            fieldHtmls.add(new FieldHtmlBean(fieldRenderWithTab.getId(), i18nHelper.getText(fieldRenderWithTab.getNameKey()), fieldRenderWithTab.isRequired(), editHtml.trim(), currentTab));
        }
        if (this.permissionManager.hasPermission(15, issue, user)) {
            CommentSystemField commentField = (CommentSystemField)this.fieldManager.getField("comment");
            if (retainValues) {
                commentField.populateFromParams(operationContext.getFieldValuesHolder(), ActionContext.getParameters());
            }
            FieldLayoutItem commentFieldLayoutItem = this.getFieldScreenRenderer(issue, IssueOperations.EDIT_ISSUE_OPERATION).getFieldScreenRenderLayoutItem((OrderableField)commentField).getFieldLayoutItem();
            fieldHtmls.add(new FieldHtmlBean(commentField.getId(), commentField.getName(), false, commentField.getEditHtml(commentFieldLayoutItem, operationContext, action, issue, DISPLAY_PARAMS), firstTab));
        }
        return fieldHtmls;
    }

    public List<FieldHtmlBean> getInlineEditFields(ApplicationUser user, OperationContext operationContext, Action action, Issue issue, boolean retainValues) {
        ArrayList fieldHtmls = Lists.newArrayList();
        List<FieldRenderItemWithTab> fieldRendersWithTabs = this.getPopulatedRenderableItems(issue, retainValues, operationContext.getFieldValuesHolder(), IssueOperations.EDIT_ISSUE_OPERATION);
        I18nHelper i18nHelper = this.beanFactory.getInstance(user);
        for (FieldRenderItemWithTab fieldRenderWithTab : fieldRendersWithTabs) {
            String editHtml;
            OrderableField field = fieldRenderWithTab.getOrderableField();
            if (field instanceof CustomField && ((CustomField)field).getValue(issue) == null || !StringUtils.isNotBlank((CharSequence)(editHtml = fieldRenderWithTab.getEditHtml(action, operationContext, issue, DISPLAY_PARAMS)))) continue;
            fieldHtmls.add(new FieldHtmlBean(fieldRenderWithTab.getId(), i18nHelper.getText(fieldRenderWithTab.getNameKey()), fieldRenderWithTab.isRequired(), editHtml.trim(), fieldRenderWithTab.getFieldTab()));
        }
        return fieldHtmls;
    }

    public List<FieldHtmlBean> getSubTaskCreateFields(ApplicationUser user, OperationContext operationContext, Action action, MutableIssue newIssueObject, boolean retainValues, List<String> fieldsToRetain) {
        return this.getCreateFields(user, operationContext, action, newIssueObject, retainValues, fieldsToRetain);
    }

    @VisibleForTesting
    List<FieldRenderItemWithTab> getPopulatedRenderableItems(Issue issue, Boolean retainValues, Map<String, Object> fieldValuesHolder, ScreenableIssueOperation operation) {
        List<FieldRenderItemWithTab> fieldRendersWithTabs = this.getRenderableItems(issue, operation);
        for (FieldRenderItemWithTab fieldRenderWithTab : fieldRendersWithTabs) {
            if (retainValues.booleanValue()) {
                fieldRenderWithTab.populateFromParams(fieldValuesHolder, ActionContext.getParameters());
                continue;
            }
            fieldRenderWithTab.populateFromIssue(fieldValuesHolder, issue);
        }
        return fieldRendersWithTabs;
    }

    @VisibleForTesting
    List<FieldRenderItemWithTab> getRenderableItems(Issue issue, ScreenableIssueOperation operation) {
        ArrayList fieldRendersWithTabs = Lists.newArrayList();
        FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(issue, operation);
        List fieldScreenRenderTabs = fieldScreenRenderer.getFieldScreenRenderTabs();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderTabs) {
            FieldTab currentTab = new FieldTab(fieldScreenRenderTab.getName(), fieldScreenRenderTab.getPosition());
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                boolean excludeIssueType;
                String fieldId = fieldScreenRenderLayoutItem.getOrderableField().getId();
                boolean bl = excludeIssueType = operation.equals(IssueOperations.CREATE_ISSUE_OPERATION) && "issuetype".equals(fieldId);
                if ("project".equals(fieldId) || excludeIssueType || !fieldScreenRenderLayoutItem.isShow(issue)) continue;
                fieldRendersWithTabs.add(new FieldRenderItemWithTab(fieldScreenRenderLayoutItem, currentTab));
            }
        }
        return fieldRendersWithTabs;
    }

    private FieldScreenRenderer getFieldScreenRenderer(Issue issue, ScreenableIssueOperation operation) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)operation);
    }

    public List<FieldHtmlBean> getLinkedIssueCreateFields(ApplicationUser user, OperationContext operationContext, Action action, MutableIssue newIssueObject, Issue sourceIssue, boolean retainValues, List<String> fieldsToRetain) {
        List<FieldHtmlBean> fieldHtmls = this.createProjectAndIssueTypeFields(operationContext, action, newIssueObject);
        FieldHtmlBean issueLinksFieldHtml = this.createFieldFromIssue(operationContext, action, newIssueObject, sourceIssue, retainValues, fieldsToRetain, "issuelinks", issueLinksFieldValuePopulator);
        fieldHtmls.add(issueLinksFieldHtml);
        List<FieldRenderItemWithTab> fieldRendersWithTabs = this.getRenderableItems((Issue)newIssueObject, IssueOperations.CREATE_ISSUE_OPERATION).stream().filter(render -> !render.isIssueLinkField()).collect(Collectors.toList());
        fieldRendersWithTabs.forEach(fieldRenderItem -> this.populateFieldValue(operationContext, sourceIssue, retainValues, fieldsToRetain, defaultPopulator, fieldRenderItem.getOrderableField()));
        this.renderCreateFields(user, operationContext, action, newIssueObject, fieldHtmls, fieldRendersWithTabs, false);
        this.addFieldIfNotPresent(operationContext, action, newIssueObject, sourceIssue, retainValues, fieldsToRetain, fieldHtmls, "summary");
        if (!this.featureManager.isEnabled(JIRA_CREATE_LINKED_ISSUE_SHOW_ALL_FIELDS)) {
            this.addFieldIfNotPresent(operationContext, action, newIssueObject, sourceIssue, retainValues, fieldsToRetain, fieldHtmls, "description");
        }
        this.addMandatorySetupFieldsIfNotPresent(operationContext, action, newIssueObject, retainValues, fieldsToRetain, fieldHtmls, fieldRendersWithTabs);
        return fieldHtmls;
    }

    private void addMandatorySetupFieldsIfNotPresent(OperationContext operationContext, Action action, MutableIssue newIssueObject, boolean retainValues, List<String> fieldsToRetain, List<FieldHtmlBean> fieldHtmlBeans, List<FieldRenderItemWithTab> fieldRendersWithTabs) {
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.JIRA_MANDATORY_QUICK_SETUP_FIELDS_OVERRIDE)) {
            return;
        }
        Project projectObject = newIssueObject.getProjectObject();
        if (projectObject != null) {
            this.customFieldManager.getCustomFieldObjects().stream().filter(field -> field instanceof MandatoryField).filter(field -> ((MandatoryField)field).isSetupFieldInContext(projectObject)).forEach(customField -> this.addCustomFieldIfNotPresent(operationContext, action, newIssueObject, retainValues, fieldsToRetain, fieldHtmlBeans, fieldRendersWithTabs, customField.getFieldName(), customField.getCustomFieldType().getKey()));
        }
    }

    private FieldHtmlBean createFieldFromIssue(OperationContext operationContext, Action action, MutableIssue newIssueObject, Issue sourceIssue, boolean retainValues, List<String> fieldsToRetain, String fieldId, FieldValuePopulator fieldValuePopulator) {
        OrderableField field = (OrderableField)this.fieldManager.getField(fieldId);
        if (sourceIssue != null) {
            this.populateFieldValue(operationContext, sourceIssue, retainValues, fieldsToRetain, fieldValuePopulator, field);
        }
        return this.createField(operationContext, action, newIssueObject, IssueFieldConstants.isRequiredField((String)fieldId), field);
    }

    private void populateFieldValue(OperationContext operationContext, Issue sourceIssue, boolean retainValues, List<String> fieldsToRetain, FieldValuePopulator fieldValuePopulator, OrderableField field) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        if (retainValues && fieldsToRetain.contains(field.getId())) {
            field.populateFromParams(fieldValuesHolder, ActionContext.getParameters());
        } else {
            fieldValuePopulator.populateFieldValueFromIssue(fieldValuesHolder, sourceIssue, field);
        }
    }

    private void addCustomFieldIfNotPresent(OperationContext operationContext, Action action, MutableIssue newIssueObject, boolean retainValues, List<String> fieldsToRetain, List<FieldHtmlBean> fieldHtmls, List<FieldRenderItemWithTab> fieldRendersWithTabs, String fieldName, String customFieldKey) {
        boolean isFieldPresentOnTabs;
        boolean isFieldPresentInHtml = fieldHtmls.stream().anyMatch(fieldHtml -> fieldName.equals(fieldHtml.getLabel()));
        if (isFieldPresentInHtml) {
            return;
        }
        boolean bl = isFieldPresentOnTabs = fieldRendersWithTabs != null && fieldRendersWithTabs.stream().filter(FieldRenderItemWithTab::isCustomField).anyMatch(fieldRenderItem -> ((CustomField)fieldRenderItem.getOrderableField()).getCustomFieldType().getKey().equals(customFieldKey));
        if (isFieldPresentOnTabs) {
            return;
        }
        Collection customFieldObjectsByName = this.customFieldManager.getCustomFieldObjectsByName(fieldName);
        Optional<CustomField> firstMatch = customFieldObjectsByName.stream().filter(field -> field.getCustomFieldType().getKey().equals(customFieldKey)).findFirst();
        if (firstMatch.isPresent()) {
            FieldHtmlBean fieldHtml2 = this.createFieldFromIssue(operationContext, action, newIssueObject, null, retainValues, fieldsToRetain, firstMatch.get().getId(), defaultPopulator);
            fieldHtmls.add(fieldHtml2);
        }
    }

    private void addFieldIfNotPresent(OperationContext operationContext, Action action, MutableIssue newIssueObject, Issue sourceIssue, boolean retainValues, List<String> fieldsToRetain, List<FieldHtmlBean> fieldHtmls, String fieldId) {
        boolean isFieldPresent = fieldHtmls.stream().anyMatch(field -> fieldId.equals(field.getId()));
        if (!isFieldPresent) {
            FieldHtmlBean fieldHtml = this.createFieldFromIssue(operationContext, action, newIssueObject, sourceIssue, retainValues, fieldsToRetain, fieldId, defaultPopulator);
            fieldHtmls.add(fieldHtml);
        }
    }

    @VisibleForTesting
    static class FieldRenderItemWithTab {
        private final FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem;
        private final FieldTab fieldTab;

        private FieldRenderItemWithTab(FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem, FieldTab fieldTab) {
            this.fieldScreenRenderLayoutItem = fieldScreenRenderLayoutItem;
            this.fieldTab = fieldTab;
        }

        public FieldTab getFieldTab() {
            return this.fieldTab;
        }

        public boolean isCustomField() {
            return this.fieldScreenRenderLayoutItem.getOrderableField() instanceof CustomField;
        }

        public boolean isRequired() {
            return this.fieldScreenRenderLayoutItem.isRequired();
        }

        public String getId() {
            return this.fieldScreenRenderLayoutItem.getOrderableField().getId();
        }

        public String getNameKey() {
            return this.fieldScreenRenderLayoutItem.getOrderableField().getNameKey();
        }

        public OrderableField getOrderableField() {
            return this.fieldScreenRenderLayoutItem.getOrderableField();
        }

        public Object getDefaultValue(Issue issue) {
            return this.fieldScreenRenderLayoutItem.getOrderableField().getDefaultValue(issue);
        }

        public String getCreateHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
            return this.fieldScreenRenderLayoutItem.getCreateHtml(action, operationContext, issue, displayParams);
        }

        public String getEditHtml(Action action, OperationContext operationContext, Issue issue, Map<String, Object> displayParams) {
            return this.fieldScreenRenderLayoutItem.getEditHtml(action, operationContext, issue, displayParams);
        }

        public void populateFromParams(Map<String, Object> fieldValuesHolder, Map<String, String[]> params) {
            this.fieldScreenRenderLayoutItem.getOrderableField().populateFromParams(fieldValuesHolder, params);
        }

        public void populateFromIssue(Map<String, Object> fieldValueHolder, Issue issue) {
            this.fieldScreenRenderLayoutItem.getOrderableField().populateFromIssue(fieldValueHolder, issue);
        }

        public void populateDefaults(Map fieldValueHolder, Issue issue) {
            this.fieldScreenRenderLayoutItem.populateDefaults(fieldValueHolder, issue);
        }

        public boolean isIssueLinkField() {
            return "issuelinks".equals(this.getId());
        }
    }

    @FunctionalInterface
    private static interface FieldValuePopulator {
        public void populateFieldValueFromIssue(Map<String, Object> var1, Issue var2, OrderableField var3);
    }
}

