/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.auditing.handlers.AccessDeniedAuditHandler;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.ErrorCollection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class IssueFinderImpl
implements IssueFinder {
    private final Pattern ISSUE_ID_PATTERN = Pattern.compile("^[1-9]\\d{0,17}$");
    private final JiraAuthenticationContext authContext;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final AccessDeniedAuditHandler auditHandler;

    public IssueFinderImpl(JiraAuthenticationContext authContext, IssueManager issueManager, PermissionManager permissionManager, AccessDeniedAuditHandler accessDeniedAuditHandler) {
        this.authContext = authContext;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.auditHandler = accessDeniedAuditHandler;
    }

    public Issue findIssue(@Nonnull IssueRefJsonBean issueRef, @Nonnull ErrorCollection errorCollection) {
        if (StringUtils.isNotBlank((CharSequence)issueRef.id()) && this.isIssueId(issueRef.id())) {
            return this.findIssueById(Long.parseLong(issueRef.id()), errorCollection);
        }
        if (StringUtils.isNotBlank((CharSequence)issueRef.key())) {
            return this.findIssueByKey(issueRef.key(), errorCollection);
        }
        errorCollection.addErrorMessage(this.authContext.getI18nHelper().getText("rest.issue.key.or.id.required"));
        return null;
    }

    public Issue findIssue(@Nullable String issueIdOrKey, @Nonnull ErrorCollection errorCollection) {
        if (StringUtils.isNotBlank((CharSequence)issueIdOrKey) && this.isIssueId(issueIdOrKey)) {
            return this.findIssueById(Long.parseLong(issueIdOrKey), errorCollection);
        }
        if (StringUtils.isNotBlank((CharSequence)issueIdOrKey)) {
            return this.findIssueByKey(issueIdOrKey, errorCollection);
        }
        errorCollection.addErrorMessage(this.authContext.getI18nHelper().getText("rest.issue.key.or.id.required"));
        return null;
    }

    private boolean isIssueId(@Nonnull String issueIdOrKey) {
        return this.ISSUE_ID_PATTERN.matcher(issueIdOrKey).matches();
    }

    private Issue findIssueById(@Nonnull Long id, @Nonnull ErrorCollection errorCollection) {
        MutableIssue issue = this.issueManager.getIssueObject(id);
        return this.checkIssuePermission(errorCollection, (Issue)issue);
    }

    private Issue findIssueByKey(@Nonnull String key, @Nonnull ErrorCollection errorCollection) {
        MutableIssue issue = this.issueManager.getIssueObject(key);
        if (issue == null) {
            key = key.toUpperCase();
            issue = this.issueManager.getIssueObject(key);
        }
        return this.checkIssuePermission(errorCollection, (Issue)issue);
    }

    private Issue checkIssuePermission(ErrorCollection errorCollection, Issue issue) {
        if (issue == null) {
            errorCollection.addErrorMessage(this.authContext.getI18nHelper().getText("issue.does.not.exist.title"), ErrorCollection.Reason.NOT_FOUND);
            return null;
        }
        ApplicationUser user = this.authContext.getLoggedInUser();
        if (!this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user)) {
            errorCollection.addErrorMessage(this.authContext.getI18nHelper().getText("admin.errors.issues.no.permission.to.see"));
            if (Users.isAnonymous((ApplicationUser)user)) {
                errorCollection.addErrorMessage(this.authContext.getI18nHelper().getText("login.required.title"), ErrorCollection.Reason.NOT_LOGGED_IN);
            } else {
                errorCollection.addReason(ErrorCollection.Reason.FORBIDDEN);
            }
            this.auditHandler.handleIssueAccessDenied(issue.getKey());
            return null;
        }
        return issue;
    }
}

