/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.AbstractFieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.tab.FieldScreenTabRendererFactory;
import com.atlassian.jira.issue.fields.screen.tab.IssueTabRendererDto;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

class StandardFieldScreenRendererFactory {
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldScreenManager fieldScreenManager;
    private final FieldScreenTabRendererFactory fieldScreenTabRendererFactory;

    StandardFieldScreenRendererFactory(FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenManager fieldScreenManager, FieldScreenTabRendererFactory fieldScreenTabRendererFactory) {
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldScreenTabRendererFactory = fieldScreenTabRendererFactory;
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, IssueOperation issueOperation, Predicate<? super Field> predicate) {
        FieldScreenScheme fieldScreenScheme = this.issueTypeScreenSchemeManager.getFieldScreenScheme(issue);
        return this.createFieldScreenRenderer(issue, fieldScreenScheme.getFieldScreen(issueOperation), issueOperation, predicate);
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, ActionDescriptor actionDescriptor) {
        return this.createFieldScreenRenderer(issue, this.getScreenFromAction(actionDescriptor), null, (Predicate<? super Field>)Predicates.truePredicate());
    }

    FieldScreen getScreenFromAction(ActionDescriptor descriptor) {
        WorkflowActionsBean workflowActionsBean = new WorkflowActionsBean();
        return workflowActionsBean.getFieldScreenForView(descriptor);
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue) {
        return this.createFieldScreenRenderer(issue, Collections.emptyList(), null, (Predicate<? super Field>)Predicates.truePredicate());
    }

    FieldScreenRenderer createFieldScreenRenderer(List<String> fieldIds, Issue issue, IssueOperation issueOperation) {
        SubTaskFieldScreenTab tab = new SubTaskFieldScreenTab(fieldIds, this.fieldScreenManager, this.fieldManager);
        return this.createFieldScreenRenderer(issue, Collections.singletonList(tab), issueOperation, (Predicate<? super Field>)Predicates.truePredicate());
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, FieldScreen fieldScreen, IssueOperation operation, Predicate<? super Field> condition) {
        List fieldScreenTabs = fieldScreen == null ? Collections.emptyList() : fieldScreen.getTabs();
        return this.createFieldScreenRenderer(issue, fieldScreenTabs, operation, condition);
    }

    FieldScreenRenderer createFieldScreenRenderer(Issue issue, Collection<FieldScreenTab> tabs, IssueOperation operation, Predicate<? super Field> condition) {
        ArrayList<FieldScreenRenderTab> fieldScreenRenderTabs = new ArrayList<FieldScreenRenderTab>(tabs.size());
        int currentTabPosition = 0;
        for (FieldScreenTab fieldScreenTab : tabs) {
            IssueTabRendererDto issueTabRendererDto = new IssueTabRendererDto(issue, operation, condition, currentTabPosition, fieldScreenTab);
            FieldScreenRenderTab fieldScreenRenderTab = this.fieldScreenTabRendererFactory.createTabRender(issueTabRendererDto);
            if (fieldScreenRenderTab.getFieldScreenRenderLayoutItems().isEmpty()) continue;
            fieldScreenRenderTabs.add(fieldScreenRenderTab);
            ++currentTabPosition;
        }
        FieldLayout fieldLayout = this.getFieldLayout(issue);
        return new FieldScreenRendererImpl(Collections.unmodifiableList(fieldScreenRenderTabs), fieldLayout);
    }

    private FieldLayout getFieldLayout(Issue issue) {
        return this.fieldLayoutManager.getFieldLayout(issue);
    }

    private static class SubTaskFieldScreenTab
    implements FieldScreenTab {
        private final Map<String, FieldScreenLayoutItem> fieldLayoutItems = new LinkedHashMap<String, FieldScreenLayoutItem>();

        public SubTaskFieldScreenTab(List<String> fieldIds, FieldScreenManager fieldScreenManager, FieldManager fieldManager) {
            int i = 0;
            for (String fieldId : fieldIds) {
                SubTaskFieldScreenlayoutItem fieldScreenLayoutItem = new SubTaskFieldScreenlayoutItem(fieldScreenManager, fieldManager);
                fieldScreenLayoutItem.setPosition(i);
                fieldScreenLayoutItem.setFieldId(fieldId);
                fieldScreenLayoutItem.setFieldScreenTab(this);
                this.fieldLayoutItems.put(fieldId, fieldScreenLayoutItem);
                ++i;
            }
        }

        public int getPosition() {
            return 0;
        }

        public boolean isModified() {
            return false;
        }

        public List<FieldScreenLayoutItem> getFieldScreenLayoutItems() {
            return new ArrayList<FieldScreenLayoutItem>(this.fieldLayoutItems.values());
        }

        public FieldScreenLayoutItem getFieldScreenLayoutItem(int poistion) {
            return this.getFieldScreenLayoutItems().get(poistion);
        }

        public FieldScreenLayoutItem getFieldScreenLayoutItem(String fieldId) {
            return this.fieldLayoutItems.get(fieldId);
        }

        public boolean isContainsField(String fieldId) {
            return this.fieldLayoutItems.containsKey(fieldId);
        }

        public String getName() {
            return "Sub Task Quick Creation Tab";
        }

        public Long getId() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void setPosition(int position) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void addFieldScreenLayoutItem(String fieldId) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void addFieldScreenLayoutItem(String fieldId, int position) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void moveFieldScreenLayoutItemFirst(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void moveFieldScreenLayoutItemUp(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void moveFieldScreenLayoutItemDown(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void moveFieldScreenLayoutItemLast(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public FieldScreenLayoutItem removeFieldScreenLayoutItem(int fieldPosition) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void moveFieldScreenLayoutItemToPosition(Map positionsToFields) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public GenericValue getGenericValue() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void setGenericValue(GenericValue genericValue) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void setFieldScreen(FieldScreen fieldScreen) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public FieldScreen getFieldScreen() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void rename(String newName) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void store() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void remove() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }

    private static class SubTaskFieldScreenlayoutItem
    extends AbstractFieldScreenLayoutItem {
        public SubTaskFieldScreenlayoutItem(FieldScreenManager fieldScreenManager, FieldManager fieldManager) {
            super(fieldScreenManager, fieldManager);
        }

        @Override
        protected void init() {
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        public void setFieldScreenTab(FieldScreenTab fieldScreenTab) {
            this.fieldScreenTab = fieldScreenTab;
        }

        public Long getId() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void store() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void remove() {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

