/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.tab;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTabImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.tab.FieldScreenRenderLayoutItemFilter;
import com.atlassian.jira.issue.fields.screen.tab.FieldScreenTabRendererFactory;
import com.atlassian.jira.issue.fields.screen.tab.IssueTabRendererDto;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class FieldScreenTabRendererFactoryImpl
implements FieldScreenTabRendererFactory {
    private final FieldScreenRenderLayoutItemFilter fieldLayoutItemsFilter;
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;

    public FieldScreenTabRendererFactoryImpl(FieldScreenRenderLayoutItemFilter fieldLayoutItemsFilter, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutItemsFilter = fieldLayoutItemsFilter;
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    public FieldScreenRenderTabImpl createTabRender(IssueTabRendererDto issueTabRendererDto) {
        Issue issue = issueTabRendererDto.getIssue();
        FieldScreenTab fieldScreenTab = issueTabRendererDto.getFieldScreenTab();
        List fieldLayoutItems = fieldScreenTab.getFieldScreenLayoutItems();
        Collection<FieldScreenLayoutItem> availableFieldLayoutItems = this.fieldLayoutItemsFilter.filterAvailableFieldScreenLayoutItems(issueTabRendererDto.getCondition(), fieldLayoutItems);
        Collection<FieldScreenLayoutItem> visibleFieldScreenLayoutItems = this.fieldLayoutItemsFilter.filterVisibleFieldScreenLayoutItems(issue, availableFieldLayoutItems);
        Iterable<FieldScreenRenderLayoutItem> fieldScreenRenderLayoutItems = this.transformFieldScreenLayoutItemsToRenderers(issueTabRendererDto, visibleFieldScreenLayoutItems);
        return new FieldScreenRenderTabImpl(fieldScreenTab.getName(), issueTabRendererDto.getCurrentTabPosition(), Lists.newArrayList(fieldScreenRenderLayoutItems));
    }

    private Iterable<FieldScreenRenderLayoutItem> transformFieldScreenLayoutItemsToRenderers(IssueTabRendererDto issueTabRendererDto, Collection<FieldScreenLayoutItem> visibleFieldScreenLayoutItems) {
        final Issue issue = issueTabRendererDto.getIssue();
        final IssueOperation operation = issueTabRendererDto.getOperation();
        return visibleFieldScreenLayoutItems.stream().map(SafePluginPointAccess.safe((java.util.function.Function)new Function<FieldScreenLayoutItem, FieldScreenRenderLayoutItem>(){

            public FieldScreenRenderLayoutItem apply(FieldScreenLayoutItem fieldScreenLayoutItem) {
                FieldLayout fieldLayout = FieldScreenTabRendererFactoryImpl.this.fieldLayoutManager.getFieldLayout(issue);
                OrderableField orderableField = fieldScreenLayoutItem.getOrderableField();
                FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(orderableField);
                if (FieldScreenTabRendererFactoryImpl.this.fieldManager.isCustomField((Field)orderableField)) {
                    return FieldScreenTabRendererFactoryImpl.this.getCustomFieldRenderLayoutItem(issue, operation, fieldLayoutItem, fieldScreenLayoutItem);
                }
                return new FieldScreenRenderLayoutItemImpl(fieldScreenLayoutItem, fieldLayoutItem);
            }
        })).filter(Predicates.notNull()).collect(Collectors.toList());
    }

    private FieldScreenRenderLayoutItem getCustomFieldRenderLayoutItem(Issue issue, IssueOperation issueOperation, FieldLayoutItem fieldLayoutItem, FieldScreenLayoutItem fieldScreenLayoutItem) {
        CustomField customField = (CustomField)fieldLayoutItem.getOrderableField();
        if (customField.isInScope(issue.getProjectObject(), Collections.singletonList(issue.getIssueTypeId()))) {
            if (IssueOperations.VIEW_ISSUE_OPERATION.equals(issueOperation)) {
                if (this.doesViewTemplateExist(customField)) {
                    return new FieldScreenRenderLayoutItemImpl(fieldScreenLayoutItem, fieldLayoutItem);
                }
            } else {
                return new FieldScreenRenderLayoutItemImpl(fieldScreenLayoutItem, fieldLayoutItem);
            }
        }
        return null;
    }

    private boolean doesViewTemplateExist(CustomField customField) {
        return customField.getCustomFieldType().getDescriptor().isViewTemplateExists();
    }
}

