/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.util;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.model.querydsl.QAction;
import com.atlassian.jira.model.querydsl.QEntityProperty;
import com.atlassian.jira.util.SplitStreamHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.StatementOptions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ServiceDeskVisibilityInformationRetriever {
    private static final String SD_INTERNAL_FIELD_NAME = "internal";
    private static final String SD_JSON_ENTITY_NAME = "sd.comment.property";
    private static final String SD_JSON_PUBLIC_COMMENT_KEY = "sd.public.comment";
    private final QueryDslAccessor queryDslAccessor;
    private final DatabaseConfig databaseConfiguration;

    public ServiceDeskVisibilityInformationRetriever(QueryDslAccessor queryDslAccessor, DatabaseConfigurationManager databaseConfigurationManager) {
        this.queryDslAccessor = queryDslAccessor;
        this.databaseConfiguration = databaseConfigurationManager.getDatabaseConfiguration();
    }

    public Map<Long, ServiceDeskCommentVisibility> getServiceDeskCommentsVisibility(Issue issue) {
        return SplitStreamHelper.streamWithSplitIterator(lastComment -> this.getCommentsForBatch(issue, (Optional<CommentWithVisibility>)lastComment), 10000).collect(Collectors.toMap(CommentWithVisibility::getId, CommentWithVisibility::getVisibility));
    }

    @Nonnull
    private List<CommentWithVisibility> getCommentsForBatch(Issue issue, Optional<CommentWithVisibility> lastComment) {
        return this.queryDslAccessor.executeQuery(con -> {
            BooleanBuilder where = new BooleanBuilder();
            where.and((Predicate)QAction.ACTION.issue.eq((Object)issue.getId()));
            where.and((Predicate)QAction.ACTION.type.eq((Object)"comment"));
            where.and((Predicate)QEntityProperty.ENTITY_PROPERTY.entityName.eq((Object)SD_JSON_ENTITY_NAME));
            where.and((Predicate)QEntityProperty.ENTITY_PROPERTY.propertyKey.eq((Object)SD_JSON_PUBLIC_COMMENT_KEY));
            lastComment.ifPresent(lastItem -> where.and((Predicate)QAction.ACTION.id.gt((Number)lastItem.getId())));
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.newSqlQuery(con).select(new Expression[]{QAction.ACTION.id, QEntityProperty.ENTITY_PROPERTY.value}).from((Expression)QAction.ACTION)).join((EntityPath)QEntityProperty.ENTITY_PROPERTY)).on((Predicate)QAction.ACTION.id.eq(QEntityProperty.ENTITY_PROPERTY.entityId))).where((Predicate)where)).orderBy(QAction.ACTION.id.asc())).limit(10000L)).fetch().stream().filter(tuple -> tuple.get(QAction.ACTION.id) != null && tuple.get((Expression)QEntityProperty.ENTITY_PROPERTY.value) != null).map(tuple -> new CommentWithVisibility((Long)tuple.get(QAction.ACTION.id), this.convertJsonEntityToVisibility((String)tuple.get((Expression)QEntityProperty.ENTITY_PROPERTY.value)))).collect(Collectors.toList());
        });
    }

    private SQLQuery<?> newSqlQuery(DbConnection con) {
        SQLQuery<?> query = con.newSqlQuery();
        int fetchSize = this.databaseConfiguration.isMySql() ? Integer.MIN_VALUE : 10000;
        query.setStatementOptions(StatementOptions.builder().setFetchSize(Integer.valueOf(fetchSize)).build());
        return query;
    }

    private ServiceDeskCommentVisibility convertJsonEntityToVisibility(String jsonEntityValue) {
        return Optional.ofNullable(jsonEntityValue).filter(StringUtils::isNotBlank).map(this::convertStringToJsonObject).filter(commentProperty -> commentProperty.has(SD_INTERNAL_FIELD_NAME)).map(this::getInternalFieldFromJsonObject).orElse(ServiceDeskCommentVisibility.PUBLIC);
    }

    private ServiceDeskCommentVisibility getInternalFieldFromJsonObject(JSONObject object) {
        try {
            return object.getBoolean(SD_INTERNAL_FIELD_NAME) ? ServiceDeskCommentVisibility.INTERNAL : ServiceDeskCommentVisibility.PUBLIC;
        }
        catch (JSONException e) {
            return ServiceDeskCommentVisibility.PUBLIC;
        }
    }

    private JSONObject convertStringToJsonObject(String valueRaw) {
        try {
            return new JSONObject(valueRaw);
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    public static enum ServiceDeskCommentVisibility {
        PUBLIC,
        INTERNAL;


        public String toString() {
            if (this == PUBLIC) {
                return "public";
            }
            return ServiceDeskVisibilityInformationRetriever.SD_INTERNAL_FIELD_NAME;
        }
    }

    public static class CommentWithVisibility {
        private final Long id;
        private final ServiceDeskCommentVisibility visibility;

        public CommentWithVisibility(Long id, ServiceDeskCommentVisibility visibility) {
            this.id = id;
            this.visibility = visibility;
        }

        public Long getId() {
            return this.id;
        }

        public ServiceDeskCommentVisibility getVisibility() {
            return this.visibility;
        }
    }
}

