/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.index.CustomFieldIndexerWithPrefetechedData;
import com.atlassian.jira.issue.index.CustomFieldValueDrivenPredicate;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexingFeatures;
import com.atlassian.jira.issue.index.IndexingTimers;
import com.atlassian.jira.issue.index.IssueDocumentFactory;
import com.atlassian.jira.issue.index.LocalContextPredicate;
import com.atlassian.jira.issue.index.SharedCustomFieldsVisibilityCache;
import com.atlassian.jira.issue.index.indexers.CustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.log.RateLimitingLogger;
import com.atlassian.util.profiling.Ticker;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;

public class DefaultIssueDocumentFactory
implements IssueDocumentFactory {
    private static final RateLimitingLogger LOG = new RateLimitingLogger(DefaultIssueDocumentFactory.class);
    private static final ImmutableSet<String> ENTITY_VERSION_FIELDS = ImmutableSet.of((Object)"_issue_version", (Object)"_comment_version", (Object)"_worklog_version");
    private final ComponentReference<FieldIndexerManager> fieldIndexerManagerRef = ComponentAccessor.getComponentReference(FieldIndexerManager.class);
    private final ComponentReference<FieldConfigSchemePersister> fieldConfigSchemePersisterRef = ComponentAccessor.getComponentReference(FieldConfigSchemePersister.class);
    private final ComponentReference<FieldLayoutManager> fieldLayoutManagerRef = ComponentAccessor.getComponentReference(FieldLayoutManager.class);
    private final ComponentReference<NonNullCustomFieldProviderManager> nonNullCustomFieldProviderManagerComponentRef = ComponentAccessor.getComponentReference(NonNullCustomFieldProviderManager.class);
    private final ComponentReference<CustomFieldManager> customFieldManagerRef = ComponentAccessor.getComponentReference(CustomFieldManager.class);
    private final SearchExtractorRegistrationManager searchExtractorManager;
    private final IndexingFeatures indexingFeatures;
    private final Set<String> alreadyWarnedCustomFields = new HashSet<String>();

    public DefaultIssueDocumentFactory(@Nonnull SearchExtractorRegistrationManager searchExtractorManager, @Nonnull IndexingFeatures indexingFeatures) {
        this.searchExtractorManager = Objects.requireNonNull(searchExtractorManager, "searchExtractorManager");
        this.indexingFeatures = Objects.requireNonNull(indexingFeatures, "indexingFeatures");
    }

    @Override
    public Optional<Document> createDocument(EntityWithVersion<Issue> issueWithVersion) {
        return this.createDocuments(Collections.singletonList(issueWithVersion)).get(issueWithVersion);
    }

    @Override
    public Map<EntityWithVersion<Issue>, Optional<Document>> createDocuments(List<EntityWithVersion<Issue>> issuesWithVersions) {
        List<Issue> issues = issuesWithVersions.stream().map(EntityWithVersion::getEntity).collect(Collectors.toList());
        HashMap<EntityWithVersion<Issue>, Optional<Document>> results = new HashMap<EntityWithVersion<Issue>, Optional<Document>>();
        try (Ticker ignored = IndexingTimers.DOC_CREATION_ISSUE_BATCH.start(new String[0]);){
            if (this.indexingFeatures.isCFValueDrivenIndexingEnabled() || this.indexingFeatures.isLocalContextIndexingEnabled()) {
                Map<Long, Set> visibleFields = issues.stream().collect(Collectors.toMap(Issue::getId, this::getVisibleCustomFields));
                Map<Long, Map<String, CustomFieldPrefetchedData>> persistedFieldsWithData = this.getPersistedFieldsWithData(issues);
                Function<Issue, Set> issueSetFunction = issue -> this.getVisibleCustomFieldIndexers(visibleFields.getOrDefault(issue.getId(), Collections.emptySet()), persistedFieldsWithData.getOrDefault(issue.getId(), Collections.emptyMap()));
                Map<Long, Set> visibleFieldIndexers = issues.stream().collect(Collectors.toMap(Issue::getId, issueSetFunction));
                issuesWithVersions.forEach(entityWithVersion -> results.put((EntityWithVersion<Issue>)entityWithVersion, this.getDocument((EntityWithVersion<Issue>)entityWithVersion, visibleFields.getOrDefault(((Issue)entityWithVersion.getEntity()).getId(), Collections.emptySet()), visibleFieldIndexers.getOrDefault(((Issue)entityWithVersion.getEntity()).getId(), Collections.emptySet()))));
            } else {
                issuesWithVersions.forEach(entityWithVersion -> results.put((EntityWithVersion<Issue>)entityWithVersion, ((Builder)new Builder((EntityWithVersion<Issue>)entityWithVersion).addAll(((FieldIndexerManager)this.fieldIndexerManagerRef.get()).getAllIssueIndexers()).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(Issue.class))).build()));
            }
        }
        return results;
    }

    private Optional<Document> getDocument(EntityWithVersion<Issue> entityWithVersion, Set<String> visibleFields, Set<CustomFieldIndexerWithPrefetechedData> visibleFieldIndexers) {
        return ((Builder)new Builder(entityWithVersion).addAll(((FieldIndexerManager)this.fieldIndexerManagerRef.get()).getSystemFieldIndexers()).addAllWithPrefetchedData(visibleFieldIndexers).visibleDocumentFieldIds(visibleFields).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(Issue.class))).build();
    }

    @Override
    public Term getIdentifyingIssueTerm(WithId issue) {
        return new Term("issue_id", issue.getId().toString());
    }

    @Override
    public Term getIdentifyingTerm(Project project) {
        return new Term("projid", project.getId().toString());
    }

    @Nonnull
    private Set<String> getVisibleCustomFields(IssueContext issueContext) {
        IssueContextImpl issueContextWithHashCodeAndEquals = new IssueContextImpl(issueContext.getProjectId(), issueContext.getIssueTypeId());
        return SharedCustomFieldsVisibilityCache.computeIfAbsent((IssueContext)issueContextWithHashCodeAndEquals, this::getVisibleCustomFieldsUncached);
    }

    @Nonnull
    private Set<String> getVisibleCustomFieldsUncached(IssueContext issueContext) {
        Set<String> layoutVisibleFields = this.getLayoutVisibleFields(issueContext.getProjectId(), issueContext.getIssueTypeId());
        return ((FieldConfigSchemePersister)this.fieldConfigSchemePersisterRef.get()).filterRelevantFields(issueContext, layoutVisibleFields);
    }

    private Map<Long, Map<String, CustomFieldPrefetchedData>> getPersistedFieldsWithData(List<Issue> issues) {
        HashBasedTable persistedFields = HashBasedTable.create();
        HashMultimap customFieldToProvider = HashMultimap.create();
        ((NonNullCustomFieldProviderManager)this.nonNullCustomFieldProviderManagerComponentRef.get()).getNonNullCustomFieldProviders().forEach(arg_0 -> this.lambda$getPersistedFieldsWithData$5(issues, (SetMultimap)customFieldToProvider, (Table)persistedFields, arg_0));
        this.logWarningsIfMultipleProvidersPerCustomField((SetMultimap<String, NonNullCustomFieldProvider>)customFieldToProvider);
        return persistedFields.rowMap();
    }

    private boolean dataIsDifferent(@Nullable CustomFieldPrefetchedData d1, @Nullable CustomFieldPrefetchedData d2) {
        return d1 != null && d2 != null && !d2.getData().equals(d1.getData());
    }

    private void logWarningsIfMultipleProvidersPerCustomField(SetMultimap<String, NonNullCustomFieldProvider> customFieldToProvider) {
        customFieldToProvider.asMap().forEach((customFieldId, providers) -> {
            if (providers.size() > 1 && this.alreadyWarnedCustomFields.add((String)customFieldId)) {
                CustomField customField = ((CustomFieldManager)this.customFieldManagerRef.get()).getCustomFieldObject(customFieldId);
                LOG.warn("Custom field {} (id={}) of type {} has more than one provider: {}. All providers returned consistent data, so we'll treat them leniently this time, but if in the future there is a discrepancy between results returned by custom field value providers, we'll reject such data. This will lead to an indexing error. This looks like a bug. Verify the providers list. Consider asking plugin developers to reconsider their com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider#getIdentity implementation.", customField, customFieldId, customField.getCustomFieldType(), this.toString((Collection<NonNullCustomFieldProvider>)providers));
            }
        });
    }

    private String toString(Collection<NonNullCustomFieldProvider> providers) {
        return providers.stream().map(p -> p.toString() + " (" + p.getClass() + ")").collect(Collectors.joining(", ", "[", "]"));
    }

    private boolean hasValidData(String customFieldId, @Nullable CustomFieldPrefetchedData customFieldPrefetchedData) {
        boolean hasValidData;
        boolean bl = hasValidData = customFieldPrefetchedData != null;
        if (!hasValidData) {
            LOG.debug("Detected null prefetched data for {} this field will not be indexed", (Object)customFieldId);
        }
        return hasValidData;
    }

    private Set<CustomFieldIndexerWithPrefetechedData> getVisibleCustomFieldIndexers(Set<String> visibleFieldSet, Map<String, CustomFieldPrefetchedData> nonnullFieldsWithData) {
        Predicate<CustomFieldIndexer> predicate = x -> true;
        if (this.indexingFeatures.isCFValueDrivenIndexingEnabled()) {
            Set<String> nonnullFieldIds = nonnullFieldsWithData.keySet();
            predicate = predicate.and(new CustomFieldValueDrivenPredicate(nonnullFieldIds));
        }
        if (this.indexingFeatures.isLocalContextIndexingEnabled()) {
            predicate = predicate.and(new LocalContextPredicate(visibleFieldSet));
        }
        Collection<CustomFieldIndexer> customFieldIndexers = ((FieldIndexerManager)this.fieldIndexerManagerRef.get()).getCustomFieldIndexers();
        Set<CustomFieldIndexerWithPrefetechedData> visibleIndexers = customFieldIndexers.stream().filter(predicate).map(indexer -> new CustomFieldIndexerWithPrefetechedData((CustomFieldIndexer)indexer, (CustomFieldPrefetchedData)nonnullFieldsWithData.get(indexer.getField().getId()))).collect(Collectors.toSet());
        LOG.debug("Number of visible indexers {} out of {} custom field indexes", (Object)visibleIndexers.size(), (Object)customFieldIndexers.size());
        LOG.trace("Visible custom field indexers: {}", visibleIndexers);
        LOG.trace("All custom field indexers: {}", customFieldIndexers);
        return visibleIndexers;
    }

    private Set<String> getLayoutVisibleFields(Long projectId, String issueTypeId) {
        if (projectId == null || issueTypeId == null) {
            return Collections.emptySet();
        }
        FieldLayout fieldLayout = ((FieldLayoutManager)this.fieldLayoutManagerRef.get()).getFieldLayout(projectId, issueTypeId);
        if (fieldLayout == null) {
            return Collections.emptySet();
        }
        return fieldLayout.getFieldLayoutItems().stream().filter(x -> !x.isHidden()).map(x -> x.getOrderableField().getId()).collect(Collectors.toSet());
    }

    private /* synthetic */ void lambda$getPersistedFieldsWithData$5(List issues, SetMultimap customFieldToProvider, Table persistedFields, NonNullCustomFieldProvider provider) {
        provider.getCustomFieldInfo(issues).forEach((issueId, customFieldIdToPrefetchedData) -> customFieldIdToPrefetchedData.forEach((customFieldId, customFieldPrefetchedData) -> {
            if (this.hasValidData((String)customFieldId, (CustomFieldPrefetchedData)customFieldPrefetchedData)) {
                customFieldToProvider.put(customFieldId, (Object)provider);
                CustomFieldPrefetchedData previouslyStored = (CustomFieldPrefetchedData)persistedFields.put(issueId, customFieldId, customFieldPrefetchedData);
                if (this.dataIsDifferent((CustomFieldPrefetchedData)customFieldPrefetchedData, previouslyStored)) {
                    throw new IllegalStateException(String.format("Two different values (%s, %s) mapped to issueId=%s, customFieldId=%s. Providers for this custom field are %s", customFieldPrefetchedData.getData().orElse(null), previouslyStored.getData().orElse(null), issueId, customFieldId, this.toString(customFieldToProvider.get(customFieldId))));
                }
            }
        }));
    }

    static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<Issue, Builder> {
        private final Set<String> visibleDocumentFieldIds = new HashSet<String>();
        private final Issue issue;
        private Set<String> droppedFields;

        private Builder(EntityWithVersion<Issue> issueWithVersion) {
            super(issueWithVersion, "issues");
            this.issue = issueWithVersion.getEntity();
        }

        Builder addAll(Collection<? extends FieldIndexer> indexers) {
            try (Ticker ignored = IndexingTimers.FIELD_INDEXERS.start(new String[0]);){
                for (FieldIndexer fieldIndexer : indexers) {
                    this.add(fieldIndexer, CustomFieldPrefetchedData.NO_PREFETCH);
                }
                Builder builder = this;
                return builder;
            }
        }

        public Builder addAllWithPrefetchedData(Iterable<CustomFieldIndexerWithPrefetechedData> indexers) {
            try (Ticker ignored = IndexingTimers.FIELD_INDEXERS.start(new String[0]);){
                for (CustomFieldIndexerWithPrefetechedData indexer : indexers) {
                    this.add(indexer.getIndexer(), indexer.getPrefetchedData());
                }
                Builder builder = this;
                return builder;
            }
        }

        Builder visibleDocumentFieldIds(Collection<String> visibleFields) {
            this.visibleDocumentFieldIds.addAll(visibleFields);
            return this;
        }

        void add(FieldIndexer indexer, CustomFieldPrefetchedData prefetechedData) {
            String documentFieldId = null;
            try {
                documentFieldId = indexer.getDocumentFieldId();
                indexer.addIndex(this.doc, this.issue, prefetechedData);
                if (indexer.isFieldVisibleAndInScope(this.issue)) {
                    this.visibleDocumentFieldIds.add(documentFieldId);
                }
            }
            catch (RuntimeException re) {
                this.dropField(documentFieldId, indexer, re);
            }
            catch (LinkageError err) {
                this.dropField(documentFieldId, indexer, err);
            }
        }

        @Override
        protected void fieldsAddedByExtractor(Set<String> fieldIds) {
            this.visibleDocumentFieldIds.addAll(fieldIds);
        }

        @Override
        public Optional<Document> build() {
            if (this.droppedFields != null) {
                LOG.warn("Error indexing issue " + this.issue.getKey() + ": Dropped: " + this.droppedFields);
            }
            this.generateNonEmptyFieldIds();
            for (String documentFieldId : this.visibleDocumentFieldIds) {
                this.addSearchableField("visiblefieldids", documentFieldId, Field.Store.NO);
            }
            return super.build();
        }

        @Override
        protected String getDocumentType() {
            return "issue";
        }

        @Override
        protected IndexDirectoryFactory.Name getIndexName() {
            return IndexDirectoryFactory.Name.ISSUE;
        }

        private void dropField(String documentFieldId, FieldIndexer indexer, Throwable e) {
            String description = documentFieldId != null ? documentFieldId : indexer.getClass().getName();
            LOG.warn("Error indexing issue " + this.issue.getKey() + ": Dropping '" + description + "'", e);
            if (this.droppedFields == null) {
                this.droppedFields = Sets.newTreeSet();
            }
            this.droppedFields.add(description);
        }

        private void generateNonEmptyFieldIds() {
            for (String fieldName : this.getNonEmptyFieldNames()) {
                this.addSearchableField("nonemptyfieldids", fieldName, Field.Store.NO);
            }
        }

        private List<String> getNonEmptyFieldNames() {
            List fields = this.doc.getFields();
            ArrayList<String> names = new ArrayList<String>(fields.size());
            for (IndexableField field : fields) {
                if (!this.isNonEmptyField(field) || ENTITY_VERSION_FIELDS.contains((Object)field.name())) continue;
                names.add(field.name());
            }
            return names;
        }

        private boolean isNonEmptyField(IndexableField field) {
            return field.fieldType().indexOptions() != IndexOptions.NONE || field.fieldType().pointDimensionCount() > 0;
        }
    }
}

