/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.EntityWithVersion;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.WorklogDocumentFactory;
import com.atlassian.jira.issue.worklog.Worklog;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorklogDocumentFactory
implements WorklogDocumentFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorklogDocumentFactory.class);
    private final SearchExtractorRegistrationManager searchExtractorManager;

    public DefaultWorklogDocumentFactory(SearchExtractorRegistrationManager searchExtractorManager) {
        this.searchExtractorManager = searchExtractorManager;
    }

    @Override
    public Optional<Document> createDocument(EntityWithVersion<Worklog> worklogWithVersion) {
        Worklog worklog = worklogWithVersion.getEntity();
        if (worklog == null) {
            return Optional.empty();
        }
        Issue issue = worklog.getIssue();
        log.debug("Indexing worklog: issueId={}, worklogId={}, version={}", new Object[]{issue.getId(), worklog.getId(), worklogWithVersion.getVersion()});
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(worklogWithVersion).addSearchableField("projid", String.valueOf(issue.getProjectId()), Field.Store.NO)).addSearchableField("issue_id", String.valueOf(issue.getId()), Field.Store.YES)).addSortableField("issue_id", String.valueOf(issue.getId()))).addSearchableField("worklog_id", String.valueOf(worklog.getId()), Field.Store.NO)).addSearchableField("worklog_date", LocalDateFactory.from((Date)worklog.getStartDate()), Field.Store.NO)).addKeywordWithDefault("worklog_level", worklog.getGroupLevel(), "-1")).addKeywordWithDefault("worklog_role_level", worklog.getRoleLevel() != null ? worklog.getRoleLevel().getId() : null, "-1")).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(Worklog.class));
        if (worklog.getAuthorKey() != null) {
            ((Builder)((Builder)builder.addSearchableField("worklog_author", worklog.getAuthorKey(), Field.Store.NO)).addSearchableField("visiblefieldids", "worklog_author", Field.Store.NO)).addSearchableField("nonemptyfieldids", "worklog_author", Field.Store.NO);
        }
        if (worklog.getComment() != null) {
            ((Builder)builder.addTokenizedField("worklog_comment", worklog.getComment(), Field.Store.NO)).addSearchableField("visiblefieldids", "worklog_comment", Field.Store.NO);
            if (StringUtils.isNotEmpty((CharSequence)worklog.getComment())) {
                builder.addSearchableField("nonemptyfieldids", "worklog_comment", Field.Store.NO);
            }
        }
        return builder.build();
    }

    @Override
    public Term getIdentifyingTerm(Worklog worklog) {
        return new Term(IndexDirectoryFactory.Name.WORKLOG.getEntityIdFieldName(), worklog.getId().toString());
    }

    private static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<Worklog, Builder> {
        private Builder(EntityWithVersion<Worklog> entity) {
            super(entity, "worklog");
        }

        @Override
        protected String getDocumentType() {
            return "worklog";
        }

        @Override
        protected IndexDirectoryFactory.Name getIndexName() {
            return IndexDirectoryFactory.Name.WORKLOG;
        }
    }
}

