/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.index.ha.NullAwareIssueIdsIssueIterable;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.StreamSupport;

class FromIdsIssuesBatcher
implements IssuesBatcher {
    private final Collection<Long> issuesIds;
    private final int batchSize;
    private final IssueManager issueManager;

    private FromIdsIssuesBatcher(Collection<Long> issuesIds, int batchSize, IssueManager issueManager) {
        this.batchSize = batchSize;
        this.issueManager = issueManager;
        this.issuesIds = issuesIds;
    }

    public static FromIdsIssuesBatcher from(Collection<Long> issuesIds, int batchSize, IssueManager issueManager) {
        return new FromIdsIssuesBatcher(issuesIds, batchSize, issueManager);
    }

    @Override
    public Iterator<IssuesIterable> iterator() {
        return StreamSupport.stream(Iterables.partition(this.issuesIds, (int)this.batchSize).spliterator(), false).map(batched -> new NullAwareIssueIdsIssueIterable((Iterable<Long>)batched, this.issueManager)).iterator();
    }
}

