/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IssueIdBatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class IndexReconciler
implements IssueIdBatcher.Spy {
    private final long[] indexedIssues;
    private final BitSet matched;
    private final List<Long> unIndexed = new ArrayList<Long>();

    public IndexReconciler(long[] indexedIssues) {
        this.indexedIssues = Arrays.copyOf(indexedIssues, indexedIssues.length);
        Arrays.sort(this.indexedIssues);
        this.matched = new BitSet(indexedIssues.length);
    }

    @Override
    public void spy(Issue issue) {
        int i = Arrays.binarySearch(this.indexedIssues, issue.getId());
        if (i >= 0) {
            this.matched.set(i);
        } else {
            this.unIndexed.add(issue.getId());
        }
    }

    public List<Long> getUnindexed() {
        return this.unIndexed;
    }

    public List<Long> getOrphans() {
        ArrayList<Long> orphans = new ArrayList<Long>();
        int i = this.matched.nextClearBit(0);
        while (0 <= i && i < this.indexedIssues.length) {
            orphans.add(this.indexedIssues[i]);
            i = this.matched.nextClearBit(i + 1);
        }
        return orphans;
    }
}

