/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.issue.index.IndexingFeatures;

public class IndexingFeaturesImpl
implements IndexingFeatures {
    private final JiraProperties jiraProperties;
    private static final String CF_VALUE_DRIVEN_INDEXING_DISABLED = "jira.cfv.driven.indexing.disabled";
    private static final String LOCAL_CONTEXT_INDEXING_DISABLED = "jira.local.context.indexing.disabled";
    private static final String SKIP_INDEXING_NULL_DISABLED = "jira.skip.indexing.null.disabled";
    private static final String CUSTOM_FIELD_INDEXING_BATCH_SIZE = "jira.custom.field.indexing.batch.size";
    private static final int CUSTOM_FIELD_INDEXING_DEFAULT_BATCH_SIZE = 50;

    public IndexingFeaturesImpl(JiraProperties jiraProperties) {
        this.jiraProperties = jiraProperties;
    }

    public boolean isCFValueDrivenIndexingEnabled() {
        return this.jiraProperties.getBoolean(CF_VALUE_DRIVEN_INDEXING_DISABLED) == false;
    }

    public boolean isLocalContextIndexingEnabled() {
        return this.jiraProperties.getBoolean(LOCAL_CONTEXT_INDEXING_DISABLED) == false;
    }

    public boolean isSkipIndexingNullEnabled() {
        return this.jiraProperties.getBoolean(SKIP_INDEXING_NULL_DISABLED) == false;
    }

    public int getCustomFieldIndexingBatchSize() {
        Integer customValue = this.jiraProperties.getInteger(CUSTOM_FIELD_INDEXING_BATCH_SIZE);
        if (customValue != null && customValue > 0) {
            return customValue;
        }
        return 50;
    }
}

