/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.StatisticsGeneratedEvent;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DefaultFieldManager;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IndexingStatsMetrics;
import com.atlassian.jira.issue.index.ReindexAllSlowIndexersEvent;
import com.atlassian.jira.issue.index.indexers.FieldIndexerStats;
import com.atlassian.jira.issue.index.indexers.FieldIndexerWithStats;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class IndexingStatsEventPublisher {
    private static final String MODULE_KEY = IndexingStatsEventPublisher.class.getCanonicalName();
    private final EventPublisher eventPublisher;
    private final DateTimeFormatter dateTimeFormatter;
    private final DefaultFieldManager defaultFieldManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ClusterManager clusterManager;

    public IndexingStatsEventPublisher(EventPublisher eventPublisher, DateTimeFormatterFactory dateTimeFormatterFactory, DefaultFieldManager defaultFieldManager, JiraAuthenticationContext jiraAuthenticationContext, ClusterManager clusterManager) {
        this.eventPublisher = eventPublisher;
        this.dateTimeFormatter = dateTimeFormatterFactory.formatter();
        this.defaultFieldManager = defaultFieldManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.clusterManager = clusterManager;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        this.eventPublisher.publish((Object)new StatisticsGeneratedEvent(MODULE_KEY, this.getHeaders(), Collections.emptyMap(), (Map<String, String>)this.getNoDataDescription(), true));
    }

    private ImmutableMap<String, String> getDescription(IndexingStatsMetrics stats) {
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        String date = this.dateTimeFormatter.forLoggedInUser().withStyle("COMPLETE").format(stats.getUpdated());
        return ImmutableMap.of((Object)Description.TEXT.key, (Object)i18n.getText(Description.TEXT.i18nKey, this.clusterManager.getNodeId(), date), (Object)Description.LINK.key, (Object)i18n.getText(Description.LINK.i18nKey), (Object)Description.HREF.key, (Object)i18n.getText(Description.HREF.i18nKey));
    }

    private ImmutableMap<String, String> getNoDataDescription() {
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        return ImmutableMap.of((Object)Description.TEXT.key, (Object)i18n.getText(MODULE_KEY + ".noDataText"), (Object)Description.LINK.key, (Object)i18n.getText(Description.LINK.i18nKey), (Object)Description.HREF.key, (Object)i18n.getText(Description.HREF.i18nKey));
    }

    private Map<String, String> getHeaders() {
        return (Map)Arrays.stream(Column.values()).collect(CollectorsUtil.toImmutableMap(column -> column.key, column -> this.jiraAuthenticationContext.getI18nHelper().getText(column.i18nKey)));
    }

    private Map<String, List<String>> getRows(IndexingStatsMetrics stats) {
        String period = stats.getPeriod();
        LinkedHashMap rows = new LinkedHashMap();
        stats.getTops().forEach((key, indexingStatsMetrics) -> {
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(period.substring(0, 1).toUpperCase() + period.substring(1));
            values.add(indexingStatsMetrics.getFieldName());
            values.add(this.jiraAuthenticationContext.getI18nHelper().getText(MODULE_KEY + "." + this.getFieldType((IndexingStatsMetrics.Metric)indexingStatsMetrics)));
            values.add(String.format("%.1f%%", indexingStatsMetrics.getPercentage()));
            values.add(String.format("%.1f ms", indexingStatsMetrics.getAverage()));
            values.add(String.format("%d ms", indexingStatsMetrics.getMax()));
            values.add(String.format("%d", indexingStatsMetrics.getCount()));
            rows.put(period + "." + key, values);
        });
        return ImmutableMap.copyOf(rows);
    }

    private String getFieldType(IndexingStatsMetrics.Metric indexingStatsMetrics) {
        String fieldId = indexingStatsMetrics.getId();
        if (indexingStatsMetrics.getKnown().booleanValue()) {
            return "systemField";
        }
        Field field = this.defaultFieldManager.getField(fieldId);
        if (field instanceof CustomField) {
            return "customField";
        }
        if (field != null) {
            return "systemField";
        }
        return "appCustomField";
    }

    public void publish(IndexingStatsMetrics total, IndexingStatsMetrics snapshot) {
        LinkedHashMap<String, List<String>> allRows = new LinkedHashMap<String, List<String>>();
        allRows.putAll(this.getRows(total));
        allRows.putAll(this.getRows(snapshot));
        this.eventPublisher.publish((Object)new StatisticsGeneratedEvent(MODULE_KEY, this.getHeaders(), (Map<String, List<String>>)allRows, (Map<String, String>)this.getDescription(total), false));
    }

    @Deprecated
    public void publishSlowIndexersStats(Set<FieldIndexerWithStats.Stats> stats) {
        this.eventPublisher.publish((Object)new ReindexAllSlowIndexersEvent(stats));
    }

    public void publishSlowIndexersStats(Iterable<FieldIndexerStats> stats) {
        this.eventPublisher.publish((Object)new ReindexAllSlowIndexersEvent(stats));
    }

    private static enum Description {
        TEXT("text"),
        LINK("link"),
        HREF("href");

        private final String key;
        private final String i18nKey;

        private Description(String key) {
            this.key = Objects.requireNonNull(key);
            this.i18nKey = MODULE_KEY + "." + this.key;
        }
    }

    private static enum Column {
        PERIOD("period"),
        FIELD_NAME("fieldName"),
        FIELD_TYPE("fieldType"),
        PERCENTAGE("percentage"),
        AVERAGE_TIME("averageTime"),
        MAX("max"),
        INDEXING_OPERATIONS("indexingOperations");

        private final String key;
        private final String i18nKey;

        private Column(String key) {
            this.key = Objects.requireNonNull(key);
            this.i18nKey = MODULE_KEY + "." + this.key;
        }
    }
}

