/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class IssueLinkIndexer
extends BaseFieldIndexer {
    private static final String PREFIX_LINK_TYPE = "l:";
    private static final String PREFIX_ISSUE = "i:";
    private static final String TERM_OUT = "d:o";
    private static final String TERM_IN = "d:i";
    private static final String SEPARATOR = ",";
    private final IssueLinkManager issueLinkManager;

    public static String createValue(Long issueLinkTypeId) {
        return PREFIX_LINK_TYPE + issueLinkTypeId;
    }

    public static String createValue(Long issueLinkTypeId, Direction direction) {
        return IssueLinkIndexer.createValue(issueLinkTypeId) + SEPARATOR + (direction == Direction.IN ? TERM_IN : TERM_OUT);
    }

    public static String createValue(Long issueLinkTypeId, Direction direction, Long otherIssueId) {
        return IssueLinkIndexer.createValue(issueLinkTypeId, direction) + ",i:" + otherIssueId;
    }

    public IssueLinkIndexer(FieldVisibilityManager fieldVisibilityManager, IssueLinkManager issueLinkManager) {
        super(fieldVisibilityManager);
        this.issueLinkManager = issueLinkManager;
    }

    public String getId() {
        return "issuelinks";
    }

    public String getDocumentFieldId() {
        return "issue_links";
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    public void addIndex(Document doc, Issue issue) {
        Long issueId = issue.getId();
        this.addFieldsToDoc(doc, this.issueLinkManager.getInwardLinks(issueId), Direction.IN);
        this.addFieldsToDoc(doc, this.issueLinkManager.getOutwardLinks(issueId), Direction.OUT);
    }

    private void addFieldsToDoc(Document doc, Collection<IssueLink> issueLinks, Direction direction) {
        for (IssueLink issueLink : issueLinks) {
            String fieldId = this.getDocumentFieldId();
            Long linkTypeId = issueLink.getLinkTypeId();
            Long otherIssue = direction == Direction.OUT ? issueLink.getDestinationId() : issueLink.getSourceId();
            String linkTypeIdValue = IssueLinkIndexer.createValue(linkTypeId);
            String linkTypeIdAndDirectionValue = IssueLinkIndexer.createValue(linkTypeId, direction);
            String linkTypeIdAndDirectionAndOtherIssueValue = IssueLinkIndexer.createValue(linkTypeId, direction, otherIssue);
            doc.add((IndexableField)new StringField(fieldId, linkTypeIdValue, Field.Store.NO));
            doc.add((IndexableField)new SortedSetDocValuesField(fieldId, new BytesRef((CharSequence)linkTypeIdValue)));
            doc.add((IndexableField)new StringField(fieldId, linkTypeIdAndDirectionValue, Field.Store.NO));
            doc.add((IndexableField)new SortedSetDocValuesField(fieldId, new BytesRef((CharSequence)linkTypeIdAndDirectionValue)));
            doc.add((IndexableField)new StringField(fieldId, linkTypeIdAndDirectionAndOtherIssueValue, Field.Store.NO));
            doc.add((IndexableField)new SortedSetDocValuesField(fieldId, new BytesRef((CharSequence)linkTypeIdAndDirectionAndOtherIssueValue)));
        }
    }
}

