/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.managers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.CustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.osgi.framework.FrameworkUtil;

final class CustomFieldIndexerAdapter
implements CustomFieldIndexer {
    @VisibleForTesting
    static final String ADD_INDEX_METRIC_NAME = "indexing.field.addIndex";
    @VisibleForTesting
    static final String INDEXABLE_FIELD_METRIC_NAME = "indexing.field.isFieldIndexableForIssue";
    private final FieldIndexer delegate;
    private final CustomField field;

    CustomFieldIndexerAdapter(FieldIndexer delegate, CustomField field) {
        this.delegate = delegate;
        this.field = field;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getDocumentFieldId() {
        return this.delegate.getDocumentFieldId();
    }

    public void addIndex(Document doc, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        try (Ticker ignored = this.startTimer(ADD_INDEX_METRIC_NAME);){
            this.delegate.addIndex(doc, issue, prefetchedData);
        }
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        try (Ticker ignored = this.startTimer(INDEXABLE_FIELD_METRIC_NAME);){
            boolean bl = this.delegate.isFieldVisibleAndInScope(issue);
            return bl;
        }
    }

    public Boolean skipsIndexingNull() {
        return this.delegate.skipsIndexingNull();
    }

    public CustomField getField() {
        return this.field;
    }

    private Ticker startTimer(@Nonnull String metricName) {
        return Metrics.metric((String)metricName).tag("fieldName", this.getField().getFieldName()).tag("fieldId", this.getId()).tag("fromPluginKey", this.getPluginKey()).withAnalytics().startTimer();
    }

    private String getPluginKey() {
        return Optional.ofNullable(FrameworkUtil.getBundle(this.delegate.getClass())).map(OsgiHeaderUtil::getPluginKey).orElse(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CustomFieldIndexerAdapter{");
        sb.append("delegate=").append(this.delegate);
        sb.append(", field=").append(this.field);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFieldIndexerAdapter that = (CustomFieldIndexerAdapter)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

