/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.managers;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderManager;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderStatsCollector;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderWithStats;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class NonNullCustomFieldProviderManagerImpl
implements NonNullCustomFieldProviderManager {
    private static final Logger log = LoggerFactory.getLogger(NonNullCustomFieldProviderManagerImpl.class);
    private final ComponentReference<PluginAccessor> pluginAccessorRef = ComponentAccessor.getComponentReference(PluginAccessor.class);
    private final ComponentReference<CustomFieldManager> customFieldManagerRef = ComponentAccessor.getComponentReference(CustomFieldManager.class);
    private final Cache<Object, NonNullCustomFieldProviderWithStats> uniqueProvidersWithStats = CacheBuilder.newBuilder().weakKeys().build();

    @Override
    public Collection<NonNullCustomFieldProvider> getNonNullCustomFieldProviders() {
        return this.calculateProviders();
    }

    private Set<NonNullCustomFieldProvider> calculateProviders() {
        return this.getCustomFieldTypes().stream().map(this::getProvider).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private Optional<NonNullCustomFieldProviderWithStats> getProvider(CustomFieldType<?, ?> cft) {
        NonNullCustomFieldProvider provider = cft.getNonNullCustomFieldProvider();
        if (provider == null) {
            return Optional.empty();
        }
        try {
            NonNullCustomFieldProviderWithStats providerWithStats;
            try {
                providerWithStats = (NonNullCustomFieldProviderWithStats)this.uniqueProvidersWithStats.get(provider.getIdentity(), () -> new NonNullCustomFieldProviderWithStats(provider));
                providerWithStats.getIdentity();
            }
            catch (RuntimeException e) {
                this.uniqueProvidersWithStats.invalidate(provider.getIdentity());
                providerWithStats = (NonNullCustomFieldProviderWithStats)this.uniqueProvidersWithStats.get(provider.getIdentity(), () -> new NonNullCustomFieldProviderWithStats(provider));
                log.debug("Rewired {}::{}::{}->{} to {}->{}", new Object[]{NonNullCustomFieldProviderManagerImpl.hashCodeToString(cft.getDescriptor().getPlugin()), NonNullCustomFieldProviderManagerImpl.hashCodeToString(cft.getDescriptor()), NonNullCustomFieldProviderManagerImpl.hashCodeToString(provider), NonNullCustomFieldProviderManagerImpl.hashCodeToString(provider.getIdentity()), NonNullCustomFieldProviderManagerImpl.hashCodeToString(providerWithStats), NonNullCustomFieldProviderManagerImpl.hashCodeToString(providerWithStats.getIdentity())});
            }
            return Optional.of(providerWithStats);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static String hashCodeToString(Object object) {
        return "0x" + Integer.toString(System.identityHashCode(object), 16);
    }

    @Override
    public Optional<? extends NonNullCustomFieldProviderStatsCollector> getNonNullCustomFieldProviderStatsCollector(String customFieldId) {
        CustomField customField = ((CustomFieldManager)this.customFieldManagerRef.get()).getCustomFieldObject(customFieldId);
        return Optional.ofNullable(customField).map(CustomField::getCustomFieldType).map(CustomFieldType::getNonNullCustomFieldProvider).map(NonNullCustomFieldProvider::getIdentity).map(arg_0 -> this.uniqueProvidersWithStats.getIfPresent(arg_0));
    }

    @Override
    public void resetStats() {
        this.uniqueProvidersWithStats.asMap().values().forEach(NonNullCustomFieldProviderWithStats::resetStats);
    }

    private List<CustomFieldType<?, ?>> getCustomFieldTypes() {
        return ((PluginAccessor)this.pluginAccessorRef.get()).getEnabledModulesByClass(CustomFieldType.class);
    }
}

