/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.managers;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderStats;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderStatsCollector;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@Internal
public class NonNullCustomFieldProviderWithStats
implements NonNullCustomFieldProvider,
NonNullCustomFieldProviderStatsCollector {
    private final NonNullCustomFieldProvider delegate;
    private final Ticker ticker = Ticker.systemTicker();
    private final MutableNonNullCustomFieldProviderStats stats = new MutableNonNullCustomFieldProviderStats();

    NonNullCustomFieldProviderWithStats(NonNullCustomFieldProvider delegate) {
        this.delegate = delegate;
    }

    public final boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public final int hashCode() {
        return this.getIdentity().hashCode();
    }

    public Object getIdentity() {
        return this.delegate.getIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Map<String, CustomFieldPrefetchedData>> getCustomFieldInfo(List<Issue> issues) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        Map result = null;
        try {
            result = this.delegate.getCustomFieldInfo(issues);
        }
        finally {
            long elapsedTime = stopwatch.elapsed(TimeUnit.MICROSECONDS);
            if (CollectionUtils.isNotEmpty(issues)) {
                this.stats.getCustomFieldInfo(elapsedTime, result);
            }
        }
        return result;
    }

    @Override
    public NonNullCustomFieldProviderStats getStatsAndResetSnapshot() {
        try {
            NonNullCustomFieldProviderStats nonNullCustomFieldProviderStats = this.getStats();
            return nonNullCustomFieldProviderStats;
        }
        finally {
            this.stats.resetSnapshot();
        }
    }

    @Override
    public void resetStats() {
        this.stats.reset();
    }

    @Override
    public NonNullCustomFieldProviderStats getStats() {
        return new Stats(this);
    }

    private static class MutableNonNullCustomFieldProviderStats {
        private final Map<String, MutableLongStats> totalTimeGetCustomFieldInfo = new ConcurrentHashMap<String, MutableLongStats>();
        private final Map<String, MutableLongStats> snapshotTimeGetCustomFieldInfo = new ConcurrentHashMap<String, MutableLongStats>();

        private MutableNonNullCustomFieldProviderStats() {
        }

        void getCustomFieldInfo(long timeToAddMicros, Map<Long, Map<String, CustomFieldPrefetchedData>> customFieldsPrefetchedData) {
            if (MapUtils.isEmpty(customFieldsPrefetchedData) || customFieldsPrefetchedData.values().stream().allMatch(MapUtils::isEmpty)) {
                return;
            }
            long timeToAddMicrosAvg = timeToAddMicros / customFieldsPrefetchedData.values().stream().mapToLong(map -> map.keySet().size()).sum();
            customFieldsPrefetchedData.values().stream().map(Map::keySet).flatMap(Collection::stream).forEach(customFieldId -> {
                this.totalTimeGetCustomFieldInfo.computeIfAbsent((String)customFieldId, f -> new MutableLongStats(new long[0])).accept(timeToAddMicrosAvg);
                this.snapshotTimeGetCustomFieldInfo.computeIfAbsent((String)customFieldId, f -> new MutableLongStats(new long[0])).accept(timeToAddMicrosAvg);
            });
        }

        void resetSnapshot() {
            this.snapshotTimeGetCustomFieldInfo.clear();
        }

        void resetTotal() {
            this.totalTimeGetCustomFieldInfo.clear();
        }

        void reset() {
            this.resetSnapshot();
            this.resetTotal();
        }
    }

    public static class Stats
    implements NonNullCustomFieldProviderStats {
        private final Map<String, LongStats> totalTimeGetCustomFieldInfo;
        private final Map<String, LongStats> snapshotTimeGetCustomFieldInfo;

        Stats(NonNullCustomFieldProviderWithStats nonNullCustomFieldProviderWithStats) {
            this.totalTimeGetCustomFieldInfo = nonNullCustomFieldProviderWithStats.stats.totalTimeGetCustomFieldInfo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MutableLongStats)e.getValue()).get()));
            this.snapshotTimeGetCustomFieldInfo = nonNullCustomFieldProviderWithStats.stats.snapshotTimeGetCustomFieldInfo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MutableLongStats)e.getValue()).get()));
        }

        @Override
        public LongStats totalTimeGetCustomFieldInfo(String customFieldId) {
            return this.totalTimeGetCustomFieldInfo.get(customFieldId);
        }

        @Override
        public LongStats snapshotTimeGetCustomFieldInfo(String customFieldId) {
            return this.snapshotTimeGetCustomFieldInfo.get(customFieldId);
        }
    }
}

