/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label.suggestions;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.analytics.AnalyticsSender;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.suggestions.LabelSuggesterStats;
import com.atlassian.jira.issue.label.suggestions.PopularLabelsProvider;
import com.atlassian.jira.issue.label.suggestions.PrefixSearchLabelsProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.stats.JiraStats;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Duration;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class LabelSuggester {
    private static final int DEFAULT_MAX_SUGGESTIONS = 20;
    private final ApplicationProperties applicationProperties;
    private final PopularLabelsProvider popularLabelsProvider;
    private final PrefixSearchLabelsProvider prefixSearchLabelsProvider;

    public LabelSuggester(ApplicationProperties applicationProperties, EventPublisher eventPublisher, IssueIndexManager issueIndexManager) {
        this(applicationProperties, eventPublisher, issueIndexManager, Clock.systemUTC(), (LabelSuggesterStats)JiraStats.create(LabelSuggesterStats.class, LabelSuggesterStats.Data::new, (boolean)false));
    }

    @VisibleForTesting
    LabelSuggester(ApplicationProperties applicationProperties, EventPublisher eventPublisher, IssueIndexManager issueIndexManager, Clock clock, LabelSuggesterStats stats) {
        this.applicationProperties = applicationProperties;
        AnalyticsSender.registerAnalyticsSender(stats, eventPublisher, LabelSuggesterStats.AnalyticsEvent::new);
        this.popularLabelsProvider = new PopularLabelsProvider(issueIndexManager, clock, stats);
        this.prefixSearchLabelsProvider = new PrefixSearchLabelsProvider();
    }

    public Set<String> getSuggestedLabels(String token, Set<Label> issueLabels, ApplicationUser user) {
        return this.getSuggestions(token, issueLabels, "labels_folded", "labels", user);
    }

    public Set<String> getSuggestedLabels(String token, Long customFieldId, Set<Label> issueLabels, ApplicationUser user) {
        String searchField = "customfield_" + customFieldId;
        return this.getSuggestions(token, issueLabels, searchField + "_folded", searchField, user);
    }

    private Set<String> getSuggestions(String token, Set<Label> issueLabels, String searchField, String displayField, ApplicationUser user) {
        int limit = this.getSuggestionLimit();
        Duration timeout = this.getSuggestionTimeout();
        if (StringUtils.isEmpty((CharSequence)token)) {
            return this.popularLabelsProvider.findMostPopular(displayField, user, issueLabels, limit, timeout);
        }
        return this.prefixSearchLabelsProvider.findByPrefixToken(token, searchField, displayField, user, issueLabels, limit);
    }

    private int getSuggestionLimit() {
        String labelString = this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.labelsuggestion.limit");
        int limit = 20;
        if (StringUtils.isNumeric((CharSequence)labelString) && (limit = Integer.parseInt(labelString)) == 0) {
            limit = Integer.MAX_VALUE;
        }
        return limit;
    }

    private Duration getSuggestionTimeout() {
        String timeoutString = this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.labelsuggestion.timeout.ms");
        long timeout = 5000L;
        if (StringUtils.isNumeric((CharSequence)timeoutString)) {
            timeout = Long.parseLong(timeoutString);
        }
        return Duration.ofMillis(timeout);
    }
}

