/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label.suggestions;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.util.stats.LastValueSerializableStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public interface LabelSuggesterStats
extends ManagedStats {
    public void settings(int var1, Duration var2);

    public void popularLabelsTimedOut(String var1, Duration var2, int var3, int var4, int var5);

    public void popularLabelsCollected(String var1, Duration var2, Duration var3, int var4, int var5, int var6);

    public static class Data
    implements LabelSuggesterStats {
        private static final String CUSTOM_FIELD_AGGREGATED_KEY = "customfield_aggregated";
        final Settings settings = new Settings();
        final Map<String, PopularLabels> popularLabels = new TreeMap(Collections.reverseOrder());

        public String getStatsName() {
            return "LabelSuggesterStats";
        }

        @Override
        public void settings(int limit, Duration timeout) {
            this.settings.limit.store((Object)limit);
            this.settings.timeoutInMillis.store((Object)timeout.toMillis());
        }

        @Override
        public void popularLabelsTimedOut(String field, Duration timeToCollectPopularLabelTerms, int searchedLabelTermsCount, int allPopularLabelTermsCount, int collectedLabelsCount) {
            this.getPopularLabelsForField(field).forEach(popularLabels -> {
                popularLabels.timedOut.collectTermsTimeInMillis.accept(timeToCollectPopularLabelTerms.toMillis());
                popularLabels.timedOut.searchedLabelTermsCount.accept((long)searchedLabelTermsCount);
                popularLabels.timedOut.allPopularLabelTermsCount.store((Object)allPopularLabelTermsCount);
                popularLabels.timedOut.collectedLabelsCount.accept((long)collectedLabelsCount);
            });
        }

        @Override
        public void popularLabelsCollected(String field, Duration timeToCollectPopularLabelTerms, Duration timeToCollectPopularLabels, int searchedLabelTermsCount, int allPopularLabelTermsCount, int collectedLabelsCount) {
            this.getPopularLabelsForField(field).forEach(popularLabels -> {
                popularLabels.collected.collectTermsTimeInMillis.accept(timeToCollectPopularLabelTerms.toMillis());
                popularLabels.collected.searchedLabelTermsCount.accept((long)searchedLabelTermsCount);
                popularLabels.collected.allPopularLabelTermsCount.store((Object)allPopularLabelTermsCount);
                popularLabels.collected.collectLabelsTimeInMillis.accept(timeToCollectPopularLabels.toMillis());
                popularLabels.collected.collectedLabelsCount.accept((long)collectedLabelsCount);
            });
        }

        private Stream<PopularLabels> getPopularLabelsForField(String field) {
            if (field.startsWith("customfield_")) {
                return Stream.of(this.popularLabels.computeIfAbsent(field, k -> new PopularLabels()), this.popularLabels.computeIfAbsent(CUSTOM_FIELD_AGGREGATED_KEY, k -> new PopularLabels()));
            }
            return Stream.of(this.popularLabels.computeIfAbsent(field, k -> new PopularLabels()));
        }

        static class Settings {
            final LastValueSerializableStats<Integer> limit = new LastValueSerializableStats();
            final LastValueSerializableStats<Long> timeoutInMillis = new LastValueSerializableStats();

            Settings() {
            }
        }

        static class PopularLabels {
            final TimedOut timedOut = new TimedOut();
            final Collected collected = new Collected();

            PopularLabels() {
            }

            private static MutableLongStats newCollectTermsTimeInMillisAccumulator() {
                return new MutableLongStats(new long[]{100L, 200L, 500L, 1000L});
            }

            private static MutableLongStats newCollectLabelsTimeInMillisAccumulator() {
                return new MutableLongStats(new long[]{100L, 200L, 500L, 1000L, 5000L});
            }

            private static MutableLongStats newSearchedLabelsCountAccumulator() {
                return new MutableLongStats(new long[]{20L, 100L, 1000L});
            }

            private static MutableLongStats newCollectedLabelsCountAccumulator() {
                return new MutableLongStats(new long[0]);
            }

            static class TimedOut {
                final MutableLongStats collectTermsTimeInMillis = PopularLabels.newCollectTermsTimeInMillisAccumulator();
                final MutableLongStats searchedLabelTermsCount = PopularLabels.newSearchedLabelsCountAccumulator();
                final LastValueSerializableStats<Integer> allPopularLabelTermsCount = new LastValueSerializableStats();
                final MutableLongStats collectedLabelsCount = PopularLabels.newCollectedLabelsCountAccumulator();

                TimedOut() {
                }
            }

            static class Collected {
                final MutableLongStats collectTermsTimeInMillis = PopularLabels.newCollectTermsTimeInMillisAccumulator();
                final MutableLongStats collectLabelsTimeInMillis = PopularLabels.newCollectLabelsTimeInMillisAccumulator();
                final MutableLongStats searchedLabelTermsCount = PopularLabels.newSearchedLabelsCountAccumulator();
                final LastValueSerializableStats<Integer> allPopularLabelTermsCount = new LastValueSerializableStats();
                final MutableLongStats collectedLabelsCount = PopularLabels.newCollectedLabelsCountAccumulator();

                Collected() {
                }
            }
        }
    }

    @EventName(value="jira.label.suggester.stats")
    public static class AnalyticsEvent
    extends com.atlassian.jira.analytics.AnalyticsEvent {
        public AnalyticsEvent(@Nullable Map<Object, Object> snapshot, @Nullable Map<Object, Object> total) {
            super(null, AnalyticsEvent.addDurationAsLong(total));
        }
    }
}

