/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label.suggestions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.suggestions.LabelSuggesterStats;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.misc.HighFreqTerms;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TermQuery;

class PopularLabelsProvider {
    private final IssueIndexManager issueIndexManager;
    private final Clock clock;
    private final LabelSuggesterStats stats;

    PopularLabelsProvider(IssueIndexManager issueIndexManager, Clock clock, LabelSuggesterStats stats) {
        this.issueIndexManager = issueIndexManager;
        this.clock = clock;
        this.stats = stats;
    }

    public Set<String> findMostPopular(String searchField, ApplicationUser user, Set<Label> issueLabels, int limit, Duration timeout) {
        Preconditions.checkArgument((!timeout.isNegative() ? 1 : 0) != 0);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0);
        this.stats.settings(limit, timeout);
        if (limit == 0 || timeout.isZero()) {
            return ImmutableSet.of();
        }
        Instant startTime = this.clock.instant();
        Set excludedLabels = issueLabels.stream().map(Label::getLabel).collect(Collectors.toSet());
        IndexReader indexReader = this.issueIndexManager.getIssueSearcher().getIndexReader();
        try {
            int termIdx;
            Terms labelTerms = MultiFields.getTerms((IndexReader)indexReader, (String)searchField);
            if (labelTerms == null) {
                return ImmutableSet.of();
            }
            int popularLabelTermsLimit = Math.min(Math.max(1000, limit), 1000000);
            TermStats[] popularLabelTerms = HighFreqTerms.getHighFreqTerms((IndexReader)indexReader, (int)popularLabelTermsLimit, (String)searchField, (Comparator)new HighFreqTerms.DocFreqComparator());
            Duration timeToCollectPopularLabelTerms = this.elapsedSince(startTime);
            LinkedHashSet<String> visibleToUser = new LinkedHashSet<String>();
            SearchProvider searchProvider = (SearchProvider)ComponentAccessor.getComponent(SearchProvider.class);
            for (termIdx = 0; termIdx < popularLabelTerms.length && visibleToUser.size() < limit; ++termIdx) {
                if (this.elapsedSince(startTime).compareTo(timeout) > 0) {
                    this.stats.popularLabelsTimedOut(searchField, timeToCollectPopularLabelTerms, termIdx, popularLabelTerms.length, visibleToUser.size());
                    break;
                }
                String label = popularLabelTerms[termIdx].termtext.utf8ToString();
                if (excludedLabels.contains(label)) continue;
                searchProvider.search(PopularLabelsProvider.getQuery(user, searchField, label), (Collector)new AnyIssueMatchedCollector(() -> visibleToUser.add(label)));
            }
            Duration timeToCollectPopularLabels = this.elapsedSince(startTime);
            this.stats.popularLabelsCollected(searchField, timeToCollectPopularLabelTerms, timeToCollectPopularLabels, termIdx, popularLabelTerms.length, visibleToUser.size());
            return visibleToUser;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Duration elapsedSince(Instant startTime) {
        return Duration.between(startTime, this.clock.instant());
    }

    private static SearchQuery getQuery(ApplicationUser user, String searchField, String label) {
        return SearchQuery.create((Query)new QueryImpl(), (ApplicationUser)user).luceneQuery((org.apache.lucene.search.Query)new TermQuery(new Term(searchField, label)));
    }

    private static class AnyIssueMatchedCollector
    extends SimpleCollector {
        private final Runnable runOnceWhenFirstIssueMatches;
        private boolean anyIssueMatched;

        public AnyIssueMatchedCollector(Runnable runOnceWhenFirstIssueMatches) {
            this.runOnceWhenFirstIssueMatches = runOnceWhenFirstIssueMatches;
        }

        protected void doSetNextReader(LeafReaderContext context) {
            if (this.anyIssueMatched) {
                throw new CollectionTerminatedException();
            }
        }

        public void collect(int doc) {
            this.anyIssueMatched = true;
            this.runOnceWhenFirstIssueMatches.run();
            throw new CollectionTerminatedException();
        }

        public boolean needsScores() {
            return false;
        }
    }
}

