/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label.suggestions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.util.PrefixFieldHitCollector;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;

public class PrefixSearchLabelsProvider {
    public Set<String> findByPrefixToken(String prefix, String searchField, String displayField, ApplicationUser searchUser, Set<Label> issueLabels, int limit) {
        TreeSet<String> suggestions = new TreeSet<String>();
        try {
            this.getSearchProvider().search(SearchQuery.create((com.atlassian.query.Query)new SearchRequest().getQuery(), (ApplicationUser)searchUser).luceneQuery(this.createLuceneQuery(prefix, searchField)), (Collector)this.createCollector(prefix, displayField, suggestions));
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return this.limit(this.orderSuggestionsByMatchingTokenCaseFirst(this.removeSuggestionsFoundInIssueLabels(suggestions, issueLabels), prefix), limit);
    }

    private PrefixFieldHitCollector createCollector(String prefix, String displayField, Set<String> suggestions) {
        return new PrefixFieldHitCollector(displayField, prefix, suggestions);
    }

    private Set<String> removeSuggestionsFoundInIssueLabels(Set<String> suggestions, Set<Label> issueLabels) {
        Set issueLabelStrings = issueLabels.stream().map(Label::getLabel).collect(Collectors.toSet());
        return Sets.filter(suggestions, suggestion -> !issueLabelStrings.contains(suggestion));
    }

    private Set<String> orderSuggestionsByMatchingTokenCaseFirst(Set<String> suggestions, String token) {
        LinkedHashSet<String> orderedSuggestions = new LinkedHashSet<String>(suggestions.size());
        orderedSuggestions.addAll(Sets.filter(suggestions, label -> label.startsWith(token)));
        orderedSuggestions.addAll(Sets.filter(suggestions, label -> !label.startsWith(token)));
        return orderedSuggestions;
    }

    private Set<String> limit(Set<String> suggestions, long limit) {
        return suggestions.stream().limit(limit).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Query createLuceneQuery(String prefix, String searchField) {
        return new PrefixQuery(new Term(searchField, prefix.toLowerCase()));
    }

    private SearchProvider getSearchProvider() {
        return (SearchProvider)ComponentAccessor.getComponentOfType(SearchProvider.class);
    }
}

