/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.config.util.AttachmentConfigManager;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.managers.IssueAttachmentDeleteHelper;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.List;
import java.util.Objects;

public final class DefaultIssueAttachmentDeleteHelper
implements IssueAttachmentDeleteHelper {
    private final AttachmentManager attachmentManager;
    private final AttachmentConfigManager attachmentConfigManager;
    private final StreamAttachmentStore streamAttachmentStore;
    private final ThumbnailManager thumbnailManager;

    public DefaultIssueAttachmentDeleteHelper(AttachmentManager attachmentManager, AttachmentConfigManager attachmentConfigManager, StreamAttachmentStore streamAttachmentStore, ThumbnailManager thumbnailManager) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
        this.attachmentConfigManager = Objects.requireNonNull(attachmentConfigManager);
        this.streamAttachmentStore = Objects.requireNonNull(streamAttachmentStore);
        this.thumbnailManager = Objects.requireNonNull(thumbnailManager);
    }

    @Override
    public Promise<Void> deleteAttachmentsForIssue(Issue issue) {
        if (this.attachmentConfigManager.isAttachmentsEnabled()) {
            try {
                List attachments = this.attachmentManager.getAttachments(issue);
                for (Attachment a : attachments) {
                    this.attachmentManager.deleteAttachment(a);
                }
            }
            catch (RemoveException e) {
                return Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
            }
            this.thumbnailManager.deleteThumbnailsForIssue(issue);
            return this.streamAttachmentStore.deleteAttachmentContainerForIssue(issue).map(unit -> null);
        }
        return Promises.promise(null);
    }
}

