/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.ArrayList;
import java.util.List;

public class ClauseReplacingCloningVisitor
implements ClauseVisitor<Clause> {
    private final List<TerminalClause> substitutions;

    public ClauseReplacingCloningVisitor(List<TerminalClause> substitutions) {
        this.substitutions = substitutions;
    }

    public Clause visit(AndClause andClause) {
        List clauses = andClause.getClauses();
        ArrayList<Clause> subClauses = new ArrayList<Clause>(clauses.size());
        for (Clause clause : clauses) {
            subClauses.add((Clause)clause.accept((ClauseVisitor)this));
        }
        return new AndClause(subClauses);
    }

    public Clause visit(NotClause notClause) {
        Clause newSubClause = (Clause)notClause.getSubClause().accept((ClauseVisitor)this);
        return new NotClause(newSubClause);
    }

    public Clause visit(OrClause orClause) {
        List clauses = orClause.getClauses();
        ArrayList<Clause> subClauses = new ArrayList<Clause>(clauses.size());
        for (Clause clause : clauses) {
            subClauses.add((Clause)clause.accept((ClauseVisitor)this));
        }
        return new OrClause(subClauses);
    }

    public Clause visit(TerminalClause clause) {
        if (this.substitutions != null) {
            for (TerminalClause substitution : this.substitutions) {
                if (!clause.getName().equalsIgnoreCase(substitution.getName())) continue;
                return substitution;
            }
        }
        return clause;
    }

    public Clause visit(WasClause clause) {
        return clause;
    }

    public Clause visit(ChangedClause clause) {
        return clause;
    }
}

