/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.plugin.web.model.WebFragmentBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavouriteFilterLinkFactory
implements WebItemProvider {
    private static final Logger log = LoggerFactory.getLogger(FavouriteFilterLinkFactory.class);
    private static final int DEFAULT_FILTER_DROPDOWN_ITEMS = 10;
    private static final int MAX_LABEL_LENGTH = 30;
    private final SearchRequestService searchRequestService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nFactory;

    public FavouriteFilterLinkFactory(SearchRequestService searchRequestService, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nFactory) {
        this.searchRequestService = searchRequestService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.i18nFactory = i18nFactory;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ApplicationUser user = (ApplicationUser)context.get("user");
        Collection filters = this.searchRequestService.getFavouriteFilters(user);
        ArrayList links = Lists.newArrayList();
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        String baseUrl = requestContext.getBaseUrl();
        int maxItems = this.getMaxDropdownItems();
        int weight = 0;
        if (user != null) {
            String myFilter = i18n.getText("issue.nav.filters.my.open.issues");
            links.add(new WebFragmentBuilder(weight += 10).id("filter_lnk_my").label(myFilter).title(myFilter).addParam("class", "filter-link").addParam("data-filter-id", "-1").webItem("find_link/issues_filter_main").url(baseUrl + "/issues/?filter=-1").build());
            String reportedFilter = i18n.getText("issue.nav.filters.reported.by.me");
            links.add(new WebFragmentBuilder(weight += 10).id("filter_lnk_reported").label(reportedFilter).title(reportedFilter).addParam("class", "filter-link").addParam("data-filter-id", "-2").webItem("find_link/issues_filter_main").url(baseUrl + "/issues/?filter=-2").build());
        }
        if (filters != null && !filters.isEmpty()) {
            Iterator filterIterator = filters.iterator();
            for (int i = 0; i < maxItems && filterIterator.hasNext(); ++i) {
                SearchRequest filter = (SearchRequest)filterIterator.next();
                String name = filter.getName();
                Object shortName = name;
                if (((String)shortName).length() > 30) {
                    shortName = ((String)shortName).substring(0, 30) + "...";
                }
                String title = StringUtils.isBlank((CharSequence)filter.getDescription()) ? name : i18n.getText("menu.issues.filter.title", name, filter.getDescription());
                links.add(new WebFragmentBuilder(weight += 10).id("filter_lnk_" + filter.getId()).label((String)shortName).title(title).addParam("class", "filter-link").addParam("data-filter-id", filter.getId().toString()).webItem("find_link/issues_filter_main").url(baseUrl + "/issues/?filter=" + filter.getId()).build());
            }
            if (filters.size() > maxItems) {
                String url = baseUrl + "/secure/ManageFilters.jspa?filterView=favourites";
                links.add(new WebFragmentBuilder(weight + 10).id("filter_lnk_more").label(i18n.getText("menu.issues.filter.more")).title(i18n.getText("menu.issues.filter.more.desc")).webItem("find_link/issues_filter_main").url(url).build());
            }
        }
        return links;
    }

    private int getMaxDropdownItems() {
        int maxItems = 10;
        try {
            maxItems = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.max.issue.filter.dropdown.items"));
        }
        catch (NumberFormatException e) {
            log.warn("Incorrect format of property 'jira.max.issue.filter.dropdown.items'.  Should be a number.");
        }
        return maxItems;
    }
}

