/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;

public class LuceneQueryMetrics {
    private static final Pattern CUSTOM_FIELD_TERM_PATTERN = Pattern.compile("customfield_\\d*");

    public Map<String, TermMetric> getQueryTermMetrics(Query query) {
        HashMap<String, TermMetric> groupBy = new HashMap<String, TermMetric>();
        this.groupByTermCount(query, groupBy);
        return groupBy;
    }

    private void groupByTermCount(Query query, Map<String, TermMetric> groupBy) {
        if (query instanceof TermQuery) {
            this.increaseTermCount(groupBy, ((TermQuery)query).getTerm());
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                this.groupByTermCount(clause.getQuery(), groupBy);
            }
        } else if (query instanceof PhraseQuery) {
            for (Term term : ((PhraseQuery)query).getTerms()) {
                this.increaseTermCount(groupBy, term);
            }
        } else if (query instanceof FuzzyQuery) {
            this.increaseTermCount(groupBy, ((FuzzyQuery)query).getTerm());
        } else if (query instanceof TermRangeQuery) {
            this.increaseTermCount(groupBy, ((TermRangeQuery)query).getField());
        } else if (query instanceof PrefixQuery) {
            this.increaseTermCount(groupBy, ((PrefixQuery)query).getPrefix());
        } else if (query instanceof WildcardQuery) {
            this.increaseTermCount(groupBy, ((WildcardQuery)query).getTerm());
        } else {
            this.increaseTermCount(groupBy, query.getClass().getName());
        }
    }

    private void increaseTermCount(Map<String, TermMetric> groupBy, Term term) {
        this.increaseTermCount(groupBy, term.toString());
    }

    private void increaseTermCount(Map<String, TermMetric> groupBy, String field) {
        TermMetric termMetric = groupBy.get(field);
        if (termMetric == null) {
            termMetric = new TermMetric(field);
            groupBy.put(field, termMetric);
        }
        termMetric.increment();
    }

    public class TermMetric {
        private int count = 0;
        private final boolean customField;

        private TermMetric(String field) {
            this.customField = CUSTOM_FIELD_TERM_PATTERN.matcher(field).find();
        }

        private void increment() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isCustomField() {
            return this.customField;
        }

        public String toString() {
            return "TermMetric{count=" + this.count + ", isCustomField=" + this.customField + "}";
        }
    }
}

