/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.UserSearchInput;
import com.atlassian.jira.issue.search.searchers.util.UserSearcherHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.atlassian.webresource.api.WebResourceManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import webwork.action.Action;

public abstract class AbstractUserSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    public static final String SELECT_LIST_NONE = "select.list.none";
    public static final String SELECT_LIST_USER = "select.list.user";
    public static final String SELECT_LIST_GROUP = "select.list.group";
    private final UserFieldSearchConstants searchConstants;
    private final String emptySelectFlag;
    private final String nameKey;
    private final ApplicationProperties applicationProperties;
    private final UserSearchService searchService;
    private final UserManager userManager;
    protected final PermissionManager permissionManager;
    protected UserSearcherHelper userSearcherHelper;

    public AbstractUserSearchRenderer(UserFieldSearchConstantsWithEmpty searchConstants, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, UserSearchService searchService, UserManager userManager, PermissionManager permissionManager) {
        this((UserFieldSearchConstants)searchConstants, searchConstants.getEmptySelectFlag(), nameKey, velocityRequestContextFactory, applicationProperties, templatingEngine, searchService, userManager, permissionManager, (UserSearcherHelper)ComponentAccessor.getComponent(UserSearcherHelper.class));
    }

    public AbstractUserSearchRenderer(UserFieldSearchConstants searchConstants, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, UserSearchService searchService, UserManager userManager, PermissionManager permissionManager) {
        this(searchConstants, null, nameKey, velocityRequestContextFactory, applicationProperties, templatingEngine, searchService, userManager, permissionManager, (UserSearcherHelper)ComponentAccessor.getComponent(UserSearcherHelper.class));
    }

    private AbstractUserSearchRenderer(UserFieldSearchConstants searchConstants, String emptySelectFlag, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, UserSearchService searchService, UserManager userManager, PermissionManager permissionManager, UserSearcherHelper userSearcherHelper) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants.getSearcherId(), nameKey);
        this.emptySelectFlag = emptySelectFlag;
        this.searchConstants = searchConstants;
        this.nameKey = nameKey;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.userSearcherHelper = userSearcherHelper;
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("selectListOptions", this.getSelectedListOptions(user));
        return this.renderEditTemplate("user-searcher-edit.vm", velocityParams);
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderViewTemplate("user-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(this.searchConstants.getJqlClauseNames(), query);
    }

    protected abstract List<Map<String, String>> getSelectedListOptions(ApplicationUser var1);

    protected abstract String getEmptyValueKey();

    protected String getTextForuser(ApplicationUser searcher, FieldValuesHolder fieldValuesHolder) {
        String selectList = (String)fieldValuesHolder.get((Object)this.searchConstants.getSelectUrlParameter());
        if (this.emptySelectFlag != null && this.emptySelectFlag.equals(selectList)) {
            return this.getI18n(searcher).getText(this.getEmptyValueKey());
        }
        if (this.searchConstants.getCurrentUserSelectFlag().equals(selectList)) {
            return this.getI18n(searcher).getText("reporter.types.currentuser");
        }
        return (String)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
    }

    private String getLinkedUser(ApplicationUser searcher, FieldValuesHolder fieldValuesHolder) {
        String selectList = (String)fieldValuesHolder.get((Object)this.searchConstants.getSelectUrlParameter());
        if (this.searchConstants.getCurrentUserSelectFlag().equals(selectList)) {
            if (searcher != null) {
                return searcher.getName();
            }
        } else if (this.searchConstants.getSpecificUserSelectFlag().equals(selectList)) {
            return (String)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
        }
        return null;
    }

    private String getLinkedGroup(ApplicationUser searcher, FieldValuesHolder fieldValuesHolder) {
        String selectList = (String)fieldValuesHolder.get((Object)this.searchConstants.getSelectUrlParameter());
        if (this.searchConstants.getSpecificGroupSelectFlag().equals(selectList) && ComponentAccessor.getPermissionManager().hasPermission(0, searcher)) {
            return (String)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
        }
        return null;
    }

    protected Map<String, Object> getVelocityParams(ApplicationUser searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = super.getVelocityParams(searcher, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(searcher);
        boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)ctx);
        velocityParams.put("emptyValueKey", this.getEmptyValueKey());
        velocityParams.put("name", this.getI18n(searcher).getText(this.nameKey));
        velocityParams.put("userField", this.searchConstants.getFieldUrlParameter());
        velocityParams.put("userSelect", this.searchConstants.getSelectUrlParameter());
        velocityParams.put("hasPermissionToPickUsers", this.userSearcherHelper.hasUserPickingPermission(searcher));
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:autocomplete");
        if (canPerformAjaxSearch) {
            velocityParams.put("canPerformAjaxSearch", "true");
            velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        velocityParams.putAll(this.getKickassVelocityParams(fieldValuesHolder, searcher, searchContext));
        return velocityParams;
    }

    private Map<String, Object> getKickassVelocityParams(FieldValuesHolder fieldValuesHolder, ApplicationUser user, SearchContext searchContext) {
        String key = this.searchConstants.getFieldUrlParameter();
        List values = (List)fieldValuesHolder.get((Object)key);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("avatarSize", Avatar.Size.SMALL);
        params.put("hasCurrentUser", false);
        params.put("hasEmpty", false);
        params.putAll(this.addUserGroupSuggestionParams(fieldValuesHolder, user, searchContext, this.extractUserNames(values)));
        if (values != null) {
            for (UserSearchInput value : values) {
                if (value.isCurrentUser()) {
                    params.put("hasCurrentUser", true);
                    continue;
                }
                if (value.isEmpty()) {
                    params.put("hasEmpty", true);
                    continue;
                }
                if (value.isGroup()) {
                    value.setObject(this.userManager.getGroup(value.getValue()));
                    continue;
                }
                if (!value.isUser()) continue;
                value.setObject(this.userManager.getUserByName(value.getValue()));
            }
            Collections.sort(values);
        }
        params.put("values", values);
        return params;
    }

    protected Map<String, Object> addUserGroupSuggestionParams(FieldValuesHolder fieldValuesHolder, ApplicationUser user, SearchContext searchContext, List<String> selectedUsers) {
        HashMap params = Maps.newHashMap();
        this.userSearcherHelper.addUserGroupSuggestionParams(user, selectedUsers, (Map)params);
        return params;
    }

    private List<String> extractUserNames(List<UserSearchInput> values) {
        ArrayList<String> result;
        if (values != null) {
            result = Lists.newArrayListWithCapacity((int)values.size());
            for (UserSearchInput value : values) {
                if (!value.isUser()) continue;
                result.add(value.getValue());
            }
        } else {
            result = new ArrayList<String>(0);
        }
        return result;
    }
}

