/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.SearchContextRenderHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.model.querydsl.QConfigurationContext;
import com.atlassian.jira.model.querydsl.QFieldConfigScheme;
import com.atlassian.jira.model.querydsl.QFieldConfigSchemeIssueType;
import com.atlassian.jira.model.querydsl.QFieldConfiguration;
import com.atlassian.jira.model.querydsl.QOptionConfiguration;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.action.Action;

public class IssueTypeSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(IssueTypeSearchRenderer.class);
    static final int BATCH_SIZE = 990;
    private static final String ALL_STANDARD_ISSUE_TYPES_NAME = "common.filters.allstandardissuetypes";
    private static final String ALL_SUB_TASK_ISSUE_TYPES_NAME = "common.filters.allsubtaskissuetypes";
    static final String SELECTED_OPTIONS = "selectedOptions";
    static final String OPTION_CSS_CLASSES = "optionCssClasses";
    static final String SELECTED_OPTION_IDS = "selectedOptionIds";
    static final String SPECIAL_OPTIONS = "specialOptions";
    static final String STANDARD_OPTIONS = "standardOptions";
    static final String SUBTASK_OPTIONS = "subtaskOptions";
    static final String VALID_OPTION_IDS = "validOptionIds";
    static final Comparator<Option> ISSUE_TYPE_OPTION_COMPARATOR = Comparator.comparing(Option::getName, Comparator.nullsFirst(Comparator.naturalOrder()));
    private final ConstantsManager constantsManager;
    private final QueryDslAccessor queryDslAccessor;
    private final PermissionManager permissionManager;
    private final SubTaskManager subTaskManager;

    public IssueTypeSearchRenderer(ApplicationProperties applicationProperties, ConstantsManager constantsManager, QueryDslAccessor queryDslAccessor, PermissionManager permissionManager, SimpleFieldSearchConstants searchConstants, String searcherNameKey, SubTaskManager subTaskManager, VelocityTemplatingEngine templatingEngine, VelocityRequestContextFactory velocityRequestContextFactory) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searchConstants, searcherNameKey);
        this.constantsManager = constantsManager;
        this.queryDslAccessor = queryDslAccessor;
        this.permissionManager = permissionManager;
        this.subTaskManager = subTaskManager;
    }

    public void addEditParameters(FieldValuesHolder fieldValuesHolder, SearchContext searchContext, ApplicationUser user, Map<String, Object> velocityParameters) {
        new ParameterFactory(fieldValuesHolder, searchContext, user, velocityParameters).addEditParameters();
    }

    public void addViewParameters(FieldValuesHolder fieldValuesHolder, SearchContext searchContext, ApplicationUser user, Map<String, Object> velocityParameters) {
        new ParameterFactory(fieldValuesHolder, searchContext, user, velocityParameters).addViewParameters();
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addEditParameters(fieldValuesHolder, searchContext, user, velocityParameters);
        return this.renderEditTemplate("issuetype-searcher-edit.vm", velocityParameters);
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParameters = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addViewParameters(fieldValuesHolder, searchContext, user, velocityParameters);
        return this.renderViewTemplate("issuetype-searcher-view.vm", velocityParameters);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(SystemSearchConstants.forIssueType().getJqlClauseNames(), query);
    }

    @VisibleForTesting
    Set<String> getVisibleIssueTypeIds(Collection<Project> projects) {
        List<Long> fcsIds = this.selectDistinctFieldConfigSchemeIds(projects);
        HashSet<String> issueTypeIds = new HashSet<String>();
        this.executeBatched(fcsIds, this.batchedGetVisibleIssueTypeIds(issueTypeIds));
        return issueTypeIds;
    }

    private BiConsumer<DbConnection, List<Long>> batchedGetVisibleIssueTypeIds(Set<String> issueTypeIds) {
        return (db, batch) -> {
            List ids = this.selectOptions((List<Long>)batch, (SQLQuery)((SQLQuery)db.newSqlQuery().select((Expression)QOptionConfiguration.OPTION_CONFIGURATION.optionid).distinct()));
            issueTypeIds.addAll(ids);
        };
    }

    @VisibleForTesting
    Map<String, String> getVisibleIssueTypeIdsWithCssInfo(Collection<Project> projects) {
        List<Long> fcsIds = this.selectDistinctFieldConfigSchemeIds(projects);
        HashMap<String, Set<Long>> visibleIssueTypesWithCssInfo = new HashMap<String, Set<Long>>();
        this.executeBatched(fcsIds, this.batchedGetVisibleIssueTypeIdsWithCssInfo(visibleIssueTypesWithCssInfo));
        return IssueTypeSearchRenderer.toCssClassesMap(visibleIssueTypesWithCssInfo);
    }

    private BiConsumer<DbConnection, List<Long>> batchedGetVisibleIssueTypeIdsWithCssInfo(Map<String, Set<Long>> visibleIssueTypesWithCssInfo) {
        return (db, batch) -> {
            List rows = this.selectOptions((List<Long>)batch, (SQLQuery)db.newSqlQuery().select(new Expression[]{QOptionConfiguration.OPTION_CONFIGURATION.optionid, QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig}));
            rows.forEach(row -> {
                String issueTypeId = (String)row.get((Expression)QOptionConfiguration.OPTION_CONFIGURATION.optionid);
                Long fieldConfigId = (Long)row.get(QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig);
                visibleIssueTypesWithCssInfo.computeIfAbsent(issueTypeId, x -> new HashSet()).add(fieldConfigId);
            });
        };
    }

    private <T> void executeBatched(List<T> items, BiConsumer<DbConnection, List<T>> callback) {
        if (!items.isEmpty()) {
            List batches = Lists.partition(items, (int)990);
            this.queryDslAccessor.execute(db -> batches.forEach(batch -> callback.accept(db, (List)batch)));
        }
    }

    private static Map<String, String> toCssClassesMap(Map<String, Set<Long>> visibleIssueTypesWithCssInfo) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)visibleIssueTypesWithCssInfo.size());
        visibleIssueTypesWithCssInfo.forEach((issueTypeId, fieldConfigIds) -> result.put(issueTypeId, StringUtils.join((Iterable)fieldConfigIds, (char)' ')));
        return result;
    }

    @VisibleForTesting
    Map<Long, Long> selectFieldConfigSchemeIdByProjectId() {
        List rows = this.queryDslAccessor.executeQuery(db -> ((SQLQuery)((SQLQuery)db.newSqlQuery().select(new Expression[]{QConfigurationContext.CONFIGURATION_CONTEXT.project, QConfigurationContext.CONFIGURATION_CONTEXT.fieldconfigscheme}).from((Expression)QConfigurationContext.CONFIGURATION_CONTEXT)).where((com.querydsl.core.types.Predicate)QConfigurationContext.CONFIGURATION_CONTEXT.key.eq((Object)"issuetype"))).fetch());
        HashMap map = Maps.newHashMapWithExpectedSize((int)rows.size());
        rows.forEach(row -> {
            Long projectId = (Long)row.get(QConfigurationContext.CONFIGURATION_CONTEXT.project);
            Long fieldConfigSchemeId = (Long)row.get(QConfigurationContext.CONFIGURATION_CONTEXT.fieldconfigscheme);
            map.put(projectId, fieldConfigSchemeId);
        });
        return map;
    }

    @VisibleForTesting
    List<Long> selectDistinctFieldConfigSchemeIds(Collection<Project> projects) {
        if (projects.isEmpty()) {
            return ImmutableList.of();
        }
        Map<Long, Long> fcsIdByProjectId = this.selectFieldConfigSchemeIdByProjectId();
        Long defaultFcsId = fcsIdByProjectId.get(null);
        return (List)projects.stream().map(project -> fcsIdByProjectId.getOrDefault(project.getId(), defaultFcsId)).filter(Objects::nonNull).distinct().sorted().collect(CollectorsUtil.toNewArrayListWithSizeOf(projects));
    }

    @VisibleForTesting
    <U> List<U> selectOptions(List<Long> fieldConfigSchemeIds, SQLQuery<U> selectColumnStub) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)selectColumnStub.from((Expression)QOptionConfiguration.OPTION_CONFIGURATION)).innerJoin((EntityPath)QFieldConfiguration.FIELD_CONFIGURATION)).on((com.querydsl.core.types.Predicate)QFieldConfiguration.FIELD_CONFIGURATION.id.eq(QOptionConfiguration.OPTION_CONFIGURATION.fieldconfig))).innerJoin((EntityPath)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE)).on((com.querydsl.core.types.Predicate)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE.fieldconfiguration.eq(QFieldConfiguration.FIELD_CONFIGURATION.id))).innerJoin((EntityPath)QFieldConfigScheme.FIELD_CONFIG_SCHEME)).on((com.querydsl.core.types.Predicate)QFieldConfigScheme.FIELD_CONFIG_SCHEME.id.eq(QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE.fieldconfigscheme))).where((com.querydsl.core.types.Predicate)QFieldConfigScheme.FIELD_CONFIG_SCHEME.id.in(fieldConfigSchemeIds))).fetch();
    }

    class ParameterFactory {
        private final FieldValuesHolder fieldValuesHolder;
        private final Collection<Project> projects;
        private final Map<String, Object> velocityParameters;
        private final I18nHelper i18n;
        private final Map<String, Option> allOptions;

        ParameterFactory(FieldValuesHolder fieldValuesHolder, SearchContext searchContext, ApplicationUser user, Map<String, Object> velocityParameters) {
            this.fieldValuesHolder = fieldValuesHolder;
            this.velocityParameters = velocityParameters;
            this.i18n = IssueTypeSearchRenderer.this.getI18n(user);
            this.allOptions = this.getAllOptions();
            Collection browseableProjects = IssueTypeSearchRenderer.this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
            this.projects = this.applyContextFilter(browseableProjects, searchContext);
            SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParameters);
        }

        private Collection<Project> applyContextFilter(Collection<Project> allProjects, SearchContext searchContext) {
            if (searchContext.isForAnyProjects()) {
                return new ArrayList<Project>(allProjects);
            }
            HashSet projectIds = new HashSet(searchContext.getProjectIds());
            return (Collection)allProjects.stream().filter(project -> projectIds.contains(project.getId())).collect(CollectorsUtil.toNewArrayListWithSizeOf(projectIds));
        }

        private Map<String, Option> getAllOptions() {
            Collection allIssueTypes = IssueTypeSearchRenderer.this.constantsManager.getAllIssueTypeObjects();
            HashMap options = Maps.newHashMapWithExpectedSize((int)(allIssueTypes.size() + 2));
            options.put("-2", this.allStandardTypes());
            options.put("-3", this.allSubtaskTypes());
            allIssueTypes.stream().map(IssueConstantOption::new).forEach(option -> options.put(option.getId(), option));
            return options;
        }

        private Collection<String> getSelectedOptionIds() {
            Collection selected = (Collection)this.fieldValuesHolder.get((Object)"type");
            return selected != null ? selected : ImmutableList.of();
        }

        private boolean subTasksAreDisabled() {
            return !IssueTypeSearchRenderer.this.subTaskManager.isSubTasksEnabled();
        }

        void addViewParameters() {
            List<Option> selectedOptions = this.optionList(this.getSelectedOptionIds());
            Set<String> validOptionIds = IssueTypeSearchRenderer.this.getVisibleIssueTypeIds(this.projects);
            this.applySubtaskAndSpecialOptionValidity(validOptionIds);
            this.velocityParameters.put(IssueTypeSearchRenderer.SELECTED_OPTIONS, selectedOptions);
            this.velocityParameters.put(IssueTypeSearchRenderer.VALID_OPTION_IDS, validOptionIds);
        }

        private void applySubtaskAndSpecialOptionValidity(Set<String> validOptionIds) {
            if (this.subTasksAreDisabled()) {
                validOptionIds.removeIf(this::isSubTask);
            } else if (this.hasAtLeastOneSubTask(validOptionIds)) {
                validOptionIds.add("-3");
            }
            validOptionIds.add("-2");
        }

        private boolean isSubTask(String optionId) {
            Option option = this.allOptions.get(optionId);
            return option != null && IssueConstantOption.isSubTask(option);
        }

        private boolean hasAtLeastOneSubTask(Collection<String> optionIds) {
            return this.optionStream(optionIds).anyMatch(IssueConstantOption::isSubTask);
        }

        void addEditParameters() {
            Map<String, Option> selectedOptions = this.optionMap(this.getSelectedOptionIds());
            Map<String, String> cssInfo = IssueTypeSearchRenderer.this.getVisibleIssueTypeIdsWithCssInfo(this.projects);
            HashSet<String> validOptionIds = new HashSet<String>(cssInfo.keySet());
            this.applySubtaskAndSpecialOptionValidity(validOptionIds);
            Predicate<String> isVisible = optionId -> validOptionIds.contains(optionId) || selectedOptions.containsKey(optionId);
            OptionGroups groups = new OptionGroups(this.allOptions, isVisible);
            this.velocityParameters.put(IssueTypeSearchRenderer.SELECTED_OPTION_IDS, selectedOptions.keySet());
            this.velocityParameters.put(IssueTypeSearchRenderer.OPTION_CSS_CLASSES, cssInfo);
            this.velocityParameters.put(IssueTypeSearchRenderer.VALID_OPTION_IDS, validOptionIds);
            this.velocityParameters.put(IssueTypeSearchRenderer.SPECIAL_OPTIONS, groups.special);
            this.velocityParameters.put(IssueTypeSearchRenderer.STANDARD_OPTIONS, groups.standard);
            this.velocityParameters.put(IssueTypeSearchRenderer.SUBTASK_OPTIONS, groups.subtasks);
        }

        private Stream<Option> optionStream(Collection<String> optionIds) {
            return optionIds.stream().map(optionId -> {
                Option option = this.allOptions.get(optionId);
                if (option == null) {
                    LOG.debug("Ignoring invalid option ID '{}'", optionId);
                }
                return option;
            }).filter(Objects::nonNull);
        }

        private List<Option> optionList(Collection<String> optionIds) {
            return (List)this.optionStream(optionIds).collect(CollectorsUtil.toNewArrayListWithSizeOf(optionIds));
        }

        private Map<String, Option> optionMap(Collection<String> optionIds) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)optionIds.size());
            this.optionStream(optionIds).forEach(option -> map.put(option.getId(), option));
            return map;
        }

        private Option allStandardTypes() {
            return new TextOption("-2", this.i18n.getText(IssueTypeSearchRenderer.ALL_STANDARD_ISSUE_TYPES_NAME));
        }

        private Option allSubtaskTypes() {
            return new TextOption("-3", this.i18n.getText(IssueTypeSearchRenderer.ALL_SUB_TASK_ISSUE_TYPES_NAME));
        }
    }

    static class OptionGroups {
        final List<Option> special = new ArrayList<Option>(2);
        final List<Option> standard = new LinkedList<Option>();
        final List<Option> subtasks = new LinkedList<Option>();

        OptionGroups(Map<String, Option> allOptions, Predicate<String> isVisible) {
            Predicate<Option> isVisibleAndNotSpecial = option -> {
                String optionId = option.getId();
                return isVisible.test(optionId) && !OptionGroups.isSpecial(optionId);
            };
            allOptions.values().stream().filter(isVisibleAndNotSpecial).forEach(option -> {
                if (IssueConstantOption.isSubTask(option)) {
                    this.subtasks.add((Option)option);
                } else {
                    this.standard.add((Option)option);
                }
            });
            this.special.add(allOptions.get("-2"));
            if (isVisible.test("-3")) {
                this.special.add(allOptions.get("-3"));
            }
            Collections.sort(this.standard, ISSUE_TYPE_OPTION_COMPARATOR);
            Collections.sort(this.subtasks, ISSUE_TYPE_OPTION_COMPARATOR);
        }

        private static boolean isSpecial(String optionId) {
            return "-2".equals(optionId) || "-3".equals(optionId);
        }
    }
}

