/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import webwork.action.Action;

public class ProjectSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    public static final int MAX_PROJECTS_BEFORE_RECENT = 10;
    public static final int MAX_RECENT_PROJECTS_TO_SHOW = 5;
    private final ProjectManager projectManager;
    private final InternalProjectPermissionHelper projectPermissionHelper;

    public ProjectSearchRenderer(ProjectManager projectManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, String searcherNameKey, InternalProjectPermissionHelper projectPermissionHelper) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, SystemSearchConstants.forProject(), searcherNameKey);
        this.projectManager = projectManager;
        this.projectPermissionHelper = projectPermissionHelper;
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        this.addParameters(user, fieldValuesHolder, false, velocityParams);
        return this.renderEditTemplate("project-searcher-edit.vm", velocityParams);
    }

    public void addParameters(ApplicationUser user, FieldValuesHolder fieldValuesHolder, boolean noCurrentSearchRequest, Map<String, Object> velocityParams) {
        Collection<Project> allVisibleProjects = this.getVisibleProjects(user);
        Set<String> selectedProjectIds = this.getSelectedProjectIds(allVisibleProjects, fieldValuesHolder, noCurrentSearchRequest);
        Set<Project> selectedProjects = this.getSelectedProjectsForIds(allVisibleProjects, selectedProjectIds);
        velocityParams.put("allVisibleProjects", allVisibleProjects);
        velocityParams.put("selectedProjectsIds", selectedProjectIds);
        velocityParams.put("selectedProjects", selectedProjects);
        if (allVisibleProjects.size() > 10) {
            velocityParams.put("recentProjects", this.getRecentProjects(user));
        }
    }

    private Set<String> getSelectedProjectIds(Collection<Project> allProjects, FieldValuesHolder fieldValuesHolder, boolean noCurrentSearchRequest) {
        String projectUrlParameter = SystemSearchConstants.forProject().getUrlParameter();
        List selectedProjectIds = noCurrentSearchRequest && allProjects.size() == 1 && !fieldValuesHolder.containsKey((Object)projectUrlParameter) ? allProjects.stream().map(Project::getId).map(String::valueOf).collect(Collectors.toList()) : (List)fieldValuesHolder.get((Object)projectUrlParameter);
        if (selectedProjectIds == null) {
            return Collections.emptySet();
        }
        if (selectedProjectIds.size() == 1 && ((String)selectedProjectIds.get(0)).equals("-1")) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(selectedProjectIds);
    }

    private Set<Project> getSelectedProjectsForIds(Collection<Project> allProjects, Set<String> projectIds) {
        return allProjects.stream().filter(project -> projectIds.contains(String.valueOf(project.getId()))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        List idsAsStrings = (List)fieldValuesHolder.get((Object)SystemSearchConstants.forProject().getUrlParameter());
        List projectIds = ParameterUtils.makeListLong((List)idsAsStrings);
        List rawProjects = this.projectManager.convertToOptionalProjectObjects((Collection)projectIds);
        ArrayList<Project> projects = new ArrayList<Project>(rawProjects.size());
        ArrayList<Long> filteredOutProjectIds = new ArrayList<Long>(rawProjects.size());
        for (Pair projectPair : rawProjects) {
            Long projectId = (Long)projectPair.first();
            Optional project = (Optional)projectPair.second();
            if (project.isPresent() && this.projectPermissionHelper.canUserBrowseProject((Project)project.get(), user)) {
                projects.add((Project)project.get());
                continue;
            }
            filteredOutProjectIds.add(projectId);
        }
        Collections.sort(filteredOutProjectIds);
        velocityParams.put("filteredOutProjectIds", filteredOutProjectIds);
        velocityParams.put("selectedProjects", projects);
        return this.renderViewTemplate("project-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(SystemSearchConstants.forProject().getJqlClauseNames(), query);
    }

    public Collection<Project> getRecentProjects(ApplicationUser searcher) {
        return this.projectPermissionHelper.getBrowsableProjectHistory(searcher).stream().limit(5L).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Collection<Project> getVisibleProjects(ApplicationUser searcher) {
        return this.projectPermissionHelper.getBrowsableProjects(searcher);
    }
}

