/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.util.IssueIdsIssueIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class AssignIssueSecuritySchemeCommand
implements Callable<AssignSecurityLevelResult>,
ProvidesTaskProgress {
    private final Project project;
    private final QueryDslAccessor queryDslAccessor;
    private final Long newSchemeId;
    private final Map<Long, Long> oldToNewLevelMapping;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueIndexingService issueIndexingService;
    private final IssueManager issueManager;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private volatile TaskProgressSink taskProgressSink;

    public AssignIssueSecuritySchemeCommand(Project project, Long newSchemeId, Map<Long, Long> oldToNewLevelMapping, QueryDslAccessor queryDslAccessor, IssueSecuritySchemeManager issueSecuritySchemeManager, IssueIndexingService issueIndexingService, IssueManager issueManager, Logger log, I18nHelper i18nHelper) {
        this.newSchemeId = newSchemeId;
        this.issueSecurityLevelManager = (IssueSecurityLevelManager)ComponentAccessor.getComponent(IssueSecurityLevelManager.class);
        this.oldToNewLevelMapping = ImmutableMap.copyOf(oldToNewLevelMapping);
        this.project = project;
        this.queryDslAccessor = queryDslAccessor;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueIndexingService = issueIndexingService;
        this.issueManager = issueManager;
        this.log = log;
        this.i18nHelper = i18nHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssignSecurityLevelResult call() {
        Map<Long, Long> completeIssueMapping = this.makeCompleteIssueMapping();
        int issuesToModify = this.countIssuesToModify(completeIssueMapping);
        Context context = Contexts.builder().sized((Sized)new FixedSized(issuesToModify * 101 / 100)).progressSubTask(this.taskProgressSink, this.i18nHelper, "admin.iss.associate.security.scheme.level").build();
        try {
            this.changeLevels(context, this.project.getId(), completeIssueMapping);
            this.associateProjectToScheme(this.project, this.newSchemeId);
        }
        catch (IndexException | RuntimeException e) {
            this.log.error(e.getMessage(), e);
            AssignSecurityLevelResult assignSecurityLevelResult = new AssignSecurityLevelResult((ErrorCollection)new SimpleErrorCollection(e.getMessage(), ErrorCollection.Reason.SERVER_ERROR));
            return assignSecurityLevelResult;
        }
        finally {
            this.issueSecurityLevelManager.clearProjectLevels(this.project);
            for (int i = 0; i < context.getNumberOfTasksToCompletion(); ++i) {
                context.start(null).complete();
            }
        }
        return new AssignSecurityLevelResult();
    }

    private int countIssuesToModify(Map<Long, Long> securityLevelMapping) {
        int totalSize = 0;
        for (Map.Entry<Long, Long> mapping : securityLevelMapping.entrySet()) {
            Long newLevel;
            Long oldLevel = mapping.getKey();
            if (oldLevel.equals(newLevel = mapping.getValue())) continue;
            Long realOldLevelId = this.correctLevel(oldLevel);
            totalSize = (int)((long)totalSize + this.issueSecurityLevelManager.getIssueCount(realOldLevelId, this.project.getId()));
        }
        return totalSize;
    }

    private void changeLevels(Context taskContext, Long projectId, Map<Long, Long> oldToNewLevelMapping) throws IndexException {
        for (Map.Entry<Long, Long> mapping : oldToNewLevelMapping.entrySet()) {
            Long newLevel;
            Long oldLevel = mapping.getKey();
            if (oldLevel.equals(newLevel = mapping.getValue())) continue;
            IssueSecurityLevel issueSecurityLevel = newLevel == null ? null : this.issueSecurityLevelManager.getSecurityLevel(newLevel.longValue());
            taskContext.setName(issueSecurityLevel != null ? issueSecurityLevel.getName() : this.i18nHelper.getText("common.words.none"));
            this.mapIssueSecurity(taskContext, projectId, oldLevel, newLevel);
        }
    }

    private void mapIssueSecurity(Context taskContext, Long projectId, Long oldLevel, Long newLevel) throws IndexException {
        List matchingIssues;
        long batchSize = 100L;
        Long realOldLevelId = this.correctLevel(oldLevel);
        Long realNewLevelId = this.correctLevel(newLevel);
        while (!(matchingIssues = this.queryDslAccessor.executeQuery(dbConnection -> {
            BooleanExpression issueSecLevelPredicate = realOldLevelId == null ? QIssue.ISSUE.security.isNull() : QIssue.ISSUE.security.eq((Object)realOldLevelId);
            List issues = ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QIssue.ISSUE.id).from((Expression)QIssue.ISSUE)).where((Predicate)issueSecLevelPredicate.and((Predicate)QIssue.ISSUE.project.eq((Object)projectId)))).limit(100L)).fetch();
            if (!issues.isEmpty()) {
                Context.Task task = taskContext.start(issues.get(0));
                try {
                    if (!issues.isEmpty()) {
                        dbConnection.update((RelationalPath<?>)QIssue.ISSUE).set(QIssue.ISSUE.security, (Object)realNewLevelId).where((Predicate)QIssue.ISSUE.id.in((Collection)issues)).execute();
                    }
                }
                finally {
                    task.complete();
                }
            }
            return issues;
        })).isEmpty()) {
            this.issueIndexingService.reIndexIssues((IssuesIterable)new IssueIdsIssueIterable(matchingIssues, this.issueManager), taskContext);
        }
    }

    private Long correctLevel(Long level) {
        if (level == null) {
            return null;
        }
        IssueSecurityLevel issueSecurity = this.issueSecurityLevelManager.getSecurityLevel(level.longValue());
        return issueSecurity == null ? null : issueSecurity.getId();
    }

    private void associateProjectToScheme(Project project, Long newSchemeId) {
        this.issueSecuritySchemeManager.removeSchemesFromProject(project);
        if (this.newSchemeId != null) {
            Scheme scheme = this.issueSecuritySchemeManager.getSchemeObject(newSchemeId);
            if (scheme == null) {
                throw new RuntimeException("Issue Security Scheme '" + newSchemeId + "' not found");
            }
            this.issueSecuritySchemeManager.addSchemeToProject(project, scheme);
        }
    }

    private Map<Long, Long> makeCompleteIssueMapping() {
        HashMap<Long, Long> completeOldToNewLevelMapping = new HashMap<Long, Long>(this.oldToNewLevelMapping);
        Long oldSchemeId = this.issueSecuritySchemeManager.getSchemeIdFor(this.project);
        if (oldSchemeId != null) {
            this.issueSecurityLevelManager.getIssueSecurityLevels(oldSchemeId.longValue()).stream().map(IssueSecurityLevel::getId).filter(id -> !this.oldToNewLevelMapping.containsKey(id)).forEach(issueSecurityLevelKey -> completeOldToNewLevelMapping.put((Long)issueSecurityLevelKey, (Long)null));
        }
        return completeOldToNewLevelMapping;
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    public static final class AssignSecurityLevelResult
    implements Serializable {
        private final SimpleErrorCollection errorCollection;

        public AssignSecurityLevelResult(ErrorCollection errorCollection) {
            Assertions.notNull((String)"errorCollection", (Object)errorCollection);
            this.errorCollection = new SimpleErrorCollection(errorCollection);
        }

        public AssignSecurityLevelResult() {
            this.errorCollection = new SimpleErrorCollection();
        }

        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public boolean isSuccessful() {
            return !this.errorCollection.hasAnyErrors();
        }
    }
}

