/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeDeletedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelImpl;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class IssueSecurityLevelManagerImpl
implements IssueSecurityLevelManager {
    protected final Logger log = Logger.getLogger(IssueSecurityLevelManagerImpl.class);
    @VisibleForTesting
    static final String PROJECT_AND_USER_TO_SECURITY_LEVEL_CACHE_MAX_SIZE_PROPERTY_KEY = "jira.project.and.user.to.security.level.cache.max.size";
    @VisibleForTesting
    static final int DEFAULT_PROJECT_AND_USER_TO_SECURITY_LEVEL_CACHE_MAX_SIZE = 300000;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SecurityTypeManager securityTypeManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final EntityEngine entityEngine;
    private final QueryDslAccessor queryDslAccessor;
    private final Cache<CacheKey, List<GenericValue>> projectAndUserToSecurityLevelCache;
    private final CachedReference<Map<Long, IssueSecurityLevel>> idToSecurityLevelCache;

    public IssueSecurityLevelManagerImpl(IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager securityTypeManager, ProjectManager projectManager, PermissionManager permissionManager, EntityEngine entityEngine, CacheManager cacheManager, QueryDslAccessor queryDslAccessor, ApplicationProperties applicationProperties) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.securityTypeManager = securityTypeManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.entityEngine = entityEngine;
        this.queryDslAccessor = queryDslAccessor;
        this.projectAndUserToSecurityLevelCache = cacheManager.getCache(this.getClass().getName() + ".projectAndUserToSecurityLevelCache", null, this.getProjectAndUserToSecurityLevelCacheSettings(applicationProperties));
        this.idToSecurityLevelCache = cacheManager.getCachedReference(this.getClass().getName() + ".idToSecurityLevelCache", this::loadSecurityLevelById);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearUsersLevels();
        this.idToSecurityLevelCache.reset();
    }

    @EventListener
    public void onEvent(IssueSecuritySchemeDeletedEvent event) {
        this.clearUsersLevels();
        this.idToSecurityLevelCache.reset();
    }

    public List<GenericValue> getSchemeIssueSecurityLevels(Long schemeId) {
        return this.internSecurityLevelFields(ComponentAccessor.getOfBizDelegator().findByAnd("SchemeIssueSecurityLevels", (Map)FieldMap.build((String)"scheme", (Object)schemeId), (List)ImmutableList.of((Object)"name")));
    }

    public List<IssueSecurityLevel> getIssueSecurityLevels(long schemeId) {
        return this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).whereEqual("scheme", schemeId).orderBy("name");
    }

    @Nullable
    public GenericValue getIssueSecurity(@Nonnull Long id) {
        IssueSecurityLevel securityLevel = this.getSecurityLevel(id);
        return securityLevel == null ? null : Entity.ISSUE_SECURITY_LEVEL.genericValueFrom(securityLevel);
    }

    public IssueSecurityLevel getSecurityLevel(long id) {
        return (IssueSecurityLevel)((Map)this.idToSecurityLevelCache.get()).get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssueSecurityLevel createIssueSecurityLevel(long schemeId, String name, String description) {
        try {
            IssueSecurityLevelImpl issueSecurityLevel = new IssueSecurityLevelImpl(null, name, description, schemeId);
            IssueSecurityLevelImpl issueSecurityLevelImpl = issueSecurityLevel = (IssueSecurityLevel)this.entityEngine.createValue(Entity.ISSUE_SECURITY_LEVEL, issueSecurityLevel);
            return issueSecurityLevelImpl;
        }
        finally {
            this.idToSecurityLevelCache.reset();
        }
    }

    public IssueSecurityLevel getSecurityLevelByNameAndSchema(String securityLevelName, Long schemaId) {
        return (IssueSecurityLevel)this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).whereEqual("name", securityLevelName).andEqual("scheme", schemaId).singleValue();
    }

    public IssueSecurityLevel createIssueSecurityLevel(IssueSecurityLevel level) {
        return this.createIssueSecurityLevel(level.getSchemeId(), level.getName(), level.getDescription());
    }

    public IssueSecurityLevel updateIssueSecurityLevel(IssueSecurityLevel issueSecurityLevel) {
        try {
            this.entityEngine.updateValue(Entity.ISSUE_SECURITY_LEVEL, issueSecurityLevel);
            IssueSecurityLevel issueSecurityLevel2 = issueSecurityLevel;
            return issueSecurityLevel2;
        }
        finally {
            this.idToSecurityLevelCache.reset();
        }
    }

    public boolean schemeIssueSecurityExists(Long id) {
        return this.getSecurityLevel(id) != null;
    }

    public String getIssueSecurityName(Long id) {
        IssueSecurityLevel issueSecurity = this.getSecurityLevel(id);
        return issueSecurity == null ? null : issueSecurity.getName();
    }

    public String getIssueSecurityDescription(Long id) {
        GenericValue issueSecurity = this.getIssueSecurity(id);
        return issueSecurity == null ? null : issueSecurity.getString("description");
    }

    public List<GenericValue> getUsersSecurityLevels(GenericValue entity, @Nullable ApplicationUser user) throws GenericEntityException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        if (entity.getEntityName().equals("Project")) {
            Long projectId = entity.getLong("id");
            CacheKey cacheKey = new CacheKey(projectId, user);
            return (List)this.projectAndUserToSecurityLevelCache.get((Object)cacheKey, () -> this.getSecurityLevels(user, this.projectManager.getProjectObj(cacheKey.projectId)));
        }
        if (entity.getEntityName().equals("Issue")) {
            MutableIssue issue = ComponentAccessor.getIssueFactory().getIssue(entity);
            IssuePermissionChecker permissionChecker = new IssuePermissionChecker((Issue)issue, user);
            return this.getUsersSecurityLevels(user, issue.getProjectObject(), permissionChecker);
        }
        throw new IllegalArgumentException("Unsupported entity: " + entity.getEntityName());
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Issue issue, ApplicationUser user) {
        IssuePermissionChecker permissionChecker = new IssuePermissionChecker(issue, user);
        List<GenericValue> levels = this.getUsersSecurityLevels(user, issue.getProjectObject(), permissionChecker);
        return Entity.ISSUE_SECURITY_LEVEL.buildList(levels);
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Project project, ApplicationUser user) {
        CacheKey cacheKey = new CacheKey(project.getId(), user);
        List genericValues = (List)this.projectAndUserToSecurityLevelCache.get((Object)cacheKey, () -> this.getSecurityLevels(user, project));
        return Entity.ISSUE_SECURITY_LEVEL.buildList(genericValues);
    }

    private List<GenericValue> getUsersSecurityLevels(@Nullable ApplicationUser user, Project project, PermissionChecker permissionChecker) {
        Scheme scheme = this.issueSecuritySchemeManager.getSchemeFor(project);
        if (scheme == null || user == null) {
            return ImmutableList.of();
        }
        Collection securities = scheme.getEntities();
        Map types = this.securityTypeManager.getTypes();
        HashSet processedLevels = new HashSet();
        return securities.stream().filter(se -> !processedLevels.contains(se.getEntityTypeId())).filter(se -> {
            SchemeType type = (SchemeType)types.get(se.getType());
            return type != null && permissionChecker.hasPermission((SchemeEntity)se, type);
        }).map(se -> this.getIssueSecurityLevel((Long)se.getEntityTypeId())).filter(Objects::nonNull).peek(level -> processedLevels.add(level.getLong("id"))).sorted(Comparator.comparing(level -> level.getString("name"), Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    public Collection<GenericValue> getAllUsersSecurityLevels(ApplicationUser user) throws GenericEntityException {
        return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user).stream().map(project -> {
            CacheKey cacheKey = new CacheKey(project.getId(), user);
            return (List)this.projectAndUserToSecurityLevelCache.get((Object)cacheKey, () -> this.getSecurityLevels(user, (Project)project));
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Nonnull
    public Collection<IssueSecurityLevel> getAllSecurityLevelsForUser(ApplicationUser user) {
        return this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user).stream().map(p -> this.getUsersSecurityLevels((Project)p, user)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Collection<GenericValue> getAllSecurityLevels() throws GenericEntityException {
        List schemes = this.issueSecuritySchemeManager.getSchemes();
        LinkedHashSet<GenericValue> allLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getSchemeIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<IssueSecurityLevel> getAllIssueSecurityLevels() {
        List schemes;
        try {
            schemes = this.issueSecuritySchemeManager.getSchemes();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        LinkedHashSet<IssueSecurityLevel> allLevels = new LinkedHashSet<IssueSecurityLevel>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<GenericValue> getUsersSecurityLevelsByName(ApplicationUser user, String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllUsersSecurityLevels(user));
    }

    public Collection<IssueSecurityLevel> getSecurityLevelsForUserByName(ApplicationUser user, String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllSecurityLevelsForUser(user));
    }

    public Collection<GenericValue> getSecurityLevelsByName(String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllSecurityLevels());
    }

    public Collection<IssueSecurityLevel> getIssueSecurityLevelsByName(String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllIssueSecurityLevels());
    }

    private Collection<GenericValue> _getSecurityLevelsByName(String securityLevelName, Collection<GenericValue> securityLevels) throws GenericEntityException {
        Predicate namePredicate = input -> securityLevelName.equalsIgnoreCase(input.getString("name"));
        LinkedHashSet<GenericValue> filteredSecurityLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue levelGV : Iterables.filter(securityLevels, (Predicate)namePredicate)) {
            filteredSecurityLevels.add(levelGV);
        }
        return filteredSecurityLevels;
    }

    private List<IssueSecurityLevel> filterSecurityLevelsByName(String securityLevelName, Collection<IssueSecurityLevel> securityLevels) {
        LinkedList<IssueSecurityLevel> filteredSecurityLevels = new LinkedList<IssueSecurityLevel>();
        for (IssueSecurityLevel issueSecurityLevel : securityLevels) {
            if (!issueSecurityLevel.getName().equals(securityLevelName)) continue;
            filteredSecurityLevels.add(issueSecurityLevel);
        }
        return filteredSecurityLevels;
    }

    public Long getSchemeDefaultSecurityLevel(GenericValue project) throws GenericEntityException {
        if (project != null) {
            GenericValue scheme = EntityUtil.getOnly((List)this.issueSecuritySchemeManager.getSchemes(project));
            return scheme == null ? null : scheme.getLong("defaultlevel");
        }
        return null;
    }

    public Long getDefaultSecurityLevel(Project project) {
        try {
            return this.getSchemeDefaultSecurityLevel(project != null ? project.getGenericValue() : null);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue getIssueSecurityLevel(Long id) {
        return id == null ? null : this.getIssueSecurity(id);
    }

    public void deleteSecurityLevel(Long levelId) {
        try {
            this.entityEngine.delete(Delete.from("SchemeIssueSecurities").whereEqual("security", levelId));
            this.entityEngine.delete(Delete.from(Entity.ISSUE_SECURITY_LEVEL).whereIdEquals(levelId));
        }
        finally {
            this.idToSecurityLevelCache.reset();
            this.projectAndUserToSecurityLevelCache.removeAll();
        }
    }

    public void clearUsersLevels() {
        this.projectAndUserToSecurityLevelCache.removeAll();
    }

    public void clearProjectLevels(Project project) {
        this.projectAndUserToSecurityLevelCache.removeAll();
    }

    private List<GenericValue> internSecurityLevelFields(List<GenericValue> list) {
        if (list != null) {
            for (GenericValue value : list) {
                this.internSecurityLevelFields(value);
            }
        }
        return list;
    }

    private GenericValue internSecurityLevelFields(GenericValue value) {
        EntityUtils.internStringFieldValue(value, "name");
        EntityUtils.internStringFieldValue(value, "description");
        return value;
    }

    public Long getIssueCount(@Nullable Long issueSecurityLevelId, @Nonnull Long projectId) {
        return this.queryDslAccessor.executeQuery(dbConnection -> {
            BooleanExpression issueSecLevelPredicate = issueSecurityLevelId == null ? QIssue.ISSUE.security.isNull() : QIssue.ISSUE.security.eq((Object)issueSecurityLevelId);
            return ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QIssue.ISSUE)).where((com.querydsl.core.types.Predicate)issueSecLevelPredicate.and((com.querydsl.core.types.Predicate)QIssue.ISSUE.project.eq((Object)projectId)))).fetchCount();
        });
    }

    private List<GenericValue> getSecurityLevels(@Nullable ApplicationUser user, Project project) {
        ProjectPermissionChecker permissionChecker = new ProjectPermissionChecker(project, user);
        List<GenericValue> levels = this.getUsersSecurityLevels(user, project, permissionChecker);
        return ImmutableList.copyOf(levels);
    }

    @Nonnull
    private CacheSettings getProjectAndUserToSecurityLevelCacheSettings(ApplicationProperties applicationProperties) {
        CacheSettingsBuilder cacheSettingsBuilder = new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES);
        int maxCacheSize = PropertiesUtil.getIntProperty((ApplicationProperties)applicationProperties, (String)PROJECT_AND_USER_TO_SECURITY_LEVEL_CACHE_MAX_SIZE_PROPERTY_KEY, (int)300000);
        if (maxCacheSize > 0) {
            cacheSettingsBuilder.maxEntries(maxCacheSize);
        }
        return cacheSettingsBuilder.build();
    }

    private Map<Long, IssueSecurityLevel> loadSecurityLevelById() {
        return this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).findAll().list().stream().collect(Collectors.toMap(IssueSecurityLevel::getId, Function.identity()));
    }

    static class CacheKey
    implements Serializable {
        final Long projectId;
        final String userKey;
        private static final long serialVersionUID = -3169687458203715354L;

        CacheKey(Long projectId, @Nullable ApplicationUser user) {
            this.projectId = (Long)Assertions.notNull((String)"projectId", (Object)projectId);
            this.userKey = user != null ? user.getKey() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.projectId.longValue() == other.projectId.longValue() && (this.userKey == null ? other.userKey == null : this.userKey.equals(other.userKey));
        }

        public int hashCode() {
            return this.projectId.hashCode() * 31 + (this.userKey != null ? this.userKey.hashCode() : 0);
        }

        public String toString() {
            return "CacheKey[projectId=" + this.projectId + ", user=" + (this.userKey != null ? this.userKey : "(null)") + "]";
        }
    }

    private static class IssuePermissionChecker
    implements PermissionChecker {
        private final Issue issue;
        private final ApplicationUser user;

        private IssuePermissionChecker(Issue issue, ApplicationUser user) {
            this.issue = issue;
            this.user = user;
        }

        @Override
        public boolean hasPermission(SchemeEntity security, SchemeType type) {
            return this.user != null ? type.hasPermission(this.issue, security.getParameter(), this.user, false) : type.hasPermission(this.issue, security.getParameter());
        }
    }

    static interface PermissionChecker {
        public boolean hasPermission(SchemeEntity var1, SchemeType var2);
    }

    private static class ProjectPermissionChecker
    implements PermissionChecker {
        private final Project project;
        private final ApplicationUser user;

        private ProjectPermissionChecker(Project project, @Nullable ApplicationUser user) {
            this.project = project;
            this.user = user;
        }

        @Override
        public boolean hasPermission(SchemeEntity security, SchemeType type) {
            return this.user != null ? type.hasPermission(this.project, security.getParameter(), this.user, false) : type.hasPermission(this.project, security.getParameter());
        }
    }
}

