/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.statistics.util.FieldDocumentHitCollector;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;

public class FieldHitCollector
extends FieldDocumentHitCollector {
    private List<String> values = new ArrayList<String>();
    private final String fieldName;
    private final Set<String> fieldsToLoad;

    public FieldHitCollector(String fieldName) {
        this.fieldName = Assertions.notBlank((String)"fieldName", (String)fieldName);
        this.fieldsToLoad = ImmutableSet.of((Object)fieldName);
    }

    public void collect(Document d) {
        this.values.add(d.get(this.getFieldName()));
    }

    public List<String> getValues() {
        return this.values;
    }

    private String getFieldName() {
        return this.fieldName;
    }

    protected Set<String> getFieldsToLoad() {
        return this.fieldsToLoad;
    }
}

