/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.status.category;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.util.I18nHelper;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class StatusCategoryImpl
implements StatusCategory {
    private static final List<StatusCategory> CATEGORIES = ImmutableList.of((Object)new StatusCategoryImpl(1L, "undefined", "No Category", (List<String>)ImmutableList.of(), "default", 1L), (Object)new StatusCategoryImpl(2L, "new", "New", (List<String>)ImmutableList.of((Object)"To Do"), "default", 2L), (Object)new StatusCategoryImpl(4L, "indeterminate", "In Progress", (List<String>)ImmutableList.of(), "inprogress", 3L), (Object)new StatusCategoryImpl(3L, "done", "Complete", (List<String>)ImmutableList.of((Object)"Done"), "success", 4L));
    private static final Map<String, StatusCategory> CATEGORIES_BY_KEY;
    private static final Map<Long, StatusCategory> CATEGORIES_BY_ID;
    private static final Map<String, StatusCategory> CATEGORIES_BY_NAME_ALIAS;
    private final Long id;
    private final String key;
    private final String name;
    private final String colorName;
    private final Long sequence;
    private final List<String> aliases;

    private StatusCategoryImpl(Long id, String key, String name, List<String> aliases, String colorName, Long sequence) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.colorName = colorName;
        this.sequence = sequence;
        this.aliases = aliases;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getPrimaryAlias() {
        return !this.aliases.isEmpty() ? this.aliases.get(0) : this.name;
    }

    public String getTranslatedName() {
        return this.getTranslatedName(ComponentAccessor.getJiraAuthenticationContext().getI18nHelper());
    }

    public String getTranslatedName(String locale) {
        return this.getTranslatedName(ComponentAccessor.getI18nHelperFactory().getInstance(new Locale(locale)));
    }

    public String getTranslatedName(I18nHelper i18n) {
        return i18n.getText("common.statuscategory." + this.getKey());
    }

    public String getColorName() {
        return this.colorName;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public int compareTo(@Nonnull StatusCategory o) {
        return this.sequence.compareTo(o.getSequence());
    }

    public boolean equals(Object o) {
        return o instanceof StatusCategoryImpl && this.id.equals(((StatusCategoryImpl)o).getId());
    }

    public static StatusCategory findById(Long id) {
        return CATEGORIES_BY_ID.get(id);
    }

    public static StatusCategory findByKey(String key) {
        return CATEGORIES_BY_KEY.get(key);
    }

    public static StatusCategory findByName(String key) {
        return CATEGORIES_BY_NAME_ALIAS.get(key);
    }

    private static Map<String, StatusCategory> getAllAliases() {
        HashMap aliases = Maps.newHashMap();
        for (StatusCategory category : CATEGORIES) {
            aliases.putAll(StatusCategoryImpl.getAliasMap(category));
        }
        return ImmutableMap.copyOf((Map)aliases);
    }

    private static Map<String, StatusCategory> getAliasMap(StatusCategory category) {
        HashMap map = Maps.newHashMap();
        for (String nameOrAlias : StatusCategoryImpl.getNameAndAliases(category)) {
            map.put(nameOrAlias, category);
        }
        return map;
    }

    private static List<String> getNameAndAliases(StatusCategory category) {
        ArrayList<String> nameAliasList = new ArrayList<String>();
        nameAliasList.add(category.getName());
        for (String alias : category.getAliases()) {
            nameAliasList.add(alias);
        }
        return nameAliasList;
    }

    public static StatusCategory getDefault() {
        return CATEGORIES_BY_KEY.get("undefined");
    }

    public static List<StatusCategory> getAllCategories() {
        return CATEGORIES;
    }

    public static List<StatusCategory> getUserVisibleCategories() {
        return Lists.newArrayList((Iterable)Iterables.filter(CATEGORIES, cat -> !cat.getKey().equals("undefined")));
    }

    static {
        CATEGORIES_BY_ID = Maps.uniqueIndex(CATEGORIES, statusCategory -> statusCategory.getId());
        CATEGORIES_BY_KEY = Maps.uniqueIndex(CATEGORIES, statusCategory -> statusCategory.getKey());
        CATEGORIES_BY_NAME_ALIAS = StatusCategoryImpl.getAllAliases();
    }
}

