/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.CommentSearchParameters;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.PinnedComment;
import com.atlassian.jira.issue.comments.pin.CommentPinManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.comment.CommentFieldRenderer;
import com.atlassian.jira.issue.tabpanels.CommentAction;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.model.querydsl.CommentPinDTO;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.issuetabpanel.DefaultPage;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.atlassian.jira.plugin.issuetabpanel.PaginatedIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKey;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKeys;
import com.atlassian.jira.plugin.webfragment.conditions.cache.RequestCachingConditionHelper;
import com.atlassian.jira.plugin.webfragment.model.CommentHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.jira.reactions.CommentReactionsEnabledService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.Window;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;

public class CommentTabPanel
implements PaginatedIssueTabPanel {
    private final CommentManager commentManager;
    private final CommentPinManager commentPinManager;
    private final CommentService commentService;
    private final CommentPermissionManager commentPermissionManager;
    private final CommentReactionsEnabledService commentReactionsEnabledService;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final IssueManager issueManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final CommentFieldRenderer commentFieldRenderer;
    private final CommentPropertyService commentPropertyService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    protected IssueTabPanelModuleDescriptor descriptor;

    public CommentTabPanel(CommentManager commentManager, CommentPinManager commentPinManager, CommentService commentService, CommentPermissionManager commentPermissionManager, CommentReactionsEnabledService commentReactionsEnabledService, IssueManager issueManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, DateTimeFormatter dateTimeFormatter, CommentFieldRenderer commentFieldRenderer, CommentPropertyService commentPropertyService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.commentManager = commentManager;
        this.commentPinManager = commentPinManager;
        this.commentService = commentService;
        this.commentPermissionManager = commentPermissionManager;
        this.commentReactionsEnabledService = commentReactionsEnabledService;
        this.issueManager = issueManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.commentFieldRenderer = commentFieldRenderer;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.commentPropertyService = commentPropertyService;
    }

    public void init(IssueTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean showPanel(ShowPanelRequest request) {
        return true;
    }

    public Page<IssueAction> getActions(GetActionsRequest request) {
        Page<IssueAction> commentActions = this.getComments(request);
        if (commentActions.getPageContents().isEmpty()) {
            return DefaultPage.only((Collection)Lists.newArrayList((Object[])new IssueAction[]{new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nocomments"))}));
        }
        return commentActions;
    }

    public String getHeader(GetActionsRequest request) {
        if (!this.commentPinManager.isFeatureEnabled() || this.isServiceDeskIssue(request.issue()) && !this.commentPinManager.isFeatureEnabledForServiceDesk()) {
            return "";
        }
        boolean canPin = this.commentService.hasPermissionToPinComments(request.loggedInUser(), request.issue(), (ErrorCollection)new SimpleErrorCollection());
        List pinnedComments = this.commentManager.getPinnedComments(request.issue(), request.loggedInUser());
        Map<Long, CommentPinDTO> commentPins = pinnedComments.stream().map(pc -> CommentPinDTO.builder().issueId(request.issue().getId()).commentId(pc.getComment().getId()).pinnedBy(pc.getPinnedBy()).pinnedDate(pc.getPinnedDate()).build()).collect(Collectors.toMap(CommentPinDTO::getCommentId, Function.identity()));
        List<IssueAction> pinCommentActions = this.convertCommentsToIssueActions(request.loggedInUser(), request.issue(), pinnedComments.stream().map(PinnedComment::getComment).collect(Collectors.toList()), commentPins, true);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("actions", pinCommentActions);
        context.put("hasActions", !pinCommentActions.isEmpty());
        context.put("canPin", canPin);
        return this.commentFieldRenderer.getHeaderViewHtml(context, CommentHelper.builder().issue(request.issue()).build());
    }

    private boolean isServiceDeskIssue(Issue issue) {
        Project projectObject = issue.getProjectObject();
        if (projectObject != null) {
            return ProjectTypeKeys.SERVICE_DESK.getKey().equals(projectObject.getProjectTypeKey().getKey());
        }
        return false;
    }

    private List<CommentPinDTO> getPinDTOs(long issueId) {
        return this.commentPinManager.isFeatureEnabled() ? this.commentPinManager.getPinnedComments(issueId) : Collections.emptyList();
    }

    private Page<IssueAction> getComments(final GetActionsRequest request) {
        final Map pinnedComments = this.getPinDTOs(request.issue().getId()).stream().collect(Collectors.toMap(CommentPinDTO::getCommentId, Function.identity()));
        final Window commentsForIssue = this.commentManager.searchCommentsVisibleForUser(CommentTabPanel.requestToSearchParameters(request));
        return new Page<IssueAction>(){

            public boolean isFirstPage() {
                return !commentsForIssue.hasElementsBefore();
            }

            public boolean isLastPage() {
                return !commentsForIssue.hasElementsAfter();
            }

            public List<IssueAction> getPageContents() {
                return CommentTabPanel.this.convertCommentsToIssueActions(request.loggedInUser(), request.issue(), commentsForIssue.get(), pinnedComments, false);
            }
        };
    }

    private static CommentSearchParameters requestToSearchParameters(GetActionsRequest request) {
        CommentSearchParameters.Builder builder = CommentSearchParameters.builder().issue(request.issue()).user(request.loggedInUser());
        if (request.batching().fromDate() != null) {
            if (request.batching().fetchMode() == GetActionsRequest.FetchMode.OLDER_THAN_DATE) {
                builder.searchByDate(request.batching().fromDate(), CommentSearchParameters.SearchDirection.OLDER);
            } else {
                builder.searchByDate(request.batching().fromDate(), CommentSearchParameters.SearchDirection.NEWER);
            }
        } else if (NumberUtils.isCreatable((String)request.getFocusId())) {
            builder.searchByComment(Long.parseLong(request.getFocusId()), CommentSearchParameters.SearchDirection.BOTH);
        } else if (request.batching().fetchMode() == GetActionsRequest.FetchMode.FROM_OLDEST) {
            builder.searchForTheOldestOrNewest(CommentSearchParameters.SearchDirection.OLDER);
        } else {
            builder.searchForTheOldestOrNewest(CommentSearchParameters.SearchDirection.NEWER);
        }
        if (request.isValidShowAllRequest()) {
            builder.noLimit();
        } else {
            builder.limit(request.batching().limit());
        }
        return builder.build();
    }

    private List<IssueAction> convertCommentsToIssueActions(ApplicationUser user, Issue issue, List<Comment> commentsForIssue, Map<Long, CommentPinDTO> commentPins, boolean isHeader) {
        ArrayList<IssueAction> commentActions = new ArrayList<IssueAction>();
        CommentEditablePermission permissions = new CommentEditablePermission(this.issueManager, this.commentManager, this.commentPermissionManager, user, issue);
        boolean commentReactionsEnabled = this.isCommentReactionsEnabled();
        boolean canCreateComment = RequestCachingConditionHelper.cacheConditionResultInRequest((ConditionCacheKey)ConditionCacheKeys.permission((ProjectPermissionKey)ProjectPermissions.ADD_COMMENTS, (ApplicationUser)user, (Object[])new Object[]{issue}), () -> this.commentService.hasPermissionToCreate(user, issue, (ErrorCollection)new SimpleErrorCollection()));
        boolean canReact = commentReactionsEnabled && canCreateComment;
        boolean canPin = this.commentService.hasPermissionToPinComments(user, issue, (ErrorCollection)new SimpleErrorCollection());
        for (Comment comment : commentsForIssue) {
            CommentPinDTO commentPin = commentPins.get(comment.getId());
            boolean isPinned = commentPin != null;
            Date pinnedAt = isPinned ? new Date(commentPin.getPinnedDate().getTime()) : null;
            String pinnedBy = isPinned ? commentPin.getPinnedBy() : null;
            commentActions.add((IssueAction)new CommentAction(this.descriptor, comment, permissions.canEdit(comment), permissions.canDelete(comment), canReact, commentReactionsEnabled, isHeader, false, isPinned, canPin, pinnedBy, pinnedAt, this.rendererManager, this.fieldLayoutManager, this.dateTimeFormatter, this.commentFieldRenderer, this.commentPropertyService, this.jiraAuthenticationContext));
        }
        return commentActions;
    }

    public String getPersistentMarkup(GetActionsRequest request) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isCommentReactionsEnabled()) {
            stringBuilder.append("<script>resourcePhaseCheckpoint.interaction.then(() => require('wrm/require')('wrc!commentReactions'));</script>");
        }
        if (this.commentPinManager.isFeatureEnabled()) {
            stringBuilder.append("<script>resourcePhaseCheckpoint.interaction.then(() => require('wrm/require')('wrc!commentPins'));</script>");
            stringBuilder.append("<script>resourcePhaseCheckpoint.interaction.then(() => require('wrm/require')('wrc!commentPinsDiscovery'));</script>");
        }
        return stringBuilder.toString();
    }

    private boolean isCommentReactionsEnabled() {
        return this.commentReactionsEnabledService.isEnabled() && this.jiraAuthenticationContext.isLoggedInUser();
    }

    private static class CommentEditablePermission {
        private final IssueManager issueManager;
        private final CommentManager commentManager;
        private final CommentPermissionManager commentPermissionManager;
        private final ApplicationUser user;
        boolean issueIsInEditableWorkflow = false;
        boolean canDeleteAllComments = false;
        boolean canDeleteOwnComments = false;
        boolean canEditAllComments = false;
        boolean canEditOwnComments = false;

        public CommentEditablePermission(IssueManager issueManager, CommentManager commentManager, CommentPermissionManager commentPermissionManager, ApplicationUser user, Issue issue) {
            this.issueManager = issueManager;
            this.commentManager = commentManager;
            this.commentPermissionManager = commentPermissionManager;
            this.user = user;
            this.init(issue);
        }

        private void init(Issue issue) {
            this.issueIsInEditableWorkflow = this.issueManager.isEditable(issue);
            this.canDeleteAllComments = this.issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteAllPermission(this.user, issue);
            this.canDeleteOwnComments = this.canDeleteAllComments || this.issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteOwnPermission(this.user, issue);
            this.canEditAllComments = this.issueIsInEditableWorkflow && this.commentPermissionManager.hasEditAllPermission(this.user, issue);
            this.canEditOwnComments = this.canEditAllComments || this.issueIsInEditableWorkflow && this.commentPermissionManager.hasEditOwnPermission(this.user, issue);
        }

        public boolean canDelete(Comment comment) {
            return this.canDeleteAllComments || this.canDeleteOwnComments && this.commentManager.isUserCommentAuthor(this.user, comment);
        }

        public boolean canEdit(Comment comment) {
            return this.canEditAllComments || this.canEditOwnComments && this.commentManager.isUserCommentAuthor(this.user, comment);
        }
    }
}

