/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.AjaxHeaders;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.api.model.WebPanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.action.Action;

public class IssueWebPanelRenderUtil {
    private static final String JIRA_VIEW_ISSUE_INFO_CONTEXT = "atl.jira.view.issue.info.context";
    private static final String JIRA_VIEW_ISSUE_RIGHT_CONTEXT = "atl.jira.view.issue.right.context";
    private static final String JIRA_VIEW_ISSUE_LEFT_CONTEXT = "atl.jira.view.issue.left.context";
    private final ApplicationUser loggedInUser;
    private final WebInterfaceManager webInterfaceManager;
    private final ModuleWebComponent moduleWebComponent;
    private final Map<String, Object> webPanelParams;

    public IssueWebPanelRenderUtil(ApplicationUser loggedInUser, Issue issue, Action action, WebInterfaceManager webInterfaceManager, ModuleWebComponent moduleWebComponent) {
        this.loggedInUser = loggedInUser;
        this.webInterfaceManager = webInterfaceManager;
        this.moduleWebComponent = moduleWebComponent;
        this.webPanelParams = new HashMap<String, Object>();
        this.webPanelParams.put("user", loggedInUser);
        this.webPanelParams.put("project", issue.getProjectObject());
        this.webPanelParams.put("issue", issue);
        this.webPanelParams.put("action", action);
        JiraHelper jiraHelper = new JiraHelper(ExecutingHttpRequest.get(), issue.getProjectObject(), this.webPanelParams);
        this.webPanelParams.put("helper", jiraHelper);
        this.webPanelParams.put("isAsynchronousRequest", AjaxHeaders.isPjaxRequest((HttpServletRequest)ExecutingHttpRequest.get()));
    }

    public List<? extends WebPanelModuleDescriptor> getInfoWebPanels() {
        return this.getWebPanels(JIRA_VIEW_ISSUE_INFO_CONTEXT);
    }

    public List<? extends WebPanelModuleDescriptor> getRightWebPanels() {
        return this.getWebPanels(JIRA_VIEW_ISSUE_RIGHT_CONTEXT);
    }

    public List<? extends WebPanelModuleDescriptor> getLeftWebPanels() {
        return this.getWebPanels(JIRA_VIEW_ISSUE_LEFT_CONTEXT);
    }

    public Map<String, Object> getWebPanelContext() {
        return this.webPanelParams;
    }

    private List<? extends WebPanelModuleDescriptor<? extends WebPanel>> getWebPanels(String location) {
        return this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, this.webPanelParams);
    }

    public String renderPanels(List<WebPanelModuleDescriptor<? extends WebPanel>> panels) {
        if (panels != null) {
            return this.moduleWebComponent.renderModules(this.loggedInUser, ExecutingHttpRequest.get(), panels, this.webPanelParams);
        }
        return "";
    }

    public String renderPanel(WebPanelModuleDescriptor panel) {
        if (panel != null) {
            return this.moduleWebComponent.renderModule(this.loggedInUser, ExecutingHttpRequest.get(), (WebPanelModuleDescriptor<? extends WebPanel>)panel, this.webPanelParams);
        }
        return "";
    }

    public String renderHeadlessPanel(WebPanelModuleDescriptor panel) {
        if (panel != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(this.webPanelParams);
            params.put("headless", true);
            return this.moduleWebComponent.renderModule(this.loggedInUser, ExecutingHttpRequest.get(), (WebPanelModuleDescriptor<? extends WebPanel>)panel, params);
        }
        return "";
    }
}

