/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.AjaxHeaders;
import com.atlassian.jira.web.component.ModuleWebComponent;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.api.model.WebPanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class RendererWebPanelRenderUtil {
    private final ApplicationUser loggedInUser;
    private final DynamicWebInterfaceManager webInterfaceManager;
    private final ModuleWebComponent moduleWebComponent;
    private final Map<String, Object> webPanelParams;

    public RendererWebPanelRenderUtil(ApplicationUser loggedInUser, String value, String issueKey, Issue issue, String fieldId, String fieldName, boolean singleLine, DynamicWebInterfaceManager webInterfaceManager, ModuleWebComponent moduleWebComponent, JiraRendererPlugin renderer, Map<String, String[]> requestParams) {
        this.loggedInUser = loggedInUser;
        this.webInterfaceManager = webInterfaceManager;
        this.moduleWebComponent = moduleWebComponent;
        Optional<Issue> issueOpt = Optional.ofNullable(issue);
        this.webPanelParams = new HashMap<String, Object>();
        this.webPanelParams.put("user", loggedInUser);
        this.webPanelParams.put("project", issueOpt.map(Issue::getProjectObject).orElse(null));
        this.webPanelParams.put("issue", issue);
        JiraHelper jiraHelper = new JiraHelper(ExecutingHttpRequest.get(), (Project)issueOpt.map(Issue::getProjectObject).orElse(null));
        this.webPanelParams.put("helper", jiraHelper);
        this.webPanelParams.put("isAsynchronousRequest", AjaxHeaders.isPjaxRequest((HttpServletRequest)ExecutingHttpRequest.get()));
        this.webPanelParams.put("req", ExecutingHttpRequest.get());
        this.webPanelParams.put("issueKey", issueKey);
        this.webPanelParams.put("fieldId", fieldId);
        this.webPanelParams.put("fieldName", fieldName);
        this.webPanelParams.put("rendererType", renderer.getRendererType());
        this.webPanelParams.put("value", renderer.transformForEdit((Object)value));
        IssueRenderContext issueRenderContext = issueOpt.map(Issue::getIssueRenderContext).orElse(new IssueRenderContext(null));
        issueRenderContext.addParam((Object)"atlassian-renderer-for-wysiwyg", (Object)Boolean.TRUE);
        Optional.ofNullable(requestParams.get("formToken")).filter(ar -> ((String[])ar).length > 0).map(ar -> ar[0]).ifPresent(param -> issueRenderContext.addParam((Object)"atlassian-renderer-form-token", param));
        this.webPanelParams.put("valueRendered", StringUtils.isNotEmpty((CharSequence)value) ? renderer.render(value, issueRenderContext) : "");
        if (singleLine) {
            this.webPanelParams.put("singleLine", Boolean.TRUE);
        }
    }

    public List<? extends WebPanelModuleDescriptor<? extends WebPanel>> getWebPanels(String location) {
        return this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, this.webPanelParams);
    }

    public String renderPanels(List<? extends WebPanelModuleDescriptor<? extends WebPanel>> panels) {
        if (panels != null) {
            return this.moduleWebComponent.renderModules(this.loggedInUser, ExecutingHttpRequest.get(), panels, this.webPanelParams);
        }
        return "";
    }
}

