/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.search.DocumentWithId;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.SingleIssueWriter;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssueTableWriter;
import com.atlassian.query.Query;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Document;

public class DefaultSearchRequestViewBodyWriterUtil
implements SearchRequestViewBodyWriterUtil {
    private final SearchProviderFactory searchProviderFactory;
    private final IssueFactory issueFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchProvider searchProvider;

    public DefaultSearchRequestViewBodyWriterUtil(SearchProviderFactory searchProviderFactory, IssueFactory issueFactory, JiraAuthenticationContext authenticationContext, SearchProvider searchProvider) {
        this.searchProviderFactory = searchProviderFactory;
        this.issueFactory = issueFactory;
        this.authenticationContext = authenticationContext;
        this.searchProvider = searchProvider;
    }

    @Override
    public void writeBody(Writer writer, AbstractIssueView issueView, SearchRequest searchRequest, SingleIssueWriter singleIssueWriter, PagerFilter pagerFilter) throws IOException, SearchException {
        ManagedIndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        for (Integer docId : this.searchAndSort(searchRequest, pagerFilter)) {
            Document d = searcher.doc(docId.intValue());
            Issue issue = this.issueFactory.getIssue(d);
            singleIssueWriter.writeIssue(issue, issueView, writer);
        }
    }

    @Override
    public void writeTableBody(Writer writer, IssueTableWriter issueTableWriter, SearchRequest searchRequest, PagerFilter pagerFilter) throws IOException, SearchException {
        ManagedIndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        for (Integer docId : this.searchAndSort(searchRequest, pagerFilter)) {
            Document d = searcher.doc(docId.intValue());
            Issue issue = this.issueFactory.getIssue(d);
            issueTableWriter.write(issue);
        }
        issueTableWriter.close();
    }

    @Override
    public List<Integer> searchAndSort(SearchRequest searchRequest, PagerFilter pagerFilter) throws SearchException {
        Query query = searchRequest != null ? searchRequest.getQuery() : null;
        return this.searchProvider.search(SearchQuery.create((Query)query, (ApplicationUser)this.authenticationContext.getLoggedInUser()), pagerFilter, Collections.emptySet()).transform(DocumentWithId::getDocId).getResults();
    }

    @Override
    public long searchCount(SearchRequest searchRequest) throws SearchException {
        Query query = searchRequest != null ? searchRequest.getQuery() : null;
        return this.searchProvider.getHitCount(SearchQuery.create((Query)query, (ApplicationUser)this.authenticationContext.getLoggedInUser()));
    }
}

