/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.builder.ConditionBuilder;
import com.atlassian.jira.jql.builder.DefaultConditionBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlFieldReference;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.builder.PrecedenceSimpleClauseBuilder;
import com.atlassian.jira.jql.builder.SimpleClauseBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.util.JqlDateSupportImpl;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
class DefaultJqlClauseBuilder
implements JqlClauseBuilder {
    private final JqlQueryBuilder parent;
    private final JqlDateSupport jqlDateSupport;
    private SimpleClauseBuilder builder;

    DefaultJqlClauseBuilder(JqlQueryBuilder parent, SimpleClauseBuilder builder, JqlDateSupport support) {
        this.builder = (SimpleClauseBuilder)Assertions.notNull((String)"builder", (Object)builder);
        this.jqlDateSupport = (JqlDateSupport)Assertions.notNull((String)"support", (Object)support);
        this.parent = parent;
    }

    DefaultJqlClauseBuilder(JqlQueryBuilder parent, TimeZoneManager timeZoneManager) {
        this(parent, new PrecedenceSimpleClauseBuilder(), new JqlDateSupportImpl(timeZoneManager));
    }

    DefaultJqlClauseBuilder(TimeZoneManager timeZoneManager) {
        this(null, timeZoneManager);
    }

    public JqlClauseBuilder clear() {
        this.builder = this.builder.clear();
        return this;
    }

    public JqlQueryBuilder endWhere() {
        return this.parent;
    }

    public Query buildQuery() {
        if (this.parent != null) {
            return this.parent.buildQuery();
        }
        return new QueryImpl(this.buildClause());
    }

    public JqlClauseBuilder defaultAnd() {
        this.builder = this.builder.defaultAnd();
        return this;
    }

    public JqlClauseBuilder defaultOr() {
        this.builder = this.builder.defaultOr();
        return this;
    }

    public JqlClauseBuilder defaultNone() {
        this.builder = this.builder.defaultNone();
        return this;
    }

    public JqlClauseBuilder and() {
        this.builder = this.builder.and();
        return this;
    }

    public JqlClauseBuilder or() {
        this.builder = this.builder.or();
        return this;
    }

    public JqlClauseBuilder not() {
        this.builder = this.builder.not();
        return this;
    }

    public JqlClauseBuilder sub() {
        this.builder = this.builder.sub();
        return this;
    }

    public JqlClauseBuilder endsub() {
        this.builder = this.builder.endsub();
        return this;
    }

    public JqlClauseBuilder affectedVersion(String version) {
        return this.addStringCondition(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), version);
    }

    public JqlClauseBuilder affectedVersion(String ... versons) {
        return this.addStringCondition(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), versons);
    }

    public JqlClauseBuilder affectedVersionIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder affectedVersion() {
        return new DefaultConditionBuilder(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder fixVersion(String version) {
        return this.addStringCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), version);
    }

    public JqlClauseBuilder fixVersion(String ... versions) {
        return this.addStringCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), versions);
    }

    public JqlClauseBuilder fixVersion(Long version) {
        return this.addNumberCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), version);
    }

    public JqlClauseBuilder fixVersion(Long ... versions) {
        return this.addNumberCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), versions);
    }

    public JqlClauseBuilder fixVersionIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder fixVersion() {
        return new DefaultConditionBuilder(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder priority(String ... priorities) {
        return this.addStringCondition(SystemSearchConstants.forPriority().getJqlClauseNames().getPrimaryName(), priorities);
    }

    public ConditionBuilder priority() {
        return new DefaultConditionBuilder(SystemSearchConstants.forPriority().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder resolution(String ... resolutions) {
        return this.addStringCondition(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), resolutions);
    }

    public JqlClauseBuilder unresolved() {
        return this.addCondition(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new SingleValueOperand("Unresolved"));
    }

    public ConditionBuilder resolution() {
        return new DefaultConditionBuilder(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder status(String ... statuses) {
        return this.addStringCondition(SystemSearchConstants.forStatus().getJqlClauseNames().getPrimaryName(), statuses);
    }

    public ConditionBuilder status() {
        return new DefaultConditionBuilder(SystemSearchConstants.forStatus().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder statusCategory(String ... categories) {
        return this.addStringCondition(SystemSearchConstants.forStatusCategory().getJqlClauseNames().getPrimaryName(), categories);
    }

    public ConditionBuilder statusCategory() {
        return new DefaultConditionBuilder(SystemSearchConstants.forStatusCategory().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder issueType(String ... types) {
        return this.addStringCondition(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), types);
    }

    public JqlClauseBuilder issueTypeIsStandard() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), Operator.IN, "standardIssueTypes");
    }

    public JqlClauseBuilder issueTypeIsSubtask() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), Operator.IN, "subTaskIssueTypes");
    }

    public ConditionBuilder issueType() {
        return new DefaultConditionBuilder(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder description(String value) {
        return this.addStringCondition(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    public JqlClauseBuilder descriptionIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder description() {
        return new DefaultConditionBuilder(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder summary(String value) {
        return this.addStringCondition(SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    public ConditionBuilder summary() {
        return new DefaultConditionBuilder(SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder environment(String value) {
        return this.addStringCondition(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    public JqlClauseBuilder environmentIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder environment() {
        return new DefaultConditionBuilder(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder comment(String value) {
        return this.addStringCondition(SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    public ConditionBuilder comment() {
        return new DefaultConditionBuilder(SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder project(String ... projects) {
        return this.addStringCondition(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), projects);
    }

    public JqlClauseBuilder project(Long ... pids) {
        return this.addNumberCondition(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), pids);
    }

    public ConditionBuilder project() {
        return new DefaultConditionBuilder(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder category(String ... values) {
        return this.addStringCondition(SystemSearchConstants.forProjectCategory().getJqlClauseNames().getPrimaryName(), values);
    }

    public ConditionBuilder category() {
        return new DefaultConditionBuilder(SystemSearchConstants.forProjectCategory().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder createdAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder createdAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder createdBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    public JqlClauseBuilder createdBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    public ConditionBuilder created() {
        return new DefaultConditionBuilder(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder updatedAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder updatedAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder updatedBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    public JqlClauseBuilder updatedBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    public ConditionBuilder updated() {
        return new DefaultConditionBuilder(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder dueAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder dueAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder dueBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    public JqlClauseBuilder dueBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    public ConditionBuilder due() {
        return new DefaultConditionBuilder(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder lastViewedAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forLastViewedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder lastViewedAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forLastViewedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder lastViewedBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forLastViewedDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    public JqlClauseBuilder lastViewedBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forLastViewedDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    public ConditionBuilder lastViewed() {
        return new DefaultConditionBuilder(SystemSearchConstants.forLastViewedDate().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder resolutionDateAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder resolutionDateAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    public JqlClauseBuilder resolutionDateBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    public JqlClauseBuilder resolutionDateBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    public ConditionBuilder resolutionDate() {
        return new DefaultConditionBuilder(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder reporterUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        return this.addStringCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), userName);
    }

    public JqlClauseBuilder reporterInGroup(String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        return this.addCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", new String[]{groupName}));
    }

    public JqlClauseBuilder reporterIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    public JqlClauseBuilder reporterIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder reporter() {
        return new DefaultConditionBuilder(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder assigneeUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        return this.addStringCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), userName);
    }

    public JqlClauseBuilder assigneeInGroup(String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        return this.addCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", new String[]{groupName}));
    }

    public JqlClauseBuilder assigneeIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    public JqlClauseBuilder assigneeIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder assignee() {
        return new DefaultConditionBuilder(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder component(String ... components) {
        return this.addStringCondition(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), components);
    }

    public JqlClauseBuilder component(Long ... components) {
        return this.addNumberCondition(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), components);
    }

    public JqlClauseBuilder componentIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder component() {
        return new DefaultConditionBuilder(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), this);
    }

    public ConditionBuilder labels() {
        return new DefaultConditionBuilder(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder labels(String ... labels) {
        return this.addStringCondition(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), labels);
    }

    public JqlClauseBuilder labelsIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName());
    }

    public JqlClauseBuilder issue(String ... keys) {
        return this.addStringCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, keys);
    }

    public JqlClauseBuilder issueInHistory() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, "issueHistory");
    }

    public JqlClauseBuilder issueInWatchedIssues() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, "watchedIssues");
    }

    public JqlClauseBuilder issueInVotedIssues() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, "votedIssues");
    }

    public ConditionBuilder issue() {
        return new DefaultConditionBuilder(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder issueParent(String ... keys) {
        return this.addStringCondition(SystemSearchConstants.forIssueParent().getJqlClauseNames().getPrimaryName(), Operator.IN, keys);
    }

    public ConditionBuilder issueParent() {
        return new DefaultConditionBuilder(SystemSearchConstants.forIssueParent().getJqlClauseNames().getPrimaryName(), this);
    }

    public ConditionBuilder currentEstimate() {
        return new DefaultConditionBuilder(SystemSearchConstants.forCurrentEstimate().getJqlClauseNames().getPrimaryName(), this);
    }

    public ConditionBuilder originalEstimate() {
        return new DefaultConditionBuilder(SystemSearchConstants.forOriginalEstimate().getJqlClauseNames().getPrimaryName(), this);
    }

    public ConditionBuilder timeSpent() {
        return new DefaultConditionBuilder(SystemSearchConstants.forTimeSpent().getJqlClauseNames().getPrimaryName(), this);
    }

    public ConditionBuilder workRatio() {
        return new DefaultConditionBuilder(SystemSearchConstants.forWorkRatio().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder level(String ... levels) {
        return this.addStringCondition(SystemSearchConstants.forSecurityLevel().getJqlClauseNames().getPrimaryName(), Operator.IN, levels);
    }

    public ConditionBuilder level() {
        return new DefaultConditionBuilder(SystemSearchConstants.forSecurityLevel().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder savedFilter(String ... filters) {
        return this.addStringCondition(SystemSearchConstants.forSavedFilter().getJqlClauseNames().getPrimaryName(), Operator.IN, filters);
    }

    public ConditionBuilder savedFilter() {
        return new DefaultConditionBuilder(SystemSearchConstants.forSavedFilter().getJqlClauseNames().getPrimaryName(), this);
    }

    public ConditionBuilder votes() {
        return new DefaultConditionBuilder(SystemSearchConstants.forVotes().getJqlClauseNames().getPrimaryName(), this);
    }

    public ConditionBuilder watches() {
        return new DefaultConditionBuilder(SystemSearchConstants.forWatches().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder voterUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        return this.addStringCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), userName);
    }

    public JqlClauseBuilder voterInGroup(String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        return this.addCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", new String[]{groupName}));
    }

    public JqlClauseBuilder voterIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    public JqlClauseBuilder voterIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder voter() {
        return new DefaultConditionBuilder(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder watcherUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        return this.addStringCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), userName);
    }

    public JqlClauseBuilder watcherInGroup(String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        return this.addCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", new String[]{groupName}));
    }

    public JqlClauseBuilder watcherIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    public JqlClauseBuilder watcherIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName());
    }

    public ConditionBuilder watcher() {
        return new DefaultConditionBuilder(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), this);
    }

    public JqlClauseBuilder attachmentsExists(boolean hasAttachment) {
        return this.addStringCondition(SystemSearchConstants.forAttachments().getJqlClauseNames().getPrimaryName(), hasAttachment ? Operator.IS_NOT : Operator.IS, "EMPTY");
    }

    public ConditionBuilder field(String jqlName) {
        Assertions.notNull((String)"jqlName", (Object)jqlName);
        return new DefaultConditionBuilder(jqlName, this);
    }

    public ConditionBuilder customField(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        return new DefaultConditionBuilder(JqlCustomFieldId.toString((long)id), this);
    }

    public JqlClauseBuilder addClause(Clause clause) {
        Assertions.notNull((String)"clause", (Object)clause);
        this.builder = this.builder.clause(clause);
        return this;
    }

    public JqlClauseBuilder addDateCondition(String clauseName, Operator operator, Date date) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.notNull((String)"date", (Object)date);
        return this.addTerminalClause(clauseName, operator, (Operand)new SingleValueOperand(this.jqlDateSupport.getDateString(date)));
    }

    public JqlClauseBuilder addDateCondition(String clauseName, Date ... dates) {
        if (dates != null && dates.length == 1) {
            return this.addDateCondition(clauseName, Operator.EQUALS, dates[0]);
        }
        return this.addDateCondition(clauseName, Operator.IN, dates);
    }

    public JqlClauseBuilder addDateCondition(String clauseName, Operator operator, Date ... dates) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"dates", (Object[])dates);
        Assertions.not((String)"dates is empty", (dates.length == 0 ? 1 : 0) != 0);
        String[] args = new String[dates.length];
        int position = 0;
        for (Date date : dates) {
            args[position++] = this.jqlDateSupport.getDateString(date);
        }
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(args));
    }

    public JqlClauseBuilder addDateCondition(String clauseName, Collection<Date> dates) {
        if (dates != null && dates.size() == 1) {
            return this.addDateCondition(clauseName, Operator.EQUALS, dates.iterator().next());
        }
        return this.addDateCondition(clauseName, Operator.IN, dates);
    }

    public JqlClauseBuilder addDateCondition(String clauseName, Operator operator, Collection<Date> dates) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"dates", dates);
        Assertions.not((String)"dates is empty", (boolean)dates.isEmpty());
        String[] args = new String[dates.size()];
        int position = 0;
        for (Date date : dates) {
            args[position++] = this.jqlDateSupport.getDateString(date);
        }
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(args));
    }

    public JqlClauseBuilder addDateRangeCondition(String clauseName, Date startDate, Date endDate) {
        SingleValueOperand startOperand = startDate == null ? null : new SingleValueOperand(this.jqlDateSupport.getDateString(startDate));
        SingleValueOperand endOperand = endDate == null ? null : new SingleValueOperand(this.jqlDateSupport.getDateString(endDate));
        return this.addRangeCondition(clauseName, (Operand)startOperand, (Operand)endOperand);
    }

    public JqlClauseBuilder addFunctionCondition(String clauseName, String functionName) {
        return this.addFunctionCondition(clauseName, Operator.EQUALS, functionName);
    }

    public JqlClauseBuilder addFunctionCondition(String clauseName, String functionName, String ... args) {
        return this.addFunctionCondition(clauseName, Operator.EQUALS, functionName, args);
    }

    public JqlClauseBuilder addFunctionCondition(String clauseName, String functionName, Collection<String> args) {
        return this.addFunctionCondition(clauseName, Operator.EQUALS, functionName, args);
    }

    public JqlClauseBuilder addFunctionCondition(String clauseName, Operator operator, String functionName) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.notNull((String)"functionName", (Object)functionName);
        return this.addTerminalClause(clauseName, operator, (Operand)new FunctionOperand(functionName));
    }

    public JqlClauseBuilder addFunctionCondition(String clauseName, Operator operator, String functionName, String ... args) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.notNull((String)"functionName", (Object)functionName);
        Assertions.containsNoNulls((String)"args", (Object[])args);
        return this.addTerminalClause(clauseName, operator, (Operand)new FunctionOperand(functionName, args));
    }

    public JqlClauseBuilder addFunctionCondition(String clauseName, Operator operator, String functionName, Collection<String> args) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.notNull((String)"functionName", (Object)functionName);
        Assertions.containsNoNulls((String)"args", args);
        return this.addTerminalClause(clauseName, operator, (Operand)new FunctionOperand(functionName, args));
    }

    public JqlClauseBuilder addStringCondition(String clauseName, String clauseValue) {
        return this.addStringCondition(clauseName, Operator.EQUALS, clauseValue);
    }

    public JqlClauseBuilder addStringCondition(String clauseName, String ... clauseValues) {
        if (clauseValues != null && clauseValues.length == 1) {
            return this.addStringCondition(clauseName, Operator.EQUALS, clauseValues[0]);
        }
        return this.addStringCondition(clauseName, Operator.IN, clauseValues);
    }

    public JqlClauseBuilder addStringCondition(String clauseName, Collection<String> clauseValues) {
        if (clauseValues != null && clauseValues.size() == 1) {
            return this.addStringCondition(clauseName, Operator.EQUALS, clauseValues.iterator().next());
        }
        return this.addStringCondition(clauseName, Operator.IN, clauseValues);
    }

    public JqlClauseBuilder addFieldReferenceCondition(JqlFieldReference ref, Collection<String> clauseValues) {
        Assertions.notNull((String)"ref", (Object)ref);
        Property property = new Property(Collections.singletonList(ref.getProperty()), ref.hasReference() ? Collections.singletonList(ref.getReference()) : Collections.emptyList());
        return this.addTerminalClause(ref.getName(), (Option<Property>)Option.option((Object)property), Operator.IN, (Operand)new MultiValueOperand(clauseValues.toArray(new String[clauseValues.size()])));
    }

    public JqlClauseBuilder addStringCondition(String clauseName, Operator operator, String clauseValue) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.notNull((String)"clauseValue", (Object)clauseValue);
        return this.addTerminalClause(clauseName, operator, (Operand)new SingleValueOperand(clauseValue));
    }

    public JqlClauseBuilder addStringCondition(String clauseName, Operator operator, String ... clauseValues) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"clauseValues", (Object[])clauseValues);
        Assertions.not((String)"clauseValues is empty", (clauseValues.length == 0 ? 1 : 0) != 0);
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(clauseValues));
    }

    public JqlClauseBuilder addStringCondition(String clauseName, Operator operator, Collection<String> clauseValues) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"clauseValues", clauseValues);
        Assertions.not((String)"clauseValues is empty", (boolean)clauseValues.isEmpty());
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(clauseValues.toArray(new String[clauseValues.size()])));
    }

    public JqlClauseBuilder addStringRangeCondition(String clauseName, String start, String end) {
        SingleValueOperand startClause = start == null ? null : new SingleValueOperand(start);
        SingleValueOperand endClause = end == null ? null : new SingleValueOperand(end);
        return this.addRangeCondition(clauseName, (Operand)startClause, (Operand)endClause);
    }

    public JqlClauseBuilder addNumberCondition(String clauseName, Long clauseValue) {
        return this.addNumberCondition(clauseName, Operator.EQUALS, clauseValue);
    }

    public JqlClauseBuilder addNumberCondition(String clauseName, Long ... clauseValues) {
        if (clauseValues != null && clauseValues.length == 1) {
            return this.addNumberCondition(clauseName, Operator.EQUALS, clauseValues[0]);
        }
        return this.addNumberCondition(clauseName, Operator.IN, clauseValues);
    }

    public JqlClauseBuilder addNumberCondition(String clauseName, Collection<Long> clauseValues) {
        if (clauseValues != null && clauseValues.size() == 1) {
            return this.addNumberCondition(clauseName, Operator.EQUALS, clauseValues.iterator().next());
        }
        return this.addNumberCondition(clauseName, Operator.IN, clauseValues);
    }

    public JqlClauseBuilder addNumberCondition(String clauseName, Operator operator, Long clauseValue) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.notNull((String)"clauseValue", (Object)clauseValue);
        return this.addTerminalClause(clauseName, operator, (Operand)new SingleValueOperand(clauseValue));
    }

    public JqlClauseBuilder addNumberCondition(String clauseName, Operator operator, Long ... clauseValues) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"clauseValues", (Object[])clauseValues);
        Assertions.not((String)"clauseValues is empty", (clauseValues.length == 0 ? 1 : 0) != 0);
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(clauseValues));
    }

    public JqlClauseBuilder addNumberCondition(String clauseName, Operator operator, Collection<Long> clauseValues) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"clauseValues", clauseValues);
        Assertions.not((String)"clauseValues is empty", (boolean)clauseValues.isEmpty());
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(clauseValues.toArray(new Long[clauseValues.size()])));
    }

    public JqlClauseBuilder addNumberRangeCondition(String clauseName, Long start, Long end) {
        SingleValueOperand startClause = start == null ? null : new SingleValueOperand(start);
        SingleValueOperand endClause = end == null ? null : new SingleValueOperand(end);
        return this.addRangeCondition(clauseName, (Operand)startClause, (Operand)endClause);
    }

    public ConditionBuilder addCondition(String clauseName) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        return new DefaultConditionBuilder(clauseName, this);
    }

    public JqlClauseBuilder addCondition(String clauseName, Operand operand) {
        return this.addCondition(clauseName, Operator.EQUALS, operand);
    }

    public JqlClauseBuilder addCondition(String clauseName, Operand ... operands) {
        return this.addCondition(clauseName, Operator.IN, operands);
    }

    public JqlClauseBuilder addCondition(String clauseName, Collection<? extends Operand> operands) {
        return this.addCondition(clauseName, Operator.IN, operands);
    }

    public JqlClauseBuilder addCondition(String clauseName, Operator operator, Operand operand) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.notNull((String)"operand", (Object)operand);
        return this.addTerminalClause(clauseName, operator, operand);
    }

    public JqlClauseBuilder addCondition(String clauseName, Operator operator, Operand ... operands) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"operands", (Object[])operands);
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(operands));
    }

    public JqlClauseBuilder addCondition(String clauseName, Operator operator, Collection<? extends Operand> operands) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        Assertions.notNull((String)"operator", (Object)operator);
        Assertions.containsNoNulls((String)"operands", operands);
        return this.addTerminalClause(clauseName, operator, (Operand)new MultiValueOperand(operands));
    }

    public JqlClauseBuilder addRangeCondition(String clauseName, Operand start, Operand end) {
        TerminalClauseImpl clause;
        Assertions.not((String)"start and end are both null.", (start == null && end == null ? 1 : 0) != 0);
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        if (start != null) {
            if (end != null) {
                TerminalClauseImpl startClause = new TerminalClauseImpl(clauseName, Operator.GREATER_THAN_EQUALS, start);
                TerminalClauseImpl endClause = new TerminalClauseImpl(clauseName, Operator.LESS_THAN_EQUALS, end);
                clause = new AndClause(new Clause[]{startClause, endClause});
            } else {
                clause = new TerminalClauseImpl(clauseName, Operator.GREATER_THAN_EQUALS, start);
            }
        } else {
            clause = new TerminalClauseImpl(clauseName, Operator.LESS_THAN_EQUALS, end);
        }
        return this.addClause((Clause)clause);
    }

    public Clause buildClause() {
        return this.builder.build();
    }

    private JqlClauseBuilder addTerminalClause(String clauseName, Operator operator, Operand clauseValue) {
        this.builder = this.builder.clause((Clause)new TerminalClauseImpl(clauseName, operator, clauseValue));
        return this;
    }

    private JqlClauseBuilder addTerminalClause(String clauseName, Option<Property> property, Operator operator, Operand clauseValue) {
        this.builder = this.builder.clause((Clause)new TerminalClauseImpl(clauseName, operator, clauseValue, property));
        return this;
    }

    public JqlClauseBuilder addEmptyCondition(String clauseName) {
        Assertions.notNull((String)"clauseName", (Object)clauseName);
        return this.addTerminalClause(clauseName, Operator.IS, (Operand)EmptyOperand.EMPTY);
    }
}

