/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.StatusResolver;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusClauseContextFactory
implements ClauseContextFactory {
    private static final Logger log = LoggerFactory.getLogger(StatusClauseContextFactory.class);
    private final JqlOperandResolver jqlOperandResolver;
    private final WorkflowManager workflowManager;
    private final PermissionManager permissionManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueConstantInfoResolver<?> issueConstantInfoResolver;

    public StatusClauseContextFactory(JqlOperandResolver jqlOperandResolver, StatusResolver statusResolver, WorkflowManager workflowManager, PermissionManager permissionManager, IssueTypeSchemeManager issueTypeSchemeManager, WorkflowSchemeManager workflowSchemeManager) {
        this.workflowManager = workflowManager;
        this.permissionManager = permissionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.issueConstantInfoResolver = new IssueConstantInfoResolver<Status>(statusResolver);
    }

    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        boolean isEquality = this.isEqualityOperator(operator);
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Set<ProjectIssueTypeContext> projectIssueTypeContexts = this.getContextFromStatusValues(searcher, terminalClause, isEquality);
        return projectIssueTypeContexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(projectIssueTypeContexts);
    }

    Set<ProjectIssueTypeContext> getContextFromStatusValues(ApplicationUser searcher, TerminalClause clause, boolean equality) {
        Set<String> ids = this.getIds(searcher, clause);
        if (ids.isEmpty()) {
            return Collections.emptySet();
        }
        boolean allProjects = true;
        boolean allIssueTypesAcrossAllProjects = true;
        HashMap<String, Boolean> resultCache = new HashMap<String, Boolean>();
        HashSet<ProjectIssueTypeContext> allContexts = new HashSet<ProjectIssueTypeContext>();
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, searcher);
        for (Project project : projects) {
            boolean projectAdded = false;
            boolean allIssueTypesAcrossProject = true;
            Set<Object> projectIssueTypeContexts = new HashSet();
            Map workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
            for (Map.Entry entry : workflowMap.entrySet()) {
                boolean typeAdded;
                String issueType = (String)entry.getKey();
                String workflowName = (String)entry.getValue();
                Boolean cachedResult = (Boolean)resultCache.get(workflowName);
                if (cachedResult != null) {
                    typeAdded = cachedResult;
                } else {
                    typeAdded = this.checkWorkflow(equality, ids, project, issueType, workflowName);
                    resultCache.put(workflowName, typeAdded);
                }
                if (typeAdded) {
                    projectIssueTypeContexts.addAll(this.getContextsForIssueType(project, workflowMap, issueType));
                    projectAdded = true;
                    continue;
                }
                allIssueTypesAcrossAllProjects = false;
                allIssueTypesAcrossProject = false;
            }
            if (allIssueTypesAcrossProject) {
                projectIssueTypeContexts = Collections.singleton(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(project.getId()), (IssueTypeContext)AllIssueTypesContext.INSTANCE));
            }
            if (!projectAdded) {
                allProjects = false;
            }
            allContexts.addAll(projectIssueTypeContexts);
        }
        if (allProjects && allIssueTypesAcrossAllProjects) {
            return Collections.singleton(ProjectIssueTypeContextImpl.createGlobalContext());
        }
        return allContexts;
    }

    private Set<ProjectIssueTypeContext> getContextsForIssueType(Project project, Map<String, String> schemeMap, String issueType) {
        if (issueType == null) {
            HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
            Collection projectTypes = this.issueTypeSchemeManager.getIssueTypesForProject(project);
            for (IssueType projectType : projectTypes) {
                if (projectType == null || schemeMap.containsKey(projectType.getId())) continue;
                contexts.add((ProjectIssueTypeContext)new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(project.getId()), (IssueTypeContext)new IssueTypeContextImpl(projectType.getId())));
            }
            return contexts;
        }
        return Collections.singleton(new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(project.getId()), (IssueTypeContext)new IssueTypeContextImpl(issueType)));
    }

    private boolean checkWorkflow(boolean equality, Set<String> ids, Project project, String issueType, String workflowName) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow != null) {
            List statusObjects = workflow.getLinkedStatusObjects();
            for (Status statusObject : statusObjects) {
                if (statusObject != null) {
                    if (equality != ids.contains(statusObject.getId())) continue;
                    return true;
                }
                String issueTypeStr = issueType == null ? "default" : issueType;
                log.debug("Workflow: '" + workflow.getName() + "' associated with project: '" + project.getId() + "' and issue type: '" + issueTypeStr + "' contains a null status, you might want to fix that.");
            }
        }
        return false;
    }

    Set<String> getIds(ApplicationUser searcher, TerminalClause clause) {
        List literals = this.jqlOperandResolver.getValues(searcher, clause.getOperand(), clause);
        HashSet<String> ids = new HashSet<String>();
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.getLongValue() != null) {
                    ids.addAll(this.issueConstantInfoResolver.getIndexedValues(literal.getLongValue()));
                    continue;
                }
                if (literal.getStringValue() != null) {
                    ids.addAll(this.issueConstantInfoResolver.getIndexedValues(literal.getStringValue()));
                    continue;
                }
                if (!literal.isEmpty()) continue;
            }
        }
        return ids;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    private boolean isEqualityOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IS || operator == Operator.IN;
    }
}

