/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.optimizers.DeterminedProjectsExtractor;
import com.atlassian.jira.jql.query.ChangedClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.QueryRegistry;
import com.atlassian.jira.jql.query.QueryVisitorUtil;
import com.atlassian.jira.jql.query.WasClauseQueryFactory;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class ContextAwareQueryVisitor
implements ClauseVisitor<QueryFactoryResult> {
    private final QueryRegistry queryRegistry;
    private final WasClauseQueryFactory wasClauseQueryFactory;
    private final ChangedClauseQueryFactory changedClauseQueryFactory;
    private final DeterminedProjectsExtractor determinedProjectsExtractor;
    private final QueryCreationContext queryCreationContext;
    private final Clause parentClause;

    ContextAwareQueryVisitor(QueryRegistry queryRegistry, WasClauseQueryFactory wasClauseQueryFactory, ChangedClauseQueryFactory changedClauseQueryFactory, QueryCreationContext queryCreationContext, Clause parentClause) {
        this(queryRegistry, wasClauseQueryFactory, changedClauseQueryFactory, new DeterminedProjectsExtractor(), queryCreationContext, parentClause);
    }

    ContextAwareQueryVisitor(QueryRegistry queryRegistry, WasClauseQueryFactory wasClauseQueryFactory, ChangedClauseQueryFactory changedClauseQueryFactory, DeterminedProjectsExtractor determinedProjectsExtractor, QueryCreationContext queryCreationContext, Clause parentClause) {
        this.queryRegistry = queryRegistry;
        this.wasClauseQueryFactory = wasClauseQueryFactory;
        this.changedClauseQueryFactory = changedClauseQueryFactory;
        this.determinedProjectsExtractor = determinedProjectsExtractor;
        this.queryCreationContext = queryCreationContext;
        this.parentClause = parentClause;
    }

    public QueryFactoryResult visit(AndClause andClause) {
        ContextAwareQueryVisitor.assertClauseNotTooComplex((Clause)andClause);
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        for (Clause clause : andClause.getClauses()) {
            QueryFactoryResult queryFactoryResult = (QueryFactoryResult)clause.accept((ClauseVisitor)this.createContextAwareQueryVisitor(this.getQueryCreationContextWithDeterminedProjects(), (Clause)andClause));
            if (queryFactoryResult.mustNotOccur()) {
                booleanQuery.add(queryFactoryResult.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(queryFactoryResult.getLuceneQuery(), BooleanClause.Occur.MUST);
        }
        return new QueryFactoryResult((Query)booleanQuery.build());
    }

    public QueryFactoryResult visit(OrClause orClause) {
        ContextAwareQueryVisitor.assertClauseNotTooComplex((Clause)orClause);
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        for (Clause clause : orClause.getClauses()) {
            QueryFactoryResult queryFactoryResult = (QueryFactoryResult)clause.accept((ClauseVisitor)this.createContextAwareQueryVisitor(this.getQueryCreationContextWithDeterminedProjects(), (Clause)orClause));
            booleanQuery.add(QueryVisitorUtil.makeQuery(queryFactoryResult), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)booleanQuery.build());
    }

    public QueryFactoryResult visit(NotClause notClause) {
        throw new IllegalStateException("We have removed all the NOT clauses from the query, this should never occur.");
    }

    public QueryFactoryResult visit(TerminalClause terminalClause) {
        Collection<ClauseQueryFactory> clauseQueryFactories = this.queryRegistry.getClauseQueryFactory(this.queryCreationContext, terminalClause);
        if (clauseQueryFactories.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        QueryCreationContext contextWithClause = this.getQueryCreationContextWithDeterminedProjects();
        try {
            if (clauseQueryFactories.size() == 1) {
                ClauseQueryFactory factory = clauseQueryFactories.iterator().next();
                return factory.getQuery(contextWithClause, terminalClause);
            }
            BooleanQuery.Builder query = new BooleanQuery.Builder();
            for (ClauseQueryFactory factory : clauseQueryFactories) {
                query.add(QueryVisitorUtil.makeQuery(factory.getQuery(contextWithClause, terminalClause)), BooleanClause.Occur.SHOULD);
            }
            return new QueryFactoryResult((Query)query.build());
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            throw new JqlTooComplex((Clause)terminalClause);
        }
        catch (JqlTooComplex jqlTooComplex) {
            throw new JqlTooComplex((Clause)terminalClause);
        }
    }

    public QueryFactoryResult visit(WasClause clause) {
        return this.wasClauseQueryFactory.create(this.queryCreationContext.getUser(), clause);
    }

    public QueryFactoryResult visit(ChangedClause clause) {
        return this.changedClauseQueryFactory.create(this.queryCreationContext.getUser(), clause);
    }

    private QueryCreationContext getQueryCreationContextWithDeterminedProjects() {
        Set<String> determinedProjectsFromParent = this.determinedProjectsExtractor.extractDeterminedProjectsFromClause(this.parentClause);
        Set<String> determinedProjects = this.intersectDeterminedProjects(this.queryCreationContext.getDeterminedProjects(), determinedProjectsFromParent);
        return new QueryCreationContextImpl(this.queryCreationContext, determinedProjects);
    }

    private Set<String> intersectDeterminedProjects(Set<String> projectsFromGrandParent, Set<String> projectsFromParent) {
        if (projectsFromGrandParent.isEmpty()) {
            return projectsFromParent;
        }
        if (projectsFromParent.isEmpty()) {
            return projectsFromGrandParent;
        }
        return ImmutableSet.copyOf((Collection)Sets.intersection(projectsFromGrandParent, projectsFromParent));
    }

    private ContextAwareQueryVisitor createContextAwareQueryVisitor(QueryCreationContext contextWithClause, Clause clause) {
        return new ContextAwareQueryVisitor(this.queryRegistry, this.wasClauseQueryFactory, this.changedClauseQueryFactory, contextWithClause, clause);
    }

    private static void assertClauseNotTooComplex(Clause clause) {
        if (clause.getClauses().size() > BooleanQuery.getMaxClauseCount()) {
            throw new JqlTooComplex(clause);
        }
    }

    static class JqlTooComplex
    extends RuntimeException {
        private final Clause clause;

        JqlTooComplex(Clause clause) {
            this.clause = clause;
        }

        public Clause getClause() {
            return this.clause;
        }
    }

    @InjectableComponent
    public static class ContextAwareQueryVisitorFactory {
        private final QueryRegistry queryRegistry;
        private final WasClauseQueryFactory wasClauseQueryFactory;
        private final ChangedClauseQueryFactory changedClauseQueryFactory;

        public ContextAwareQueryVisitorFactory(QueryRegistry queryRegistry, WasClauseQueryFactory wasClauseQueryFactory, ChangedClauseQueryFactory changedClauseQueryFactory) {
            this.queryRegistry = (QueryRegistry)Assertions.notNull((String)"queryRegistry", (Object)queryRegistry);
            this.wasClauseQueryFactory = wasClauseQueryFactory;
            this.changedClauseQueryFactory = changedClauseQueryFactory;
        }

        public ContextAwareQueryVisitor createVisitor(QueryCreationContext queryCreationContext, Clause parentClause) {
            return new ContextAwareQueryVisitor(this.queryRegistry, this.wasClauseQueryFactory, this.changedClauseQueryFactory, queryCreationContext, parentClause);
        }

        public ContextAwareQueryVisitor createVisitorWithCustomQueryRegistry(QueryCreationContext queryCreationContext, Clause parentClause, QueryRegistry customQueryRegistry) {
            return new ContextAwareQueryVisitor(customQueryRegistry, this.wasClauseQueryFactory, this.changedClauseQueryFactory, queryCreationContext, parentClause);
        }
    }
}

