/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.AbstractPropertyClauseQueryFactory;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.IssuePropertyClauseValidator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.List;

public class IssuePropertyClauseQueryFactory
extends AbstractPropertyClauseQueryFactory {
    private final PluginIndexConfigurationManager pluginIndexConfigurationManager;

    public IssuePropertyClauseQueryFactory(PluginIndexConfigurationManager pluginIndexConfigurationManager, DoubleConverter doubleConverter, JqlDateSupport jqlDateSupport, JqlOperandResolver operandResolver, JiraAuthenticationContext authenticationContext) {
        super(doubleConverter, jqlDateSupport, operandResolver, authenticationContext);
        this.pluginIndexConfigurationManager = pluginIndexConfigurationManager;
    }

    @Override
    protected Option<Property> getProperty(TerminalClause terminalClause) {
        return terminalClause.getProperty();
    }

    @Override
    protected boolean isSupportedOperator(TerminalClause terminalClause) {
        return IssuePropertyClauseValidator.isSupportedOperator(terminalClause.getOperator());
    }

    @Override
    protected Iterable<IndexDocumentConfiguration.Type> getPropertyTypes(Property property) {
        Iterable<PluginIndexConfiguration> configurations = this.pluginIndexConfigurationManager.getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName());
        final String propertyKey = property.getKeysAsString();
        final String objRef = property.getObjectReferencesAsString();
        Iterable keyConfigurations = Iterables.concat((Iterable)Iterables.transform(configurations, (Function)new Function<PluginIndexConfiguration, List<IndexDocumentConfiguration.KeyConfiguration>>(){

            public List<IndexDocumentConfiguration.KeyConfiguration> apply(PluginIndexConfiguration indexConfiguration) {
                return indexConfiguration.getIndexDocumentConfiguration().getKeyConfigurations();
            }
        }));
        Iterable filteredConfigurations = Iterables.filter((Iterable)keyConfigurations, (Predicate)new Predicate<IndexDocumentConfiguration.KeyConfiguration>(){

            public boolean apply(IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
                return keyConfiguration.getPropertyKey().equals(propertyKey);
            }
        });
        Iterable extractConfigurations = Iterables.concat((Iterable)Iterables.transform((Iterable)filteredConfigurations, (Function)new Function<IndexDocumentConfiguration.KeyConfiguration, List<IndexDocumentConfiguration.ExtractConfiguration>>(){

            public List<IndexDocumentConfiguration.ExtractConfiguration> apply(IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
                return keyConfiguration.getExtractorConfigurations();
            }
        }));
        return Iterables.transform((Iterable)Iterables.filter((Iterable)extractConfigurations, (Predicate)new Predicate<IndexDocumentConfiguration.ExtractConfiguration>(){

            public boolean apply(IndexDocumentConfiguration.ExtractConfiguration extractConfig) {
                return extractConfig.getPath().equals(objRef);
            }
        }), (Function)new Function<IndexDocumentConfiguration.ExtractConfiguration, IndexDocumentConfiguration.Type>(){

            public IndexDocumentConfiguration.Type apply(IndexDocumentConfiguration.ExtractConfiguration extractConfiguration) {
                return extractConfiguration.getType();
            }
        });
    }
}

