/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.EqualityQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.UserIndexInfoResolver;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

class PermissionClauseQueryFactory
implements ClauseQueryFactory {
    private final ClauseQueryFactory clauseQueryFactory;
    private final PermissionQueryFactory permissionQueryFactory;
    private final JqlOperandResolver operandResolver;
    private final CurrentUser currentUser;
    private final IndexInfoResolver<ApplicationUser> infoResolver;
    private final ProjectPermissionKey permissionKey;
    private final ProjectManager projectManager;

    static PermissionClauseQueryFactory create(JqlOperandResolver operandResolver, UserResolver userResolver, PermissionQueryFactory permissionQueryFactory, String field) {
        UserIndexInfoResolver indexInfoResolver = new UserIndexInfoResolver((NameResolver)userResolver);
        List<EqualityQueryFactory> operatorQueryFactory = Collections.singletonList(new EqualityQueryFactory((IndexInfoResolver)indexInfoResolver));
        GenericClauseQueryFactory clauseQueryFactory = new GenericClauseQueryFactory(field, operatorQueryFactory, operandResolver);
        PermissionClauseQueryFactory permissionClauseQueryFactory = new PermissionClauseQueryFactory((ClauseQueryFactory)clauseQueryFactory, permissionQueryFactory, operandResolver, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, new OverrideField(field), (IndexInfoResolver<ApplicationUser>)indexInfoResolver);
        return permissionClauseQueryFactory;
    }

    PermissionClauseQueryFactory(ClauseQueryFactory clauseQueryFactory, PermissionQueryFactory permissionQueryFactory, JqlOperandResolver operandResolver, ProjectPermissionKey permissionKey, CurrentUser currentUser, IndexInfoResolver<ApplicationUser> infoResolver) {
        this.clauseQueryFactory = (ClauseQueryFactory)Assertions.notNull((String)"clauseQueryFactory", (Object)clauseQueryFactory);
        this.permissionQueryFactory = (PermissionQueryFactory)Assertions.notNull((String)"permissionQueryFactory", (Object)permissionQueryFactory);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.currentUser = (CurrentUser)Assertions.notNull((String)"currentUser", (Object)currentUser);
        this.infoResolver = (IndexInfoResolver)Assertions.notNull((String)"infoResolver", infoResolver);
        this.permissionKey = permissionKey;
        this.projectManager = ComponentAccessor.getProjectManager();
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        QueryFactoryResult delegateResult = this.clauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        if (queryCreationContext.isSecurityOverriden()) {
            return delegateResult;
        }
        Query permissionQuery = this.getPermissionQuery(queryCreationContext, terminalClause);
        if (permissionQuery == null) {
            return delegateResult;
        }
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.add(delegateResult.getLuceneQuery(), BooleanClause.Occur.MUST);
        query.add(permissionQuery, BooleanClause.Occur.MUST);
        return new QueryFactoryResult((Query)query.build(), delegateResult.mustNotOccur());
    }

    Query getPermissionQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        ApplicationUser user = queryCreationContext.getUser();
        List values = this.operandResolver.getValues(queryCreationContext, terminalClause.getOperand(), terminalClause);
        CurrentUser.Presence userPresence = CurrentUser.Presence.get(user, values, this.infoResolver);
        Collection determinedProjects = this.projectManager.getProjectsByArgs((Collection)queryCreationContext.getDeterminedProjects());
        Query permissionQuery = determinedProjects.isEmpty() ? this.permissionQueryFactory.getQuery(user, this.permissionKey) : this.permissionQueryFactory.getQuery(user, this.permissionKey, determinedProjects);
        return this.currentUser.rewrite(permissionQuery, userPresence, user, this.infoResolver);
    }

    static class OverrideField
    implements CurrentUser {
        private final String field;

        public OverrideField(String field) {
            this.field = field;
        }

        @Override
        public Query rewrite(Query query, CurrentUser.Presence hasUser, ApplicationUser user, IndexInfoResolver<ApplicationUser> resolver) {
            switch (hasUser) {
                case NOT: {
                    return query;
                }
                case ONLY: {
                    return null;
                }
                case CONTAINS: {
                    BooleanQuery.Builder result = new BooleanQuery.Builder();
                    result.add((Query)new TermQuery(new Term(this.field, user.getKey())), BooleanClause.Occur.SHOULD);
                    result.add(query, BooleanClause.Occur.SHOULD);
                    return result.build();
                }
            }
            throw new IllegalArgumentException("Unknown Presence: " + hasUser);
        }
    }

    static interface CurrentUser {
        public Query rewrite(Query var1, Presence var2, ApplicationUser var3, IndexInfoResolver<ApplicationUser> var4);

        public static enum Presence {
            NOT,
            CONTAINS,
            ONLY;


            static Presence get(ApplicationUser user, Collection<QueryLiteral> values, IndexInfoResolver<ApplicationUser> resolver) {
                boolean hasUser;
                boolean bl = hasUser = user != null && CollectionUtil.contains(values, (Predicate)new UserEquals(user, resolver));
                return !hasUser ? NOT : (values.size() == 1 ? ONLY : CONTAINS);
            }
        }
    }

    static class UserEquals
    implements Predicate<QueryLiteral> {
        private final String expectedUserKey;
        private final IndexInfoResolver<ApplicationUser> infoResolver;

        UserEquals(ApplicationUser user, IndexInfoResolver<ApplicationUser> infoResolver) {
            this.expectedUserKey = user.getKey();
            this.infoResolver = infoResolver;
        }

        public boolean evaluate(QueryLiteral literal) {
            if (literal.isEmpty()) {
                return false;
            }
            for (String userKey : this.infoResolver.getIndexedValues(literal.asString())) {
                if (!this.expectedUserKey.equals(userKey)) continue;
                return true;
            }
            return false;
        }
    }
}

